<?php
/**
 * Blog Main File.
 *
 * @package deeds
 * @author  Webinane
 * @version 1.0
 */


get_header();
global $wp_query;
$data = \deeds\Includes\Classes\Common::instance()->data('blog')->get();
$class = ($data->get('layout') != 'full') ? 'col-xs-12 col-sm-12 col-md-12 col-lg-8' : 'col-xs-12 col-sm-12 col-md-12';
do_action('deeds_banner', $data);

if (class_exists('\Elementor\Plugin') and $data->get('tpl-type') == 'e' and $data->get('tpl-elementor')) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($data->get('tpl-elementor'));
} else {
	?>
	<section>
		<?php
		// Fetch the banner settings from Redux
		$banner_settings = get_option('deeds_banner_settings');

		$banner_source_type = isset($banner_settings['banner_source_type']) ? $banner_settings['banner_source_type'] : 'd';
		$banner_page_banner = isset($banner_settings['banner_page_banner']) ? $banner_settings['banner_page_banner'] : false;
		$banner_banner_title = isset($banner_settings['banner_banner_title']) ? $banner_settings['banner_banner_title'] : '';
		$banner_page_background = isset($banner_settings['banner_page_background']['url']) ? $banner_settings['banner_page_background']['url'] : '';

		if ($banner_source_type === 'd' && $banner_page_banner) {
			?>
			<div class="banner-section" style="background-image: url('<?php echo esc_url($banner_page_background); ?>');">
				<div class="banner-content">
					<h1><?php echo esc_html($banner_banner_title); ?></h1>
				</div>
			</div>
			<?php
		} elseif ($banner_source_type === 'e') {
			// Check if the Elementor template is selected and Elementor is active
			if (class_exists('\Elementor\Plugin') && !empty($banner_settings['banner_elementor_template'])) {
				echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($banner_settings['banner_elementor_template']);
			}
		}
		?>

		<div class="gap">
			<div class="container">
				<div class="row blog-page">
					<?php
					if ($data->get('layout') == 'left') {
						do_action('deeds_sidebar', $data);
					}
					?>
					<div class="<?php echo esc_attr($class); ?>">
						<?php
						while (have_posts()):
							the_post();
							deeds_template_load('templates/blog/blog.php', compact('data'));
						endwhile;
						wp_reset_postdata();
						deeds_the_pagination($wp_query->max_num_pages);
						?>
					</div>
					<?php
					if ($data->get('layout') == 'right') {
						do_action('deeds_sidebar', $data);
					}
					?>
				</div>
			</div>
		</div>
	</section>
	<?php
}
get_footer();
