<?php

return array(
	'title'      => esc_html__( 'Tag Page Settings', 'deeds' ),
	'id'         => 'tag_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'tag_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Tag Source Type', 'deeds' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'deeds' ),
				'e' => esc_html__( 'Elementor', 'deeds' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'tag_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'deeds' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'=> -1,
			],
			'required' => [ 'tag_source_type', '=', 'e' ],
		),

		array(
			'id'       => 'tag_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Tag Default', 'deeds' ),
			'indent'   => true,
			'required' => [ 'tag_source_type', '=', 'd' ],
		),
		array(
			'id'      => 'tag_page_banner',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Banner', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show banner on blog', 'deeds' ),
			'default' => true,
		),
		array(
			'id'       => 'tag_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'deeds' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'deeds' ),
			'required' => array( 'tag_page_banner', '=', true ),
		),
		array(
			'id'       => 'tag_page_breadcrumb',
			'type'     => 'raw',
			'content'  => "<div style='background-color:#c33328;color:white;padding:20px;'>" . esc_html__( 'Use Yoast SEO plugin for breadcrumb.', 'deeds' ) . "</div>",
			'required' => array( 'tag_page_banner', '=', true ),
		),
		array(
			'id'       => 'tag_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'deeds' ),
			'desc'     => esc_html__( 'Insert background image for banner', 'deeds' ),
			'default'  => array(
				'url' => deeds_URI . 'assets/images/top-title-bg.jpg',
			),
			'required' => array( 'tag_page_banner', '=', true ),
		),

		array(
			'id'       => 'tag_sidebar_layout',
			'type'     => 'image_select',
			'title'    => esc_html__( 'Layout', 'deeds' ),
			'subtitle' => esc_html__( 'Select main content and sidebar alignment.', 'deeds' ),
			'options'  => array(

				'left'  => array(
					'alt' => esc_html__( '2 Column Left', 'deeds' ),
					'img' => get_template_directory_uri() . '/assets/images/2cl.png',
				),
				'full'  => array(
					'alt' => esc_html__( '1 Column', 'deeds' ),
					'img' => get_template_directory_uri() . '/assets/images/1col.png',
				),
				'right' => array(
					'alt' => esc_html__( '2 Column Right', 'deeds' ),
					'img' => get_template_directory_uri() . '/assets/images/2cr.png',
				),
			),

			'default' => 'right',
		),

		array(
			'id'       => 'tag_page_sidebar',
			'type'     => 'select',
			'title'    => esc_html__( 'Sidebar', 'deeds' ),
			'desc'     => esc_html__( 'Select sidebar to show at blog listing page', 'deeds' ),
			'required' => array(
				array( 'tag_sidebar_layout', '=', array( 'left', 'right' ) ),
			),
			'options'  => deeds_get_sidebars(),
		),
		array(
			'id'      => 'tag_post_comments',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Post Comments', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show post comments on posts listing', 'deeds' ),
			'default' => true,
		),

		array(
			'id'      => 'tag_post_author',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show author on posts listing', 'deeds' ),
			'default' => true,
		),
		array(
			'id'      => 'tag_post_date',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Post Date', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show post data on posts listing', 'deeds' ),
			'default' => true,
		),
		array(
			'id'       => 'tag_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'tag_source_type', '=', 'd' ],
		),
	),
);





