<?php

return array(
	'title'      => esc_html__( 'Single Post Settings', 'deeds' ),
	'id'         => 'single_post_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'single_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Single Post Source Type', 'deeds' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'deeds' ),
				'e' => esc_html__( 'Elementor', 'deeds' ),
			),
			'default' => 'd',
		),

		array(
			'id'       => 'single_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Default', 'deeds' ),
			'indent'   => true,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
		array(
			'id'      => 'single_post_date',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Date', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show post publish date on posts detail page', 'deeds' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_author',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show author on posts detail page', 'deeds' ),
			'default' => false,
		),

		array(
			'id'      => 'single_post_comments',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Comments', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show number of comments on posts single page', 'deeds' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_cat',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Category', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show post category on posts single page', 'deeds' ),
			'default' => false,
		),

		array(
			'id'      => 'single_post_tag',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tags', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show post tags on posts single page', 'deeds' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_share',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Social Share', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show social Share options', 'deeds' ),
			'default' => false,
		),
		array(
			'id'       => 'single_social_share',
			'type'     => 'sortable',
			'title'    => esc_html__( 'Post Sharing Icons', 'deeds' ),
			'subtitle' => esc_html__( 'Select icons to activate social sharing icons in post detail page', 'deeds' ),
			'required' => array( 'blog_post_share', '=', true ),
			'mode'     => 'checkbox',
			'required' => array( 'single_post_share', '=', true ),
			'options'  => array(
				'facebook'    => esc_html__( 'Facebook', 'deeds' ),
				'twitter'     => esc_html__( 'Twitter', 'deeds' ),
				'gplus'       => esc_html__( 'Google Plus', 'deeds' ),
				'digg'        => esc_html__( 'Digg Digg', 'deeds' ),
				'reddit'      => esc_html__( 'Reddit', 'deeds' ),
				'linkedin'    => esc_html__( 'Linkedin', 'deeds' ),
				'pinterest'   => esc_html__( 'Pinterest', 'deeds' ),
				'stumbleupon' => esc_html__( 'Sumbleupon', 'deeds' ),
				'tumblr'      => esc_html__( 'Tumblr', 'deeds' ),
				'email'       => esc_html__( 'Email', 'deeds' ),
			),
		),

		array(
			'id'      => 'single_post_author_box',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author Box', 'deeds' ),
			'desc'    => esc_html__( 'Enable to show author box on post detail page.', 'deeds' ),
			'default' => false,
		),
		array(
			'id'       => 'single_section_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
	),
);





