<?php
$styles = [];
foreach(range(1, 28) as $val) {
    $styles[$val] = sprintf(esc_html__('Style %s', 'deeds'), $val);
}

return  array(
    'title'      => esc_html__( 'General Setting', 'deeds' ),
    'id'         => 'general_setting',
    'desc'       => '',
    'icon'       => 'el el-wrench',
    'fields'     => array(
        array(
            'id' => 'theme_color_scheme',
            'type' => 'color',
            'output' => array('.site-title'),
            'title' => esc_html__('Color Scheme', 'deeds'),
            'default' => '#2fc7b6',
            'transparent' => false
        ),
        array(
            'id' => 'theme_preloader',
            'type' => 'switch',
            'title' => esc_html__('Enable Preloader', 'deeds'),
            'default' => true,
        ),
        array(
            'id' => 'theme_preloader_style',
            'type' => 'select',
            'title' => esc_html__('Preloader Style', 'deeds'),
            'default' => '3',
            'options'   => $styles,
            'required' => [ 'theme_preloader', '=', true ],
        ),
        
    ),
);
