<?php

return array(
	'title' => esc_html__('Banner Settings', 'deeds'),
	'id' => 'banner_settings',
	'desc' => '',
	'subsection' => true,
	'fields' => array(
		array(
			'id'         => 'banner_style',
            'type'       => 'image_select',
            'title'      => esc_html__( 'Style', 'deeds' ),
            'options'    => [
                'style1' => [
                    'alt' => esc_html__( 'Banner 1', 'deeds' ),
                    'img' => get_template_directory_uri() . '/assets/images/banner-image/parallax1.jpg',
                ],
            ],
            'default'    => 'style1',
            'full_width' => true,

		),
		array(
			'id'       => 'banner_img',
            'type'     => 'media', 
            'url'      => true,
            'title'    => esc_html__('Banner Image', 'deeds'),
            'subtitle' => esc_html__('Upload image using the WordPress native uploader for banner image.', 'deeds'),

		),
		array(
			'id'         => 'banner_title_limit',
            'type'       => 'text',
            'title'      => esc_html__( 'Title Limit', 'deeds' ),
            'default'    => 5,

		),
		array(
			'id'       => 'breadcrumb-switch',
            'type'     => 'switch', 
            'title'    => esc_html__('Enable BreadCrumb', 'deeds'),
            'subtitle' => esc_html__('Enable / Disable BreadCrumb', 'deeds'),
            'default'  => true,

		),
		array(		
			'id'         => 'banner_separator',
            'type'       => 'text',
            'title'      => esc_html__( 'BreadCrumb Separator', 'deeds' ),
            'default'    => '|',
		),
	),
);








