<?php

/**
 * Hookup all the tags here.
 *
 * @package deeds
 * @author  Shahbaz Ahmed <shahbazahmed9@hotmail.com>
 * @version 1.0
 */

/**
 * Load the default config
 */
function deeds_load_default_hooks() {

	$config = deeds_WSH()->config( 'default' );

	if ( is_array( $config ) ) {

		foreach ( $config as $key => $more ) {

			foreach ( $more as $k => $value ) {
				$func = is_array( $value ) ? $value[0] : $value;

				$priority = isset( $value[1] ) ? $value[1] : 99;
				$params   = isset( $value[2] ) ? $value[2] : 2;

				add_action( $key, $func, $priority, $params );
			}
		}
	}
}

function deeds_preloader() {
	$options     = deeds_WSH()->option();

	if( ! $options->get('theme_preloader')) {
		return;
	}

	?>
	<div class="pageloader" style="z-index: 999999;">
	      <div class="loader">
	        <?php include get_template_directory() . '/templates/loader.php' ?>
	      </div>	
	</div><!-- Pageloader -->
	<?php
}
/**
 * [deeds_main_header_area description]
 *
 * @return [type] [description]
 */


function deeds_main_header_area() {

	$options     = deeds_WSH()->option();
    
    $header_type = '';
    $header_e = 0;
    $header_d = '';

    if( is_page() ) {
        $header_type = get_post_meta( get_the_ID(), 'header_source_type', true );
        $header_e    = get_post_meta( get_the_ID(), 'header_new_elementor_template', true );
        $header_d    = get_post_meta( get_the_ID(), 'header_type', true );
	}
	
	if( ! $header_type || $header_type == 'd' ) {
	    
    	$header_type = $options->get( 'header_source_type' );
        $header_e = $options->get('header_elementor_template');
        $header_d = $options->get('header_type');
        
	}

// echo $header_type;
// echo $header_e;exit;
        if ( $header_type == 'e' AND class_exists( '\Elementor\Plugin' ) AND $header_e ) {
            echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_e );

            return false;
        } elseif ( $header_type == 'd' AND class_exists( '\Elementor\Plugin' ) AND $header_d ) {
            $header = $header_d;
        } else {
            $header = $options->get( 'header_type' );
        }


	if ( $header == '1' ) {
		deeds_template_load( 'templates/header/header2.php' );
	} elseif ( $header == '3' ) {
		deeds_template_load( 'templates/header/header3.php' );
	} elseif ( $header == '2' ) {
		deeds_template_load( 'templates/header/header.php' );
	} else {
		deeds_template_load( 'templates/header/default-header.php' );
	}
}

/**
 * [deeds_sidebar description]
 *
 * @return [type] [description]
 */

function deeds_sidebar( $data ) {

	deeds_template_load( 'templates/sidebar.php', compact( 'data' ) );
}

/**
 * deeds banner.
 *
 * @return [type] [description]
 */
function deeds_banner( $data = [] ) {
	$name = deeds\Includes\Classes\Base::get_pagename();
	$data = deeds\Includes\Classes\Common::instance()->data( $name )->get();

	if( $data != '' ) {
		deeds_template_load( 'templates/banner/banner.php', compact( 'data' ) );
	}
	
}