<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline\Classes;

class WoocommerceCustomize {

	public static function init() {
		self::remove();
		self::add();
	}

	/**
	 * remove
	 *
	 * @return void
	 */
	public static function remove() {
		add_filter( 'woocommerce_show_page_title', '__return_null' );
		remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
		remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
		remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
		remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
		remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
		remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
		remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
		remove_action( 'woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10 );
		// remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
		// remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

		remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation', 10 );
	}

	/**
	 * add
	 *
	 * @return void
	 */
	public static function add() {
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 4 );
		add_action( 'woocommerce_before_main_content', array( __CLASS__, 'wrapper_start' ), 10 );
		add_action( 'woocommerce_after_main_content', array( __CLASS__, 'wrapper_end' ), 10 );
		add_filter( 'woocommerce_product_loop_start', array( __CLASS__, 'shop_loop_start' ) );
		add_filter( 'woocommerce_product_loop_end', array( __CLASS__, 'shop_loop_end' ) );
		add_action( 'woocommerce_after_shop_loop_item_title', array( __CLASS__, 'shop_loop_title' ), 9 );
		add_action( 'woocommerce_before_shop_loop_item_title', array( __CLASS__, 'shop_loop_label' ), 10  );
		add_action( 'woocommerce_before_shop_loop_item_title', array( __CLASS__, 'shop_loop_thumbnail' ), 10 );
		add_action( 'woocommerce_before_shop_loop_item', array( __CLASS__, 'before_shop_loop' ), 8 );
		add_action( 'woocommerce_after_shop_loop_item', array( __CLASS__, 'after_shop_loop' ), 11 );
		add_filter( 'woocommerce_form_field_args', array( __CLASS__, 'woocommerce_form_field_args' ), 11, 3 );
		add_action( 'woocommerce_before_single_product_summary', array( __CLASS__, 'shop_detail_html_in' ), 0 );
		add_action( 'woocommerce_after_single_product_summary', array( __CLASS__, 'shop_detail_html_end' ), 0 );
		add_filter( 'woocommerce_single_product_image_gallery_classes', array( __CLASS__, 'shop_detail_img_classes' ) );
		add_action( 'woocommerce_share', array( __CLASS__, 'shop_detail_share' ) );
		add_filter( 'woocommerce_cross_sells_columns', array( __CLASS__, 'cross_sale_count_mod' ), 20 );
		add_action( 'customize_register', array( __CLASS__, 'modify_options' ), 100 );
		add_filter( 'comment_form_fields', array( __CLASS__, 'shop_detail_comment_fields_order' ) );
		add_filter('comment_form_defaults',array(__CLASS__, 'comment_notes'));
		// add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function ( $size )
		// {
		// 	return [
		// 		'width'  => 110,
		// 		'height' => 110,
		// 		'crop'   => 1,
		// 	];
		// }, 100 );
		add_action( 'woocommerce_after_shop_loop', array( __CLASS__, 'woocommerce_custom_pagination' ) );
		// add_filter( 'loop_shop_per_page', 'product_loop_shop_per_page', 20 );
		//add_filter('woocommerce_variable_price_html', array( __CLASS__, 'custom_from' ),10);
		add_action( 'woocommerce_before_variations_form', 'woocommerce_single_variation' );		
	}

	/**
	 * wrapper_start
	 *
	 * @return void
	 */
	public static function wrapper_start() {
		echo '<section>';
		echo '<div class="pt-80 gap pb-50 bg-gray position-relative w-100">';
		echo '<div class="container">';
		echo '<div class="product-wrap w-100">';
	}

	/**
	 * wrapper_end
	 *
	 * @return void
	 */
	public static function wrapper_end() {
		echo '</div>';
		echo '</div>';
		echo '</div>';
		echo '</section>';
	}

	/**
	 * shop_loop_start
	 *
	 * @return void
	 */
	public static function shop_loop_start() {
		echo '<div class="row products">';
	}

	/**
	 * shop_loop_end
	 *
	 * @return void
	 */
	public static function shop_loop_end() {
		echo '</div>';
	}

	/**
	 * shop_loop_title
	 *
	 * @return void
	 */
	public static function shop_loop_title() {
		echo '<h3 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'font-weight-extrabold text-dark woocommerce-loop-product__title' ) ) . '"><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h3>';
	}

	/**
	 * shop_loop_cart
	 *
	 * @param  mixed $args
	 * @return void
	 */
	public static function shop_loop_cart( $args = array() ) {
		global $product;

		if ( $product ) {
			$defaults = array(
				'quantity'   => 1,
				'class'      => implode(
					' ',
					array_filter(
						array(
							'button',
							'product_type_' . $product->get_type(),
							$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
							$product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
							'text-white',
							'position-absolute',
							'center-content',
							'rounded',
							'theme-btn',
						)
					)
				),
				'attributes' => array(
					'data-product_id'  => $product->get_id(),
					'data-product_sku' => $product->get_sku(),
					'aria-label'       => $product->add_to_cart_description(),
					'rel'              => 'nofollow',
				),
			);

			$args = apply_filters( 'woocommerce_loop_add_to_cart_args', wp_parse_args( $args, $defaults ), $product );

			if ( isset( $args['attributes']['aria-label'] ) ) {
				$args['attributes']['aria-label'] = wp_strip_all_tags( $args['attributes']['aria-label'] );
			}

			echo apply_filters(
				'woocommerce_loop_add_to_cart_link',
				sprintf(
					'<a href="%s" data-quantity="%s" class="%s" %s>ADD TO CART</a>',
					esc_url( $product->add_to_cart_url() ),
					esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
					esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
					isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : ''
				),
				$product,
				$args
			);
		}
	}

	/**
	 * shop_loop_thumbnail
	 *
	 * @return void
	 */
	public static function shop_loop_thumbnail() {
		echo '<div class="product-img position-relative">';
		echo woocommerce_get_product_thumbnail();
		$args = array();
		self::shop_loop_cart( $args );// phpcs:ignore WordPress
		echo '</div>';
	}

	/**
	 * shop_loop_label
	 *
	 * @return void
	 */
	public static function shop_loop_label() {
		global $product;
		if( $product->is_featured() ) {
			echo '<span class="onhot" >' . esc_html__( 'Hot', 'lifeline' ) . '</span>';
		}
	}

	/**
	 * before_shop_loop
	 *
	 * @return void
	 */
	public static function before_shop_loop() {
		echo '<div class="product-box mb-30 text-center bg-white w-100">';
	}

	/**
	 * after_shop_loop
	 *
	 * @return void
	 */
	public static function after_shop_loop() {
		echo '</div>';
	}


	/**
	 * woocommerce_form_field_args
	 *
	 * @param  mixed $args
	 * @param  mixed $key
	 * @param  mixed $value
	 * @return void
	 */
	public static function woocommerce_form_field_args( $args, $key, $value ) {
		$args['class'][] = 'form-group';

		// add form-control to the actual input
		$args['input_class'][] = 'form-control';
		return $args;
	}

	/**
	 * shop_detail_html_in
	 *
	 * @return void
	 */
	public static function shop_detail_html_in() {
		echo '<div class="product-detail-wrap w-100">';
		echo '<div class="product-detail w-100">';
		echo '<div class="row align-items-center">';
	}

	/**
	 * shop_detail_html_end
	 *
	 * @return void
	 */
	public static function shop_detail_html_end() {
		echo '</div>';
		echo '</div>';
		echo '</div>';
	}

	/**
	 * shop_detail_img_classes
	 *
	 * @param  mixed $list
	 * @return void
	 */
	public static function shop_detail_img_classes( $list ) {
		$list_new = array(
			'col-md-12',
			'col-sm-12',
			'col-lg-5',
		);

		$list = wp_parse_args( $list_new, $list );

		return $list;
	}

	/**
	 * shop_detail_share
	 *
	 * @return void
	 */
	public static function shop_detail_share() {
		$opt = lifeline()->options();
		if ( ! lifeline_get( $opt, 'optIsProductSocial' ) ) {
			return;
		}
		$social_icons = lifeline_get( $opt, 'optProductSocial' );
		?>
		<div class="share-this w-100">
			<?php echo ( lifeline_get( $opt, 'optShareTitle' ) ) ? '<span class="mb-0 text-dark text-uppercase font-weight-semibold font-family-poppins d-inline-flex">' . lifeline_get( $opt, 'optShareTitle' ) . '</span>' : ''; ?>
			<div class="share-this-innr d-inline-flex">
				<?php
				foreach ( $social_icons as $k => $v ) {
					if ( $v !== '' ) {
						lifeline_social_share_output( $k );
					}
				}
				?>
			</div>
		</div>
		<?php
	}

	/**
	 * modify_options
	 *
	 * @return void
	 */
	public static function modify_options( $wp_customize ) {
		$wp_customize->add_control(
			'woocommerce_catalog_columns',
			array(
				'label'       => __( 'Product Column Number', 'woocommerce' ),
				'description' => __( 'How products should be shown per row?', 'woocommerce' ),
				'section'     => 'woocommerce_product_catalog',
				'settings'    => 'woocommerce_catalog_columns',
				'type'        => 'number',
				'input_attrs' => array(
					'min'  => wc_get_theme_support( 'product_grid::min_columns', 1 ),
					'max'  => wc_get_theme_support( 'product_grid::max_columns', '' ),
					'step' => 1,
				),
			)
		);

		$wp_customize->add_setting(
			'woocommerce_cross_sale_columns',
			array(
				'default'    => '6',
				'type'       => 'theme_mod',
				'capability' => 'edit_theme_options',
				'transport'  => 'postMessage',
			)
		);
		$wp_customize->add_control(
			'woocommerce_cross_sale_columns',
			array(
				'label'       => __( 'Cross Sale Product Columns', 'woocommerce' ),
				'description' => __( 'How products should be shown per row?', 'woocommerce' ),
				'section'     => 'woocommerce_product_catalog',
				'settings'    => 'woocommerce_cross_sale_columns',
				'type'        => 'number',
				'input_attrs' => array(
					'min'  => wc_get_theme_support( 'product_grid::min_columns', 1 ),
					'max'  => wc_get_theme_support( 'product_grid::max_columns', '' ),
					'step' => 1,
				),
			)
		);
	}

	/**
	 * cross_sale_count_mod
	 *
	 * @return void
	 */
	public static function cross_sale_count_mod() {
		return get_theme_mod( 'woocommerce_cross_sale_columns', '6' );
	}

	/**
	 * shop_detail_comment_fields_order
	 *
	 * @return void
	 */
	public static function shop_detail_comment_fields_order( $fields ) {
		if ( function_exists('is_product') && is_singular( 'product' ) ) {
			$comment_field = $fields['comment'];
			$author_field = $fields['author'];
			$email_field = $fields['email'];
			$cookies_field = $fields['cookies'];
			unset( $fields['comment'] );
			unset( $fields['author'] );
			unset( $fields['email'] );
			unset( $fields['cookies'] );
			// the order of fields is the order below, change it as needed:
			$fields['author'] = $author_field;
			$fields['email'] = $email_field;
			$fields['comment'] = $comment_field;
			$fields['cookies'] = $cookies_field;
			// done ordering, now return the fields:
		}
		
		return $fields;

	}

	/**
	 * comment_notes
	 *
	 * @return void
	 */
	public static function comment_notes($fields) {
		$fields['comment_notes_before'] = ''; 
		return $fields; 
	}

	/**
	 * woocommerce_custom_pagination
	 *
	 * @return void
	 */
	public static function woocommerce_custom_pagination() {
		lifeline_the_pagination_blog();
	}


	public static function product_loop_shop_per_page( $cols ) {
	  	$cols = 9;
	  	return $cols;
	}

	public static function custom_from($price){
	    return false;
	}

}
