<?php
/**
 * The header for our theme
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package deeds
 * @since   1.0
 * @version 1.0
 */

?>
	<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta content="IE=edge" http-equiv="X-UA-Compatible">
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
		<?php wp_head(); ?>
		<?php 

			if ( function_exists( 'deeds_remote_get_content' ) ) {
				$file_content = deeds_remote_get_content( get_template_directory_uri() . '/assets/css/color.css' );
			}

			if ( $file_content ) {
				$options = deeds_WSH()->option();
				// echo $options->get('theme_color_scheme');
				$style = str_replace( '#f26938', $options->get('theme_color_scheme') , $file_content );
				$net_style = '<style>' . $style . '</style>';
				echo $net_style;
			}

		?>
	</head>
<?php $options = deeds_WSH()->option(); ?>
<body <?php body_class( 'deeds-theme' ); ?>>
<main class="theme-layout">
	<?php wp_body_open(); ?>
	<?php  do_action( 'deeds_main_header' ); ?>






