<?php get_header(); ?>

<?php
$title_limit = $settings['title_limit'] ? $settings['title_limit'] : 10;
$content_limit = $settings['content_limit'] ? $settings['content_limit'] : 12; ?>
<section class="prayer-grid-style">
    <div class="container">
        <div class="row">
            <?php while (have_posts()):
                the_post(); ?>
                <div class="col-lg-4">
                    <div class="prayers-archive-img">
                        <figure>
                            <?php echo wp_kses_post(webinane_el_resizer()->resize(wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full'), 379, 204, true)); ?>
                        </figure>
                    </div>

                    <?php

                    $prayer_start_time = get_field('prayer_start_time');
                    $prayer_end_time = get_field('prayer_end_time');


                    if ($prayer_start_time && $prayer_end_time): ?>
                        <div class="prayers-time">
                            <?php echo esc_html($prayer_start_time); ?> - <?php echo esc_html($prayer_end_time); ?>
                        </div>
                    <?php endif; ?>


                    <div class="prayers-archive-content">
                        <div class="prayers-contnt-area">
                            <h2 class="prayers-title">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                    <?php echo wp_trim_words(get_the_title(), $title_limit); ?>
                                </a>
                            </h2>

                            <p class="prayers-short-desc">
                                <?php echo wp_trim_words(get_the_excerpt(), $content_limit, ''); ?>
                            </p>
                        </div>
                        <?php
                        $prayers_icon = get_field('prayers_icon');
                        $prayers_icon_size = 'full';
                        if ($prayers_icon) {
                            echo '<div class="deeds-prayers-archive-icon">' . wp_get_attachment_image($prayers_icon, $prayers_icon_size) . '</div>';
                        }
                        ?>
                    </div>
                </div>
            <?php endwhile; ?>

        </div>
    </div>
</section>
<?php get_footer(); ?>