<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// integrating cmb2 metaboxes in post type
add_action('cmb2_admin_init', 'celp_description_metaboxes');

/** creating settings panel using CMB2**/
function celp_description_metaboxes() {
	/**For exchange description settings**/

	/**
     * Initiate the metabox
     */
    $cmbdes = new_cmb2_box( array(
        'id'            => 'celp_exchange_des',
        'title'         => __( 'Exchange Description', 'celp1' ),
        'object_types'  => array( 'celp'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true, // Show field names on the left
	) );	

	$ex_id = '';
	// get exchange id from curreny post (if already saved)
	if( isset( $_GET['post'] ) ){
		$ex_id = get_post_meta( $_GET['post'], 'custom_ex_id', true);
	}

	// fetch all exchanges
	$all_celp_exc = celp_get_exchange_id_api_data();	
	// fetch already created custom exchange description
	$available_exchanges = celp_fetch_custom_exchanges();
	foreach( $available_exchanges as $exc ){
		// do not remove exchange id for current post
		if( !empty( $ex_id ) && $ex_id == $exc ) continue;
		unset( $all_celp_exc[ $exc ]);
	}

	$cmbdes->add_field( array(
	    'name'    => __('Select Exchange', 'celp'),
	    'desc'    => '',
	    'id'      => 'custom_ex_id',
	    'type'    => 'select',
	    'default' => '',
	    'options' => $all_celp_exc,
		'column' => array(
			'position' => 2,
			'name'     => __('Exchange Name', 'celp1'),
		),
	) );

	$cmbdes->add_field( array(
	    'name' => __( 'Description', 'celp' ),
	    'id' =>'custom_description',
	    'type' => 'wysiwyg',
	) );

	$cmbdes->add_field( array(
	    'name' => __( 'Affiliate Links', 'celp1' ),
	    'id' =>'affiliate_link',
	    'type' => 'text_url',
		'column' => array(
			'position' => 3,
			'name'     => __('Affiliate Links', 'celp1'),
		),
	) );
}