<?php

namespace Themeco\Cornerstone\Tss\Functions;

class FlexDirection extends BuiltInFunction {

  static private $rtl_rewrites = [
    'row' => 'row-reverse',
  ];

  public function run( $value, $noResolve = false ) {

    if (!is_rtl() || empty(get_option('cs_rtl_flex_fix', true))) {
      return $value;
    }

    $valStr = $value->value();

    if (empty(self::$rtl_rewrites[$valStr])) {
      return $value;
    }

    return self::$rtl_rewrites[$valStr];
  }

}
