(function($) {
    'use strict';
    let CMC_REQUEST = 'main_list';

    function cmc_get_watch_list() {
        if (localStorage.getItem('cmc_watch_list') === null) {
            return false;
        }
        let oldArr = localStorage.getItem('cmc_watch_list').split(',');
        let arr = new Array();
        if (oldArr.length !== false) {
            for (const el of oldArr) {
                arr.push(el);
            }
        }
        return arr;
    }
    const cmcformatCash = n => {
        if (n < 1e3) return n;
        if (n >= 1e3 && n < 1e6) return +(n / 1e3).toFixed(1) + data_object.localize_text.K;
        if (n >= 1e6 && n < 1e9) return +(n / 1e6).toFixed(1) + data_object.localize_text.M;
        if (n >= 1e9 && n < 1e12) return +(n / 1e9).toFixed(1) + data_object.localize_text.B;
        if (n >= 1e12) return +(n / 1e12).toFixed(1) + data_object.localize_text.T;
    };
    function cmcformatNumberWithDynamicDecimals(data,coma = true) {
        // Determine the maximum number of decimal places based on the number's magnitude
        const max_decimals = (Math.abs(data) >= 1) ? 2 : -Math.floor(Math.log10(Math.abs(data)));
        let max_decimals_points=(max_decimals>2)?max_decimals+3:max_decimals;

        // Format the number with a maximum of 18 decimal places
        const formattedString = Number(data).toFixed(18);
    
        // Remove trailing zeros and trailing decimal point
        const trimmedString = parseFloat(formattedString).toString().replace(/(\.[0-9]*[1-9])0+$/, '$1').replace(/\.$/, '');
    
        // Check if it's a very small number and format as '0' if needed
        if (trimmedString === '0') {
        return '0.00';
        }
    
        return Number(data).toLocaleString('en-US', {
        minimumFractionDigits:max_decimals_points?Math.max(2, max_decimals_points):2,
        maximumFractionDigits:max_decimals_points?Math.max(2, max_decimals_points):4, // Maximum of 2 decimal places for values greater than one
        useGrouping: coma
        });
    }

    var watchTitle, unwatchTitle;
    $.fn.cmcDatatable = function() {

        var $cmc_table = $(this);
        var columns = [];
        var fiatSymbol = $cmc_table.data('currency-symbol');
        var enableSearch = $cmc_table.data('datatable-search');
        var searchLabel = $cmc_table.data('search-label');
        var fiatCurrencyRate = $cmc_table.data('currency-rate');
        var category = $cmc_table.data('category');
        var pagination = $cmc_table.data('pagination');
        watchTitle = $cmc_table.data('watch-title');
        unwatchTitle = $cmc_table.data('unwatch-title');
        var totalCoins = $cmc_table.data('total-coins');
        var fiatCurrency = $cmc_table.data('old-currency');
        var preloaderPath = $cmc_table.find('thead').data('preloader');
        var prevtext = $cmc_table.data("prev-coins");
        var nexttext = $cmc_table.data("next-coins");
        var is_milbil_enable = $cmc_table.data('number-formating');
        var zeroRecords = $cmc_table.data("zero-records");
        var linksTab = $cmc_table.data("link-in-newtab");
        var loadingLbl = $cmc_table.data("loadinglbl");
        var defaultLogo = $cmc_table.parents('#cryptocurency-market-cap-wrapper').data('default-logo');
        var domain = data_object.domain_url;
        var storagename = 'cmc-selected-currency-' + domain;
        var predi_val = $cmc_table.data("predi");
        var predi_per = $cmc_table.data("prediper");
        var show_predi =  $cmc_table.data("showpredi");
        var post_id =  $cmc_table.data("post_id");
        $cmc_table.find('thead th').each(function(index) {
            var index = $(this).data('index');
            var thisTH = $(this);
            var classes = $(this).data('classes');
            columns.push({
                data: index,
                name: index,
                render: function(data, type, row, meta) {
                    
                    if (meta.settings.json === undefined) { return data; }
                    // console.log(index);
                    switch (index) {
                       
                        case 'rank':
                            // console.log(data);
                            if (localStorage.getItem('cmc_watch_list') !== null) {
                                let arr = cmc_get_watch_list();
                                let coin_exist = arr.findIndex(ar => { return ar == row.coin_id });
                                if (coin_exist > -1) {
                                    var html = '<div data-coin-id="' + row.coin_id + '" class="btn_cmc_watch_list cmc_onwatch_list cmc_icon-star" title="' + unwatchTitle + '"></div>';
                                } else {
                                    var html = '<div data-coin-id="' + row.coin_id + '" class="btn_cmc_watch_list cmc_icon-star-empty" title="' + watchTitle + '"></div>';
                                }
                            } else {
                                var html = '<div data-coin-id="' + row.coin_id + '" class="btn_cmc_watch_list cmc_icon-star-empty"></div>';
                            }
                            return html + ' ' + data;
                            break;
                        case 'name':
                            var singleUrl = thisTH.data('single-url');
                            var urlType = thisTH.data('url-type');
                            var tabLink = thisTH.data('link-in-newtab');
                            var link_target = '_self';
                            if (parseInt(tabLink) == 1) {
                                var link_target = '_blank';
                            }

                            if (urlType == "default") {
                                var url = singleUrl + '/' + row.symbol + '/' + row.coin_id + '/';
                            } else {
                                var url = singleUrl + '/' + row.symbol + '/' + row.coin_id + '/' + fiatCurrency + '/';
                            }

                            var html = '<div class="' + classes + '"><a target="' + link_target + '" title ="' + data + '" href = "' + url + '" style = "position: relative; overflow: hidden;" ><span class="cmc_coin_logo">                             <img style="width:32px;" id="' + data + '"  src="' + row.logo + '"  onerror="this.src=\'' + defaultLogo + '\';"></span>                             <span class="cmc_coin_symbol">(' + row.symbol + ')</span>                             <br>                             <span class="cmc_coin_name cmc-desktop">' + data + '</span>                             </a></div>';
                            return html;
                        case 'rating':
                                return cmca_rating_column(data); 
                                break;
                        case 'risco':
                               return cmca_risk_column(data);
                               break;
                        case 'price':
                            if (typeof data !== 'undefined' && data != null) {                          
                                const formatedValss = cmcformatNumberWithDynamicDecimals(data); 
                                var formatedVal = fiatSymbol+formatedValss ;
                                return html = '<div data-val="' + row.usd_price + '" class="' + classes + '"><span class="cmc-formatted-price">' + formatedVal + '</span></div>';
                            } else {
                                return html = '<div class="' + classes + '>?</div>';
                            }
                            break;
                        case 'percent_change_24h':
                            if (typeof data !== 'undefined' && data != null) {
                                var changesCls = "up";
                                var wrpchangesCls = "cmc-up";
                                if (typeof Math.sign === 'undefined') { Math.sign = function(x) { return x > 0 ? 1 : x < 0 ? -1 : x; } }
                                if (Math.sign(data) == -1) {
                                    var changesCls = "down";
                                    var wrpchangesCls = "cmc-down";
                                }
                                var html = '<div class="' + classes + ' ' + wrpchangesCls + '"><span class="changes ' + changesCls + '"><i class="cmc_icon-' + changesCls + '" aria-hidden="true"></i>' + data + '%</span></div>';
                                return html;
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'percent_change_7d':
                            if (typeof data !== 'undefined' && data != null) {
                                var changesCls = "up";
                                var wrpchangesCls = "cmc-up";
                                if (typeof Math.sign === 'undefined') { Math.sign = function(x) { return x > 0 ? 1 : x < 0 ? -1 : x; } }
                                if (Math.sign(data) == -1) {
                                    var changesCls = "down";
                                    var wrpchangesCls = "cmc-down";
                                }
                                var html = '<div class="' + classes + ' ' + wrpchangesCls + '"><span class="changes ' + changesCls + '"><i class="cmc_icon-' + changesCls + '" aria-hidden="true"></i>' + data + '%</span></div>';
                                return html;
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'percent_change_30d':
                            if (typeof data !== 'undefined' && data != null) {
                                var changesCls = "up";
                                var wrpchangesCls = "cmc-up";
                                if (typeof Math.sign === 'undefined') { Math.sign = function(x) { return x > 0 ? 1 : x < 0 ? -1 : x; } }
                                if (Math.sign(data) == -1) {
                                    var changesCls = "down";
                                    var wrpchangesCls = "cmc-down";
                                }
                                var html = '<div class="' + classes + ' ' + wrpchangesCls + '"><span class="changes ' + changesCls + '"><i class="cmc_icon-' + changesCls + '" aria-hidden="true"></i>' + data + '%</span></div>';
                                return html;
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'percent_change_1y':
                            if (typeof data !== 'undefined' && data != null) {
                                var changesCls = "up";
                                var wrpchangesCls = "cmc-up";
                                if (typeof Math.sign === 'undefined') { Math.sign = function(x) { return x > 0 ? 1 : x < 0 ? -1 : x; } }
                                if (Math.sign(data) == -1) {
                                    var changesCls = "down";
                                    var wrpchangesCls = "cmc-down";
                                }
                                var html = '<div class="' + classes + ' ' + wrpchangesCls + '"><span class="changes ' + changesCls + '"><i class="cmc_icon-' + changesCls + '" aria-hidden="true"></i>' + data + '%</span></div>';
                                return html;
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'market_cap':
                            var formatedVal = data;
                            if (formatedVal <= 0.00) {
                                return '<div class="' + classes + '">N/A</span></div>';
                            }
                            if (typeof is_milbil_enable != 'undefined' && is_milbil_enable == '1') {
                                formatedVal = cmcformatCash(data);
                            } else {
                                formatedVal = formatedVal.toString();
                            }
                            if (typeof data !== 'undefined' && data != null) {
                                return html = '<div data-val="' + row.usd_market_cap + '" class="' + classes + '">' + fiatSymbol + formatedVal + '</div>';
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'volume':
                            var formatedVal = data;
                            if (formatedVal <= 0.00) {
                                return '<div class="' + classes + '">N/A</span></div>';
                            }
                            if (typeof is_milbil_enable != 'undefined' && is_milbil_enable == '1') {
                                formatedVal = cmcformatCash(data);
                            } else {
                                formatedVal = formatedVal.toString();
                            }
                            if (typeof data !== 'undefined' && data != null) {
                                return html = '<div data-val="' + row.usd_volume + '" class="' + classes + '">' + fiatSymbol + formatedVal + '</div>';
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                            case 'auditado':
                            return cmca_audido_column(data, row);
                                break;

                        case 'supply':
                            if (data <= 0.00) {
                                return '<div class="' + classes + '">N/A</span></div>';
                            }
                            if (typeof data !== 'undefined' && data != null) {
                                var formatedVal = cmcformatCash(data);
                                return html = '<div class="' + classes + '">' + formatedVal.toUpperCase() + ' ' + row.symbol + '</div>';
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'ath':                           
                            if (typeof data !== 'undefined' && data != null) {                               
                                const formatedValss = cmcformatNumberWithDynamicDecimals(data); 
                                var formatedVal = fiatSymbol+formatedValss ;
                                return html = '<div data-val="' + row.usd_ath_price + '" class="' + classes + '">' + formatedVal + '</div>';
                            } else {
                                return html = '<div class="cmc-ath-no-val"><span>N/A</span></div>';
                            }
                            break;
                        case 'high_24h':
                                       
                           
                            if (typeof data != 'undefined' && data !== null) {                              
                                const formatedValss = cmcformatNumberWithDynamicDecimals(data); 
                                var formatedVal = fiatSymbol+formatedValss ;
                                return html = '<div data-val="' + row.usd_high_24h + '" class="' + classes + '">' +  formatedVal + '</div>';
                                // return html = '<div class="' + classes + '">'+high + '</div>';
                            } else {

                                return html = '<div class="' + classes + '"><span>N/A</span></div>';
                            }
                            break;
                        case 'low_24h':
                            var low = data;                         
                            if (typeof low !== 'undefined' && low != null) {                               
                                const formatedValss = cmcformatNumberWithDynamicDecimals(low); 
                                var formatedVal = fiatSymbol+formatedValss ;
                                return html = '<div data-val="' + row.usd_low_24h + '" class="' + classes + '">' +  formatedVal + '</div>';
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'ath_change_percentage':
                            var ath_chnage_per = data;
                            if (typeof ath_chnage_per !== 'undefined' && ath_chnage_per != null) {
                                var changesCls = "up";
                                var wrpchangesCls = "cmc-up";
                                if (typeof Math.sign === 'undefined') { Math.sign = function(x) { return x > 0 ? 1 : x < 0 ? -1 : x; } }
                                if (Math.sign(ath_chnage_per) == -1) {
                                    var changesCls = "down";
                                    var wrpchangesCls = "cmc-down";
                                }
                                var html = '<div class="' + classes + ' ' + wrpchangesCls + '"><span class="changes ' + changesCls + '"><i class="cmc_icon-' + changesCls + '" aria-hidden="true"></i>' + ath_chnage_per + '%</span></div>';
                                return html;                                
                            } else {
                                return html = '<div class="' + classes + '">?</span></div>';
                            }
                            break;
                        case 'ath_date':
                            
                            var ath_date = data;
                            var split_date = ath_date&&ath_date.split(' ')[0];
                            if (typeof split_date != 'undefined' && split_date != null && split_date != '0000-00-00') {
                                return html = '<div class="' + classes + '">' + split_date + '</div>';
                            } else {
                                return html = '<div class="' + classes + '">N/A</span></div>';
                            }
                            break;
                            // Prediction Collumn data dispaly here
                            case 'cmc_predi':
                            return cmca_prediction_column(data, row, classes, fiatSymbol);
                                break;
                            //Prediction Collumn data dispaly End here
                        case 'weekly_chart':                          
                            var chart_data = '';
                            var gChart = '';
                            //green
                            var dynamic_color = "data-bg-color='#90EE90' data-color='#006400'";
                            var chart_cls = 'weekly_up';
                            if (row.weekly_chart == "false") {
                                chart_data = "undefined";
                                var gChart = 'false';
                            } else {
                                chart_data = row.weekly_chart;
                                if (chart_data) {
                                    var data_array = JSON.parse(chart_data);
                                    var first_ele = data_array[0];
                                    var last_ele = data_array[data_array.length - 1];
                                    var gChart = 'true';
                                    if (parseFloat(last_ele) > parseFloat(first_ele)) {
                                        //green
                                        var dynamic_color = "data-bg-color='#90EE90' data-color='#006400'";
                                        var chart_cls = 'weekly_up';
                                    } else {
                                        //red 
                                        var dynamic_color = "data-bg-color='#ff9999' data-color='#ff0000'";
                                        var chart_cls = 'weekly_down';
                                    }

                                    // Make sure chart has some non-zero values
                                    let result = null;
                                    data_array.forEach(function (item) {
                                        if (item <= "0.000000" && result != true) {
                                            result = false;
                                        } else {
                                            result = true;
                                        }
                                    });
                                    if (result === false || data_array.length <= 1) {
                                        chart_data = "undefined";
                                        gChart = 'false';
                                    }
                                }

                            }
                            if ((data_object.api_type == "coinmarketcap" || data_object.api_type == "both_coinmarketcap") && row.extradata?.cmc_id) {
                                let degree = (row.percent_change_7d < 0) ? '300deg' : '85deg';
                                return html = '<div class="' + classes + " " + chart_cls + '"><img class="cmc_svg_images" src="https://s3.coinmarketcap.com/generated/sparklines/web/7d/2781/'+row.extradata.cmc_id+'.svg" style="filter:hue-rotate('+degree+')" /></div>';
                            }
                            else {
                                return html = '<div class="' + classes + " " + chart_cls + '"><div class="cmc_spinner"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div><div style="width:100%;height:100%;" class="ccpw-chart-container"><canvas  data-content=' + chart_data + ' ' + dynamic_color + 'data-coin-symbol="' + row.symbol + '"   data-create-chart="' + gChart + '"  data-cache="true"  class="cmc-sparkline-charts"  id="small-coinchart" width="168" height="50"  style="display: block; height: 40px;  width: 135px;"></canvas></div>';
                            }
                            break;

                    }
                },
                "createdCell": function(td, cellData, rowData, row, col) {
                    //if (col != 7) {
                    $(td).attr('data-sort', cellData);
                    //}
                }
            });
        });      
        $cmc_table.DataTable({
            "deferRender": true,
            "serverSide": true,
            "ajax": {
                "url": data_object.api_url,
                "type": "POST",
                "dataType": "JSON",
                "data": function(d) {
                    d._wpnonce = data_object.nonce;
                    d.action = "dt_get_coins_list";
                    d.currency = fiatCurrency;
                    d.category = category;
                    d.predi_val = predi_val;
                    d.predi_per = predi_per;
                    d.show_predi = show_predi;
                    d.post_id = post_id;
                    d.search = d['search']['value'];
                    if (CMC_REQUEST == 'watch_list' || localStorage.getItem('cmc-favorite-view') == 'true') {
                        d.coinID = cmc_get_watch_list();
                        d.totalCoins = d.coinID.length;
                    } else if (CMC_REQUEST == 'main_list') {
                        d.totalCoins = totalCoins;
                    }
                    d.currencyRate = fiatCurrencyRate;

                    // etc
                },

                "error": function(xhr, error, thrown) {
                    //  alert('Something wrong with Server');
                }
            },
            "ordering": false,
            "destroy": true,
            "searching": enableSearch,
            "pageLength": pagination,
            "columns": columns,
            "lengthChange": false,
            "dom": '<"top"iflp<"clear">>rt<"bottom"iflp<"clear">>',
            "pagingType": "simple",
            "processing": true,
            "language": {
                "processing": loadingLbl,
                "loadingRecords": loadingLbl,
                "searchPlaceholder": searchLabel,
                "search": "_INPUT_", //remove search lable from datatable search box
                "paginate": {
                    "next": nexttext,
                    "previous": prevtext
                },
            },
            "zeroRecords": zeroRecords,
            "emptyTable": zeroRecords,
            "renderer": {
                "header": "bootstrap",
            },
            "drawCallback": function(settings) {
                $cmc_table.find(".cmc-sparkline-charts").each(function(index) {
                    $(this).cmcgenerateSmallChart();
                });
                $cmc_table.tableHeadFixer({
                    // fix table header
                    head: true,
                    // fix table footer
                    foot: false,
                    left: 2,
                    right: false,
                    'z-index': 1
                });

                let currencySelectorBox = "#cmc_usd_conversion_box";
                $(currencySelectorBox).trigger('change');
               
                setTimeout(() => {
                    if ($("#cmc_coinslist").hasClass("cmc_live_updates")) {
                        $(this).setupWebSocket();
                    }
                }, 1200);

            },
            "createdRow": function(row, data, dataIndex) {
                // console.log(data.stable_coin_cate);
                $(row).attr('data-coin-id', data.coin_id);
                $(row).attr('data-coin-old-price', data.price);
                $(row).attr('data-coin-symbol', data.symbol);
                $(row).attr('data-stable-cate', data.stable_coin_cate);
                $(row).attr('data-trading-pair', data.symbol + 'USDT');


            },
            "initComplete": function (settings, json) {
                if (json?.error == "nonce_failed") {
                
                    $(this).find('.dataTables_empty').html("<span style=\"color:red\">Attention: Please exclude this page from your cache plugin, as it is currently causing a nonce failure.<br> For detailed instructions on how to implement the exclusion, kindly follow this link: <a href=\"https://cryptocurrencyplugins.com/docs/coins-marketcap/nonce-validation-failed\" target=\"_balnk\">Exclusion Guide..</a></span>")
                       

                }               
               
            
                
                $cmc_table.removeClass('cmc-table-loader')
           
            }

        });

    }
    $("#cryptocurency-market-cap-wrapper .cmc-datatable.table.table-striped.table-bordered").each(function () {
         $.fn.dataTable.ext.errMode = 'none';
    $(this).cmcDatatable();
        new Tablesort(this, {
            descending: true
        });
    })
  
    // var content = $("#cmc_search_html").html();
    // var search_data = JSON.parse(content);
    var source;
    var cmc_search_cache = lscache.get('cmc_coin_search')
    if (cmc_search_cache == null) {
        $('.cmc_search input.typeahead').on("click", function () {
            cmc_search_cache = lscache.get('cmc_coin_search')
            if (cmc_search_cache == null) {
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: data_object.ajax_url,
                    data: { 'action': 'cmc_ajax_search','_wpnonce':data_object.nonce},
                    async: !0,
                    beforeSend: function () {
                        // hide search-field before 
                        $('.typeahead.tt-input').attr('disabled', 'disabled');
                    },
                    success: function (response) {
                        const responseData = response.data ? JSON.parse(response.data) : [];
                        lscache.set('cmc_coin_search', responseData, 60 * 24);
                        source = new Bloodhound({
                            datumTokenizer: Bloodhound.tokenizers.obj.whitespace(["name", "symbol"]),
                            queryTokenizer: Bloodhound.tokenizers.whitespace,
                            local: responseData
                        });
                        $('.typeahead.tt-input').removeAttr('disabled');
                        cmc_init_search()
                        $('.typeahead.tt-input').select();
                    }
                })
            }
        })
    } else {
        source = new Bloodhound({
            datumTokenizer: Bloodhound.tokenizers.obj.whitespace(["name", "symbol"]),
            queryTokenizer: Bloodhound.tokenizers.whitespace,
            local: cmc_search_cache
        });
        cmc_init_search()
    }


    function cmc_init_search() {
        source.initialize();
        // var noresult = $("#custom-templates").data('no-result');
        var noResults = $('#custom-templates').attr('data-no-result');
        var cmc_link = $('#custom-templates').attr('data-slug');
        $('#custom-templates .typeahead').typeahead(null, {
            name: 'matched-links',
            displayKey: 'name',
            source: source.ttAdapter(),
            templates: {
                empty: '<div class="empty-message">' + noResults + '</div>',
                // suggestion: Handlebars.compile(document.getElementById("search_temp").innerHTML)
                header: '<h6 class="league-name">Result</h6>',
                suggestion: function(coin) {
                    let currency = jQuery("#cmc_usd_conversion_box").val()
                    let link = cmc_link + coin.symbol + '/' + coin.id;
                    if (currency != null) {
                        link += '/' + currency;
                    }
                    var html = '<div class="cmc-search-sugestions"><a href="' + link + '" onclick="' + link + '"">';
                    // var html = '<div class="cmc-search-suggestions"><a href="' + link + '"  > ';
                    html += coin.name + ' (' + coin.symbol + ')</a></div>';
                    return html;
                }
            }
        });
    }


    $(".cmc_conversions").on("change", function() {
        var selected_curr = $('option:selected', this).val();
       
        var currencySymbol = $('option:selected', this).data('currency-symbol');
        var currencyRate = $('option:selected', this).data('currency-rate');
        var domain = data_object.domain_url;
        var storagename = 'cmc-selected-currency-' + domain;
        // update cache on currency change
      
        $("#cmc_coinslist").find('tbody tr').each(function(index) {

            // clear search query
            // fetch each coin cate (Prediction code)
            var cate = jQuery(this).data('stable-cate');
            $('.typeahead').typeahead('val', '');
            var priceTD = $(this).find('.cmc-price');
            var coinDiv = $(this).find('.cmc-name');
            var coinName = $(this).attr('data-coin-id');
            var coinSymbol = $(this).attr('data-coin-symbol');
            var cmcAth = $(this).find('.cmc-ath');
            var high24H = $(this).find('.cmc-high');
            var low24H = $(this).find('.cmc-low');
            // prediction collumn
            
            let singlePageUrl = $(this).parents("#cmc_coinslist").find("thead th[data-single-url]").attr("data-single-url");

            var volTD = $(this).find('.cmc-vol');
            var capTD = $(this).find('.cmc-market-cap');
            var is_milbil_enable = $(this).parents("#cmc_coinslist").data('number-formating');

            // update coin url
            coinDiv.find("a").attr("href", singlePageUrl + '/' + coinSymbol + '/' + coinName + '/' + selected_curr + '/');
            var coinPrice = priceTD.data('val');
            var cmcVol = volTD.data('val');
            var cmcMarketCap = capTD.data('val');
            var ath = cmcAth.data('val');
            var high = high24H.data('val');
            var low = low24H.data('val');
            //Predictiode start 
            var predi = $(this).find('.cmc-predi');
            var predi_pri = predi.data('val');
            var predi_val = jQuery('table#cmc_coinslist').data("predi");
            var predi_per =  jQuery('table#cmc_coinslist').data("prediper");
            var show_predi =  jQuery('table#cmc_coinslist').data("showpredi");
            //Predictiode End 
            if (selected_curr == "BTC") {
                var convertedPrice = coinPrice / currencyRate;
                var convertedVol = cmcVol / currencyRate;
                var convertedCap = cmcMarketCap / currencyRate;
                var convertedAth = ath / currencyRate;
                var convertedhigh24H = ath / currencyRate;
                var convertedlow24H = ath / currencyRate;
                var formatedPrice = numeral(convertedPrice).format('0,0.0000000');
                var formatedAth = numeral(convertedAth).format('0,0.0000000');
                var formatedVol = numeral(convertedVol).format('0,0');
                var formatedCap = numeral(convertedCap).format('0,0');
                var formatedhigh24H = numeral(convertedhigh24H).format('0,0.0000000');
                var formatedlow24H = numeral(convertedlow24H).format('0,0.0000000');
                //Predictiode start 
                if(cate==true){
                    var pred_form_val = convertedPrice;
                }else{
                    if(predi_val=='up'){
                        var pred_form_val = convertedPrice+convertedPrice*predi_per/100;
                    }else{
                        var pred_form_val = convertedPrice-convertedPrice*predi_per/100; 
                    }
                }
                //Predictiode End 
            } else {
                var convertedPrice = coinPrice * currencyRate;
                var convertedVol = cmcVol * currencyRate;
                var convertedCap = cmcMarketCap * currencyRate;
                var convertedAth = ath * currencyRate;
                var convertedhigh24H = high * currencyRate;
                var convertedlow24H = low * currencyRate;
               
                var formatedPrice = cmcformatNumberWithDynamicDecimals(convertedPrice);                
              
             
                var formatedAth = cmcformatNumberWithDynamicDecimals(convertedAth);     
             
               
                var formatedhigh24H =cmcformatNumberWithDynamicDecimals(convertedhigh24H);   
              
            
                var formatedlow24H = cmcformatNumberWithDynamicDecimals(convertedlow24H);   
              
                if (typeof is_milbil_enable != 'undefined' && is_milbil_enable == '1' ) {
                    var formatedVol = cmcformatCash(convertedVol);
                    var formatedCap = cmcformatCash(convertedCap);
                } else {
                    var formatedVol = convertedVol;
                    var formatedCap = convertedCap;
                }
                //Predictiode start 
                if(cate==true){
                    var pred_form_val = convertedPrice;
                }else{
                    if(predi_val=='up'){
                        var pred_form_val = convertedPrice+convertedPrice*predi_per/100;
                    }else{
                        var pred_form_val = convertedPrice-convertedPrice*predi_per/100; 
                    }
                }
            }
            if (pred_form_val < 0.50) {
                var formatedPrediPrice = numeral(pred_form_val).format('0,0.000000');
            } else {
                var formatedPrediPrice = numeral(pred_form_val).format('0,0.00');
            }
            //Predictiode End 
            let Mcap = (cmcMarketCap == undefined) ? "N/A" : currencySymbol + formatedCap;
            let fVOL = (cmcVol == undefined) ? "N/A" : currencySymbol + formatedVol;
            priceTD.html(currencySymbol + '<span class="cmc-formatted-price">' + formatedPrice + '</span>');
            capTD.html(Mcap);
            volTD.html(fVOL);
            predi.html(currencySymbol + '<span class="cmc-price-prediction-d7">'+ formatedPrediPrice + '</span>');
            //if (cmcAth == "0.00") {
            if (cmcAth == "0.00") {
                cmcAth.html('<span class="cmc-formatted-ath">N/A</span>');
            } else {
                cmcAth.html(currencySymbol + '<span class="cmc-formatted-ath">' + formatedAth + '</span>');
            }
            if (formatedhigh24H == "0.00" || formatedhigh24H == "0.000000") {
                high24H.html('<span class="cmc-formatted-high">N/A</span>');
            } else {
                high24H.html(currencySymbol + '<span class="cmc-formatted-high">' + formatedhigh24H + '</span>');
            }
            if (formatedlow24H == "0.00" || formatedlow24H == "0.000000") {
                low24H.html('<span class="cmc-formatted-high">N/A</span>');
            } else {
                low24H.html(currencySymbol + '<span class="cmc-formatted-low">' + formatedlow24H + '</span>');
            }
        });
    });

    jQuery(document).on('click', '.btn_cmc_watch_list', function(evt) {
        evt.preventDefault();
        let THIS = jQuery(this);
        let ID = jQuery(THIS).attr('data-coin-id');
        var arr = new Array();
        if (localStorage.getItem('cmc_watch_list') !== null && localStorage.getItem('cmc_watch_list') != "") {
            arr = cmc_get_watch_list();
            let coin_exist = arr.findIndex(ar => { return ar == ID });
            if (coin_exist != -1) {
                arr.splice(coin_exist, 1);
                THIS.removeClass('cmc_onwatch_list cmc_icon-star').addClass('cmc_icon-star-empty');
                THIS.attr('title', watchTitle);
            } else {
                arr.push(ID);
                THIS.removeClass('cmc_icon-star-empty').addClass('cmc_onwatch_list cmc_icon-star');
                THIS.attr('title', unwatchTitle);
            }
        } else {
            arr.push(ID);
            THIS.removeClass('cmc_icon-star-empty').addClass('cmc_onwatch_list cmc_icon-star');
            THIS.attr('title', unwatchTitle);
        }
        if (arr.length == 0) {
            localStorage.removeItem('cmc_watch_list');
        } else {
            localStorage.setItem('cmc_watch_list', arr);
        }
    });

    jQuery(document).on('click', '#cmc_toggel_fav', function(event) {
        event.preventDefault();
        var THIS = $(this);
        if (THIS.hasClass('cmc_icon-star-empty')) {
            localStorage.setItem('cmc-favorite-view', true);
            THIS.removeClass('cmc_icon-star-empty').addClass('cmc_icon-star');
            CMC_REQUEST = 'watch_list';
            $("#cmc_coinslist").cmcDatatable();
        } else {
            localStorage.removeItem('cmc-favorite-view');
            CMC_REQUEST = 'main_list';
            THIS.removeClass('cmc_icon-star').addClass('cmc_icon-star-empty');
            $("#cmc_coinslist").cmcDatatable();
        }
    });

    if (localStorage.getItem('cmc-favorite-view') == 'true') {
        $('#cmc_toggel_fav').removeClass('cmc_icon-star-empty').addClass('cmc_icon-star');
    }

})(jQuery);