<?php

use BracketSpace\Notification\Abstracts\Trigger;
use BracketSpace\Notification\Defaults\MergeTag\StringTag;
use BracketSpace\Notification\Defaults\MergeTag\UrlTag;

class ContacterRemovedTrigger extends Trigger {

	public function __construct() {

		/** Add slug and the title. */
		parent::__construct(
			'contacter/record/removed',
			esc_html__( 'Contacter Record Removed', 'contacter' )
		);

		/** Hook to the action. */
		$this->add_action( 'contacter_record_removed', 10, 1 );

		/** Add description to trigger. */
		$this->set_description(
			esc_html__( 'Fires when a new Contacter Record deleted.', 'contacter' )
		);

	}

	public function action( $post_id ) {

		/** If $post_id is empty, don't send any notifications. */
		if ( empty( $post_id ) ) { return false; }

		/** Set the trigger properties. */
		$this->post = get_post( $post_id );

	}

	public function merge_tags() {

		$this->add_merge_tag( new StringTag( [
			'slug'        => 'record_id',
			'name'        => __( 'Record ID', 'contacter' ),
			'resolver'    => function( $trigger ) {
				return $trigger->post->ID;
			},
		] ) );


		$this->add_merge_tag( new StringTag( [
			'slug'        => 'record_title',
			'name'        => __( 'Record title', 'contacter' ),
			'resolver'    => function( $trigger ) {
				return $trigger->post->post_title;
			},
		] ) );

	}

}