/**
 * Contacter
 * Voice feedback form for your website for saving and transcribing user voice messages to text.
 * Exclusively on https://1.envato.market/contacter
 *
 * @encoding        UTF-8
 * @version         1.7.8
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

/** Run jQuery scripts */
( function ( $ ) {

    "use strict";

    /** Document Ready. */
    $( document ).ready( function () {

        /** Show warning if we try to leave with unsaved changes. */
        let unsaved = false;

        /** Triggers change in all input fields including text type. */
        $( ':input' ).on( 'change', function() { unsaved = true; } );

        $( '.mdp-generate-transcription-btn' ).on( 'click', function ( e ) {
            e.preventDefault();

            if ( $( this ).hasClass( 'is-busy' ) ) { return; }

            /** Disable Button. */
            $( this ).addClass( 'is-busy' ).attr( 'disabled', true );

            let data = {
                action: 'gtrans',
                security: mdpContacter.ajax_nonce,
                record_id: mdpContacter.record_id
            };

            $.post( ajaxurl, data, function ( response ) {

                /** Add transcription if it is ready. */
                if ( ( 'ok' === response.status ) ) {

                    /** Set Transcription to Editor. */
                    if ( $( '#wp-mdptranscriptiontxt-wrap' ).hasClass( 'html-active' ) ) { // We are in text mode
                        $( '#mdptranscriptiontxt' ).val( response.transcription ); // Update the textarea's content
                    } else { // We are in tinyMCE mode
                        let transcriptionEditor = tinyMCE.get( 'mdptranscriptiontxt' );
                        if( transcriptionEditor !== null ) { // Make sure we're not calling setContent on null
                            transcriptionEditor.setContent( response.transcription ); // Update tinyMCE's content
                        }
                    }

                    /** If empty transcription. */
                    if ( '' === response.transcription.trim() ) {
                        alert( 'Failed to recognize anything on this audio. Transcription is empty.' );
                    }

                    unsaved = true;

                } else {

                    /** Show Error message to user. */
                    show_err_msg( response );

                }

            }, 'json' )
            .fail( function( response ) {

                show_err_msg( response );

            } )
            .always( function() {
                /** Enable Button. */
                $( '.mdp-generate-transcription-btn' ).removeClass( 'is-busy' ).attr( 'disabled', false );
            } );

            /** Show Alert with Error. */
            function show_err_msg( err ) {

                console.error( err );

                if ( err.message ) {
                    alert( 'ERROR:\n ' + err.message );
                } else if ( err.responseText ) {
                    alert( 'ERROR:\n ' + err.responseText );
                } else {
                    alert( 'ERROR:\n ' + err );
                }

            }

        } );


        /** Show warning for Unsaved changes. */
        window.onbeforeunload = function() {
            if ( unsaved ) {
                return 'It looks like you made changes and did not save it. Continue anyway?';
            }
        };

        /** Click on update button. */
        $( '#publish' ).on( 'click', function () {
            unsaved = false;
        } );

    } );

} ( jQuery ) );
