/**
 * Contacter
 * Voice feedback form for your website for saving and transcribing user voice messages to text.
 * Exclusively on https://1.envato.market/contacter
 *
 * @encoding        UTF-8
 * @version         1.7.8
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

/** Run jQuery scripts */
( function ( $ ) {

    "use strict";

    /** Document Ready. */
    $( document ).ready( function () {

        /**
         * Copy Shortcode code to clipboard.
         **/
        new ClipboardJS( '.mdp-contacter-form-shortcode' );
        $( '.mdp-contacter-form-shortcode' ).on( 'click', function ( e ) {
            e.preventDefault();

            /** Set Copied label for 3 sec. */
            $( this ).html( $( this ).data( 'copied-text' ) );
            setTimeout( ( $target ) => {
                $target.html( $target.data( 'copy-text' ) );
            }, 3000, $( this ) );

        } );

    } );

} ( jQuery ) );
