<?php
namespace BooklyWaitingList\Lib\ProxyProviders;

use Bookly\Lib as BooklyLib;
use BooklyWaitingList\Lib;

class Local extends BooklyLib\Proxy\WaitingList
{
    /**
     * @inheritDoc
     */
    public static function handleParticipantsChange( $queue, BooklyLib\Entities\Appointment $appointment )
    {
        $info = $appointment->getNopInfo();

        if ( $info['waitlisted'] && ( $info['total_nop'] < $info['capacity_max'] ) ) {
            Lib\Notifications\WaitingList\Sender::send( $appointment, $queue );
        }

        return $queue;
    }

    /**
     * @inheritDoc
     */
    public static function canUseFreePlace( $ca )
    {
        $busy_statuses = BooklyLib\Proxy\CustomStatuses::prepareBusyStatuses( array(
            BooklyLib\Entities\CustomerAppointment::STATUS_PENDING,
            BooklyLib\Entities\CustomerAppointment::STATUS_APPROVED,
        ) );

        foreach ( BooklyLib\DataHolders\Booking\Item::collect( $ca )->getItems() as $item ) {
            $nop = 0;
            $customer_appointment = $item->getCA();
            if ( $customer_appointment->getStatus() != BooklyLib\Entities\CustomerAppointment::STATUS_WAITLISTED ) {
                return false;
            }
            foreach ( $item->getAppointment()->getNopInfo() as $status => $value ) {
                if ( in_array( $status, $busy_statuses ) ) {
                    $nop += $value;
                }
            }
            if ( $item->getService()->getCapacityMax() < $nop + $customer_appointment->getNumberOfPersons() ) {
                return false;
            }
        }

        return true;
    }

    /**
     * @inheritDoc
     */
    public static function handleFreePlace( $queue, $ca )
    {
        if ( self::canUseFreePlace( $ca ) ) {
            Lib\Notifications\WaitingList\Sender::sendFreePlace( $ca, $queue );
        }

        return $queue;
    }

    /**
     * @inheritDoc
     */
    public static function handleAppointmentFreePlace( $queue, $appointment )
    {
        $nop = 0;
        $busy_statuses = BooklyLib\Proxy\CustomStatuses::prepareBusyStatuses( array(
            BooklyLib\Entities\CustomerAppointment::STATUS_PENDING,
            BooklyLib\Entities\CustomerAppointment::STATUS_APPROVED,
        ) );
        $service = BooklyLib\Entities\Service::find( $appointment->getServiceId() );
        if ( $service ) {
            $ca_list = $appointment->getCustomerAppointments( true );
            foreach ( $ca_list as $ca ) {
                if ( in_array( $ca->getStatus(), $busy_statuses, true ) ) {
                    $nop += $ca->getNumberOfPersons();
                }
            }

            if ( $nop < $service->getCapacityMax() ) {
                foreach ( $ca_list as $ca ) {
                    if ( $ca->getStatus() === BooklyLib\Entities\CustomerAppointment::STATUS_WAITLISTED ) {
                        Lib\Notifications\WaitingList\Sender::sendFreePlace( $ca, $queue );
                    }
                }
            }
        }

        return $queue;
    }
}