<?php
namespace BooklyWaitingList\Lib\Notifications\Assets\WaitingList\Item\ProxyProviders;

use Bookly\Lib\Notifications\Assets\Item\Codes;
use Bookly\Lib\Notifications\Assets\Item\Proxy;

abstract class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareReplaceCodes( array $replace_codes, Codes $codes, $format )
    {
        $ca = $codes->getItem()->getCA();

        $replace_codes['appointment_booking_url'] = $ca
            ? admin_url( 'admin-ajax.php?action=bookly_waiting_list_confirm_appointment&token=' . urlencode( \Bookly\Lib\Utils\Common::xorEncrypt( $ca->getToken(), 'confirm' ) ) )
            : '';

        return $replace_codes;
    }
}