<?php
namespace BooklyWaitingList\Lib\Notifications\Assets\WaitingList;

use Bookly\Lib\Entities\Appointment;
use Bookly\Lib\Entities\CustomerAppointment;
use Bookly\Lib\DataHolders\Booking as DataHolders;
use Bookly\Lib\Utils;
use Bookly\Lib\Notifications\Assets\Item;

class Codes extends Item\Codes
{
    // Core
    public $waiting_list;

    /**
     * Constructor.
     *
     * @param Appointment $appointment
     */
    public function __construct( Appointment $appointment )
    {
        $this->waiting_list = array();

        $participants = $appointment->getCustomerAppointments( true );
        foreach ( $participants as $ca ) {
            if ( $ca->getStatus() == CustomerAppointment::STATUS_WAITLISTED ) {
                if ( $this->item === null ) {
                    $simple = DataHolders\Simple::create( $ca );
                    parent::__construct( DataHolders\Order::createFromItem( $simple ) );
                    $this->prepareForItem( $simple, 'staff' );
                }
                $this->waiting_list[] = array(
                    $ca->customer->getFullName(),
                    $ca->customer->getEmail(),
                    $ca->customer->getPhone(),
                    $ca->getToken(),
                );
            }
        }
    }

    /**
     * @inheritDoc
     */
    protected function getReplaceCodes( $format )
    {
        $replace_codes = parent::getReplaceCodes( $format );

        // Add replace codes.
        $waiting_list = '';
        foreach ( $this->waiting_list as $row ) {
            $row[3] = admin_url( 'admin-ajax.php?action=bookly_approve_appointment&token=' . urlencode( Utils\Common::xorEncrypt( $row[3], 'approve' ) ) );
            if ( $format == 'html' ) {
                $row[3] = sprintf( '<a href="%s">%s</a>', $row[3], __( 'Set appointment', 'bookly' ) );
                $waiting_list .= '<tr><td>' . implode( '</td><td>', $row ) . '</td></tr>';
            } else {
                $waiting_list .= implode( ' ', $row ) . PHP_EOL;
            }
        }
        if ( $format == 'html' ) {
            $replace_codes['appointment_waiting_list'] = '<table>' . $waiting_list . '</table>';
        } else {
            $replace_codes['appointment_waiting_list'] = $waiting_list ;
        }

        return $replace_codes;
    }
}