<?php
namespace BooklyWaitingList\Lib;

use Bookly\Lib as BooklyLib;
use BooklyWaitingList\Backend;
use BooklyWaitingList\Frontend;

abstract class Plugin extends BooklyLib\Base\Plugin
{
    protected static $prefix;
    protected static $title;
    protected static $version;
    protected static $slug;
    protected static $directory;
    protected static $main_file;
    protected static $basename;
    protected static $text_domain;
    protected static $root_namespace;
    protected static $embedded;

    /**
     * @inheritDoc
     */
    protected static function init()
    {
        // Register proxy methods.
        Backend\Components\Dialogs\Service\Edit\ProxyProviders\Local::init();
        Backend\Modules\Appearance\ProxyProviders\Local::init();
        Backend\Modules\Appearance\ProxyProviders\Shared::init();
        Backend\Modules\Calendar\ProxyProviders\Shared::init();
        Backend\Modules\Notifications\ProxyProviders\Shared::init();
        Backend\Modules\Settings\ProxyProviders\Shared::init();
        Frontend\Modules\ModernBookingForm\ProxyProviders\Shared::init();
        if ( get_option( 'bookly_waiting_list_enabled' ) ) {
            Frontend\Modules\Booking\ProxyProviders\Shared::init();
        }
        Notifications\Assets\Test\ProxyProviders\Shared::init();
        Notifications\Assets\WaitingList\Item\ProxyProviders\Shared::init();
        Notifications\Test\ProxyProviders\Shared::init();
        ProxyProviders\Local::init();
        ProxyProviders\Shared::init();
    }

    /**
     * @inheritDoc
     */
    protected static function registerAjax()
    {
        Frontend\Modules\Booking\Ajax::init();
    }
}