<?php
namespace BooklyWaitingList\Frontend\Modules\ModernBookingForm\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Frontend\Modules\ModernBookingForm\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareAppearanceData( array $bookly_options )
    {
        $bookly_options['fields']['on_waiting_list'] = __( 'On waiting list', 'bookly' );

        return $bookly_options;
    }

    /**
     * @inerhitDoc
     */
    public static function prepareAppearance( array $bookly_options )
    {
        $bookly_options['l10n']['on_waiting_list'] = __( 'Waiting list', 'bookly' );
        $bookly_options['l10n']['waiting_list_booking_completed'] = __( 'You have been added to waiting list for appointment.', 'bookly' );
        $bookly_options['l10n']['cart_item_on_waiting_list'] = __( 'Waiting list', 'bookly' );

        return $bookly_options;
    }
}