<?php
namespace BooklyWaitingList\Frontend\Modules\Booking;

use Bookly\Lib as BooklyLib;
use BooklyWaitingList\Lib\ProxyProviders\Local;

class Ajax extends BooklyLib\Base\Ajax
{
    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array( 'confirmAppointment' => 'anonymous' );
    }

    /**
     * Set default status for appointment(s) from waiting list.
     */
    public static function confirmAppointment()
    {
        $url = get_option( 'bookly_url_confirm_from_waitlisted_denied_page_url' );

        // Decode token.
        $token = BooklyLib\Utils\Common::xorDecrypt( self::parameter( 'token' ), 'confirm' );
        $ca_to_confirm = new BooklyLib\Entities\CustomerAppointment();

        if ( $ca_to_confirm->loadBy( array( 'token' => $token, 'status' => BooklyLib\Entities\CustomerAppointment::STATUS_WAITLISTED ) )
            && Local::canUseFreePlace( $ca_to_confirm )
        ) {
            $item = BooklyLib\DataHolders\Booking\Item::collect( $ca_to_confirm );
            $customer = BooklyLib\Entities\Customer::find( $ca_to_confirm->getCustomerId() );
            $item->setStatus( BooklyLib\Proxy\CustomerGroups::takeDefaultAppointmentStatus( BooklyLib\Config::getDefaultAppointmentStatus(), $customer->getGroupId() ) );
            foreach ( $item->getItems() as $simple ) {
                if ( $simple->getCA()->save() ) {
                    $appointment = $simple->getAppointment();
                    // Google Calendar.
                    BooklyLib\Proxy\Pro::syncGoogleCalendarEvent( $appointment );
                    // Outlook Calendar.
                    BooklyLib\Proxy\OutlookCalendar::syncEvent( $appointment );
                    // Waiting list.
                    BooklyLib\Proxy\WaitingList::handleParticipantsChange( false, $appointment );
                }
            }
            BooklyLib\Notifications\Booking\Sender::send( $item );
            $url = get_option( 'bookly_url_confirm_from_waitlisted_page_url' );
        }

        BooklyLib\Utils\Common::redirect( $url );
    }

    /**
     * Override parent method to exclude actions from CSRF token verification.
     *
     * @param string $action
     * @return bool
     */
    protected static function csrfTokenValid( $action = null )
    {
        $excluded_actions = array(
            'confirmAppointment',
        );

        return in_array( $action, $excluded_actions ) || parent::csrfTokenValid( $action );
    }
}