<?php
namespace BooklyWaitingList\Backend\Modules\Settings\ProxyProviders;

use Bookly\Backend\Components\Settings\Inputs;
use Bookly\Backend\Modules\Settings\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function renderAdditionalSettings()
    {
        self::renderTemplate( 'additional_settings' );
    }

    /**
     * @inheritDoc
     */
    public static function prepareCalendarAppointmentCodes( array $codes, $participants )
    {
        if ( $participants == 'many' ) {
            $codes['on_waiting_list'] = __( 'Number of persons on waiting list', 'bookly' );
        }

        return $codes;
    }

    /**
     * @inheritDoc
     */
    public static function prepareCodes( array $codes, $section )
    {
        switch ( $section ) {
            case 'calendar_many_participants':
            case 'google_calendar':
            case 'outlook_calendar':
            case 'ics_for_customer':
            case 'ics_for_staff':
                $codes['on_waiting_list'] = array( 'description' => __( 'Number of persons on waiting list', 'bookly' ) );
                break;
        }

        return $codes;
    }

    /**
     * @inheritDoc
     */
    public static function renderUrlSettings()
    {
        Inputs::renderText( 'bookly_url_confirm_from_waitlisted_page_url', __( 'Set appointment from waiting list (success)', 'bookly' ), __( 'Set the URL of a page that is shown to clients after they successfully set the appointment from waiting list.', 'bookly' ) );
        Inputs::renderText( 'bookly_url_confirm_from_waitlisted_denied_page_url', __( 'Set appointment from waiting list (denied)', 'bookly' ), __( 'Set the URL of a page that is shown to clients when the setting of appointment from waiting list is not available anymore.', 'bookly' ) );
    }

    /**
     * @inheritDoc
     */
    public static function saveSettings( array $alert, $tab, array $params )
    {
        if ( $tab == 'additional' ) {
            $options = array( 'bookly_waiting_list_despite_capacity' );
            foreach ( $options as $option_name ) {
                if ( array_key_exists( $option_name, $params ) ) {
                    update_option( $option_name, $params[ $option_name ] );
                }
            }
        } elseif ( ( $tab == 'calendar' ) && array_key_exists( 'waitlisted', $params['status'] ) ) {
            update_option( 'bookly_appointment_status_waitlisted_color', $params['status']['waitlisted'] );
        } elseif ( $tab == 'url' ) {
            $options = array( 'bookly_url_confirm_from_waitlisted_page_url', 'bookly_url_confirm_from_waitlisted_denied_page_url' );
            foreach ( $options as $option_name ) {
                if ( array_key_exists( $option_name, $params ) ) {
                    update_option( $option_name, $params[ $option_name ] );
                }
            }
        }

        return $alert;
    }
}