<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly
use Bookly\Backend\Components\Dialogs;
use Bookly\Lib\Utils\Common;
use Bookly\Lib\Config;
use Bookly\Lib\Utils\DateTime;
use Bookly\Lib\Entities\CustomerAppointment;
use Bookly\Backend\Modules\Appointments\Proxy;
use Bookly\Backend\Components\Controls;
?>
<script type="text/javascript">
    (function(win, fn) {
        var done = false, top = true,
            doc = win.document,
            root = doc.documentElement,
            modern = doc.addEventListener,
            add = modern ? 'addEventListener' : 'attachEvent',
            rem = modern ? 'removeEventListener' : 'detachEvent',
            pre = modern ? '' : 'on',
            init = function(e) {
                if (e.type == 'readystatechange') if (doc.readyState != 'complete') return;
                (e.type == 'load' ? win : doc)[rem](pre + e.type, init, false);
                if (!done) {
                    done = true;
                    fn.call(win, e.type || e);
                }
            },
            poll = function() {
                try {
                    root.doScroll('left');
                } catch (e) {
                    setTimeout(poll, 50);
                    return;
                }
                init('poll');
            };
        if (doc.readyState == 'complete') fn.call(win, 'lazy');
        else {
            if (!modern) if (root.doScroll) {
                try {
                    top = !win.frameElement;
                } catch (e) {
                }
                if (top) poll();
            }
            doc[add](pre + 'DOMContentLoaded', init, false);
            doc[add](pre + 'readystatechange', init, false);
            win[add](pre + 'load', init, false);
        }
    })(window, function() {
        window.booklyStaffAppointments({
            wrapper: '<?php echo $wrapper ?>',
            read_only: <?php echo json_encode( $read_only ) ?>,
        });
    });
    var ajaxurl = <?php echo json_encode( admin_url( 'admin-ajax.php' ) ) ?>;
</script>
<div id="bookly-tbs" class="bookly-staff-cabinet bookly-staff-cabinet-appointments <?php echo $wrapper ?>">
    <div class="form-row">
        <div class="col-md-1">
            <div class="form-group">
                <input class="form-control" type="text" id="bookly-filter-id" placeholder="<?php esc_attr_e( 'ID', 'bookly' ) ?>"/>
            </div>
        </div>
        <div class="col-md-2">
            <button type="button" class="btn btn-default w-100 mb-3 text-truncate text-left" id="bookly-filter-date"
                    data-date="<?php echo date( 'Y-m-d', strtotime( 'first day of' ) ) ?> - <?php echo date( 'Y-m-d', strtotime( 'last day of' ) ) ?>">
                <i class="far fa-calendar-alt mr-1"></i>
                <span>
                    <?php echo DateTime::formatDate( 'first day of this month' ) ?> - <?php echo DateTime::formatDate( 'last day of this month' ) ?>
                </span>
            </button>
        </div>
        <div class="col-md-2">
            <button type="button" class="btn btn-default w-100 mb-3 text-truncate text-left" id="bookly-filter-creation-date" data-date="any">
                <i class="far fa-calendar-alt mr-1"></i>
                <span>
                    <?php esc_html_e( 'Created at any time', 'bookly' ) ?>
                </span>
            </button>
        </div>
        <div class="col-md-2">
            <div class="form-group">
                <select class="form-control <?php echo esc_attr( $customers === false ? 'bookly-js-select-ajax' : 'bookly-js-select' ) ?>" id="bookly-filter-customer"
                        data-placeholder="<?php esc_attr_e( 'Customer', 'bookly' ) ?>" <?php echo esc_attr( $customers === false ? 'data-ajax--action' : 'data-action' ) ?>="bookly_get_customers_list">
                <?php if ( $customers !== false ) : ?>
                    <?php foreach ( $customers as $customer_id => $customer ) : ?>
                        <option value="<?php echo esc_attr( $customer_id ) ?>" data-search='<?php echo esc_attr( json_encode( array_values( $customer ) ) ) ?>'><?php echo esc_html( $customer['full_name'] ) ?></option>
                    <?php endforeach ?>
                <?php endif ?>
                </select>
            </div>
        </div>
        <div class="<?php echo Config::locationsActive() ? 'col-md-1' : 'col-md-2' ?>">
            <div class="form-group">
                <select class="form-control bookly-js-select" id="bookly-filter-service" data-placeholder="<?php echo esc_attr( Common::getTranslatedOption( 'bookly_l10n_label_service' ) ) ?>">
                    <option value="0"><?php esc_html_e( 'Custom', 'bookly' ) ?></option>
                    <?php foreach ( $services as $service ) : ?>
                        <option value="<?php echo esc_attr( $service['id'] ) ?>"><?php echo esc_html( $service['title'] ) ?></option>
                    <?php endforeach ?>
                </select>
            </div>
        </div>
        <?php Proxy\Locations::renderFilter() ?>
        <div class="col-md-1">
            <div class="form-group">
                <ul id="bookly-filter-status"
                    data-txt-select-all="<?php esc_attr_e( 'All statuses', 'bookly' ) ?>"
                    data-txt-all-selected="<?php esc_attr_e( 'All statuses', 'bookly' ) ?>"
                    data-txt-nothing-selected="<?php esc_attr_e( 'No status selected', 'bookly' ) ?>"
                    data-hide-icon
                    data-align="right"
                >
                    <?php foreach ( CustomerAppointment::getStatuses() as $status ): ?>
                        <li data-value="<?php echo esc_attr( $status ) ?>">
                            <?php echo esc_html( CustomerAppointment::statusToString( $status ) ) ?>
                        </li>
                    <?php endforeach ?>
                </ul>
            </div>
        </div>
        <?php if ( ! $read_only ) : ?>
        <div class="col-auto ml-auto">
            <?php Controls\Buttons::render( 'bookly-new-appointment', 'btn-success w-100 mb-3', __( 'New appointment', 'bookly' ), array(), '{caption}…', '<i class="fas fa-fw fa-plus"></i>', true ) ?>
        </div>
        <?php endif ?>
    </div>

    <div class="row">
        <div class="col">
        <table class="bookly-js-appointments-list table table-striped w-100">
            <thead>
            <tr>
                <?php foreach ( $datatables['appointments']['settings']['columns'] as $column => $show ) : ?>
                    <?php if ( $show ) : ?>
                        <th><?php echo Common::html( $datatables['appointments']['titles'][ $column ] ) ?></th>
                    <?php endif ?>
                <?php endforeach ?>
                <?php if ( ! $read_only ): ?>
                    <th></th>
                <?php endif ?>
            </tr>
            </thead>
        </table>
        </div>
    </div>
    <?php if ( ! $read_only ) : ?>
        <?php Dialogs\Appointment\Delete\Dialog::render() ?>
        <?php Dialogs\Appointment\Edit\Dialog::render( ! in_array( 'wp_users', $hide ) ) ?>
        <?php Dialogs\Queue\Dialog::render() ?>
        <?php Proxy\Shared::renderAddOnsComponents() ?>
    <?php endif ?>
</div>