<?php
namespace BooklyStaffCabinet\Frontend\Modules\Appointments;

use Bookly\Lib as BooklyLib;

class Ajax extends BooklyLib\Base\Ajax
{
    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array(
            'getAppointments' => 'staff',
        );
    }

    /**
     * Get list of appointments.
     */
    public static function getAppointments()
    {
        $columns = BooklyLib\Utils\Tables::filterColumns( self::parameter( 'columns' ), BooklyLib\Utils\Tables::APPOINTMENTS );
        $order = self::parameter( 'order', array() );
        $filter = self::parameter( 'filter' );
        $limits = array(
            'length' => self::parameter( 'length' ),
            'start' => self::parameter( 'start' ),
        );

        $filter['staff'] = BooklyLib\Entities\Staff::query()->where( 'wp_user_id', get_current_user_id() )->fetchVar( 'id' ) ?: 0;
        $data = \Bookly\Backend\Modules\Appointments\Ajax::getAppointmentsTableData( $filter, $limits, $columns, $order, false );

        wp_send_json( array(
            'draw' => ( int ) self::parameter( 'draw' ),
            'recordsTotal' => $data['total'],
            'recordsFiltered' => $data['filtered'],
            'data' => $data['data'],
        ) );
    }
}