(function (wp) {
    let el = wp.element.createElement,
        components = wp.components,
        blockControls = wp.editor.BlockControls,
        inspectorControls = wp.editor.InspectorControls
    ;
    wp.blocks.registerBlockType('bookly/staff-cabinet-appointments', {
            title: BooklyStaffCabinetL10n.blocks.appointments.title,
            description: BooklyStaffCabinetL10n.blocks.appointments.description,
            icon: el('svg', {width: '20', height: '20', viewBox: "0 0 64 64"},
                el('path', {style: {fill: "rgb(0, 0, 0)"}, d: "M 8 0 H 56 A 8 8 0 0 1 64 8 V 22 H 0 V 8 A 8 8 0 0 1 8 0 Z"}),
                el('path', {style: {fill: "rgb(244, 102, 47)"}, d: "M 0 22 H 64 V 56 A 8 8 0 0 1 56 64 H 8 A 8 8 0 0 1 0 56 V 22 Z"}),
                el('rect', {style: {fill: "rgb(98, 86, 86)"}, x: 6, y: 6, width: 52, height: 10}),
                el('rect', {style: {fill: "rgb(242, 227, 227)"}, x: 12, y: 30, width: 40, height: 24}),
                el('rect', {style: {fill: "rgb(0, 0, 0)"}, x: 20, y: 40, width: 38, height: 2}),
                el('rect', {style: {fill: "rgb(0, 0, 0)"}, x: 20, y: 46, width: 38, height: 2}),
                el('rect', {style: {fill: "rgb(0, 0, 0)"}, x: 20, y: 52, width: 38, height: 2}),
            ),
        category: 'bookly-blocks',
        keywords: ['bookly', 'staff', 'appointment',],
        supports: {
            customClassName: false,
            html: false
        },
        attributes: {
            short_code: {
                type: 'string',
                default: '[bookly-staff-appointments]'
            },
            read_only: {
                type: 'boolean',
                default: false
            },
            hide_wp_users: {
                type: 'boolean',
                default: false
            }
        },
        edit: function(props) {
            let inspectorElements = [],
                attributes = props.attributes
            ;

            function getShortCode(props, attributes) {
                let short_code = '[bookly-staff-appointments',
                    hide = []
                ;

                if (attributes.hide_wp_users) {
                    hide.push('wp_users');
                }
                if (hide.length > 0) {
                    short_code += ' hide="' + hide.join() + '"';
                }
                if (attributes.read_only) {
                    short_code += ' read-only="true"';
                }
                short_code += ']';

                props.setAttributes({short_code: short_code});

                return short_code;
            }

            inspectorElements.push(el(components.PanelRow,
                {},
                el('label', {htmlFor: 'bookly-js-read-only'}, BooklyStaffCabinetL10n.readOnly),
                el(components.FormToggle, {
                    id: 'bookly-js-read-only',
                    checked: attributes.read_only,
                    onChange: function () {
                        return props.setAttributes({read_only: !props.attributes.read_only});
                    },
                })
            ));
            inspectorElements.push(el(components.PanelRow,
                {},
                el('label', {htmlFor: 'bookly-js-hide-wp-users'}, BooklyStaffCabinetL10n.wp_users),
                el(components.FormToggle, {
                    id: 'bookly-js-hide-wp-users',
                    checked: attributes.hide_wp_users,
                    onChange: function() {
                        return props.setAttributes({hide_wp_users: !props.attributes.hide_wp_users});
                    },
                })
            ));
            inspectorElements.push(el('div', {style: {'font-style': 'italic'}}, BooklyStaffCabinetL10n.wp_users_help));

            return [
                el(blockControls, {key: 'controls'}),
                el(inspectorControls, {key: 'inspector'},
                    el(components.PanelBody, {initialOpen: true},
                        inspectorElements
                    )
                ),
                el('div', {},
                    getShortCode(props, props.attributes)
                )
            ]
        },

        save: function(props) {
            return (
                el('div', {},
                    props.attributes.short_code
                )
            )
        }
    })
})(
    window.wp
);