<?php
namespace BooklyRatings\Lib;

use Bookly\Lib;

class Updater extends Lib\Base\Updater
{
    public function update_3_1()
    {
        $new_pc_key = 'bookly_ratings_purchase_code';
        $old_pc_key = 'bookly_ratings_envato_purchase_code';
        $current_pc = get_option( $old_pc_key, 'missing' );
        if ( $current_pc === 'missing' ) {
            add_option( $new_pc_key, '' );
        } else {
            if ( $current_pc ) {
                add_option( $new_pc_key, $current_pc );
            }
            delete_option( $old_pc_key );
        }
    }

    public function update_1_1()
    {
        add_option( 'bookly_ratings_app_show_on_frontend', '0' );
    }
}