(function ($) {
    window.booklyStaffRating = function (Options) {
        let $container = $('.bookly-js-staff-rating-' + Options.form_id),
            rating = false;
        jQuery('#bookly-rating-quiz', $container).on('mouseenter', '.bookly-js-star', function () {
            let index = jQuery(this).index();
            jQuery('#bookly-rating-quiz i.bookly-js-star', $container).each(function () {
                if (jQuery(this).index() <= index) {
                    jQuery(this).removeClass('text-muted far').addClass('text-warning fas');
                } else {
                    jQuery(this).removeClass('text-warning fas').addClass('text-muted far');
                }
            });
        }).on('click', '.bookly-js-star', function () {
            rating = jQuery(this).index();
            jQuery('#bookly-save', $container).prop('disabled', false);
        }).on('mouseleave', '.bookly-js-star', function () {
            jQuery('#bookly-rating-quiz i.bookly-js-star', $container).each(function () {
                if (rating !== false) {
                    if (jQuery(this).index() <= rating) {
                        jQuery(this).removeClass('text-muted far').addClass('text-warning fas');
                    }
                } else {
                    jQuery(this).removeClass('text-warning fas').addClass('text-muted far');
                }
            });
        });

        jQuery('button', $container).on('click', function () {
            if (rating !== false) {
                var ladda = Ladda.create(this);
                ladda.start();
                jQuery.post({
                    url: ajaxurl,
                    data: {
                        action: 'bookly_ratings_set_rating',
                        csrf_token: BooklyL10nGlobal.csrf_token,
                        token: Options.token,
                        rating: rating + 1,
                        comment: jQuery('.bookly-js-rating-comment', $container).val()
                    },
                    dataType: 'json',
                    xhrFields: {withCredentials: true},
                    crossDomain: 'withCredentials' in new XMLHttpRequest(),
                    success: function (response) {
                        ladda.stop();
                        jQuery('.bookly-js-rating-wrap', $container).hide();
                        jQuery('.bookly-js-rating-success', $container).show();
                    }
                });
            }
        });
    }
})(jQuery);