<?php
namespace BooklyRatings\Frontend\Modules\StaffRating;

use Bookly\Lib as BooklyLib;
use BooklyRatings\Lib;

class ShortCode extends BooklyLib\Base\ShortCode
{
    public static $code = 'bookly-staff-rating';

    /**
     * Link styles.
     */
    public static function linkStyles()
    {
        self::enqueueScripts( array(
            'module' => array(
                'js/staff-ratings.js' => array( 'bookly-frontend-globals' ),
            ),
        ) );
    }

    /**
     * Link scripts.
     */
    public static function linkScripts()
    {
        self::enqueueStyles( array(
            'bookly' => array( 'backend/resources/css/fontawesome-all.min.css' => array( 'bookly-backend-globals' ) ),
        ) );
    }

    /**
     * Render shortcode.
     *
     * @param array $attributes
     * @return string
     */
    public static function render( $attributes )
    {
        // Disable caching.
        BooklyLib\Utils\Common::noCache();

        $token = self::parameter( 'bookly-rating-token' );
        $ca = BooklyLib\Entities\CustomerAppointment::query( 'ca' )
            ->select( 'ca.rating, COALESCE(ca.rating_comment,\'\') AS rating_comment, a.end_date, a.start_date, a.service_id, a.staff_id, a.custom_service_name AS service_title' )
            ->leftJoin( 'Appointment', 'a', 'a.id = ca.appointment_id' )
            ->where( 'ca.token', $token )
            ->fetchRow();
        $expired = $ca && strtotime( $ca['end_date'] ) < current_time( 'timestamp' ) - (int) get_option( 'bookly_ratings_timeout' ) * DAY_IN_SECONDS;
        $not_started = $ca && strtotime( $ca['start_date'] ) > current_time( 'timestamp' );
        if ( $ca && ! $expired && ! $not_started ) {
            if ( $ca['service_id'] ) {
                $service = new BooklyLib\Entities\Service();
                $service->load( $ca['service_id'] );
                $ca['service_title'] = $service->getTranslatedTitle();
            }

            $staff = new BooklyLib\Entities\Staff();
            $staff->load( $ca['staff_id'] );
            $ca['staff_name'] = $staff->getTranslatedName();

            $ca['date'] = BooklyLib\Utils\DateTime::formatDate( $ca['start_date'] );
            $ca['time'] = BooklyLib\Utils\DateTime::formatTime( $ca['start_date'] );
        }

        // Prepare URL for AJAX requests.
        $ajax_url = admin_url( 'admin-ajax.php' );

        $form_id = uniqid();

        return self::renderTemplate( 'short_code', compact( 'ajax_url', 'form_id', 'token', 'ca', 'expired', 'not_started', 'attributes' ), false );
    }
}