<?php
namespace BooklyPackages\Lib\Payment\ProxyProviders;

use Bookly\Lib\Payment\Proxy;
use Bookly\Lib\DataHolders;
use Bookly\Lib\CartItem;
use Bookly\Lib\UserBookingData;
use BooklyPackages\Lib\DataHolders\Details;
use BooklyPackages\Lib\DataHolders\Booking;
use BooklyPackages\Lib\Entities;
use BooklyPackages\Lib\Notifications;

class Shared extends Proxy\Shared
{
    /**
     * @inerhitDoc
     */
    public static function create( $item_key, DataHolders\Booking\Order $order, CartItem $cart_item, UserBookingData $userData )
    {
        if ( $cart_item->getType() === CartItem::TYPE_PACKAGE ) {
            $package = new Entities\Package();
            if ( $order->getPayment() && $order->getPayment()->getId() ) {
                $package->setPaymentId( $order->getPayment()->getId() );
            }
            $package
                ->setLocationId( $cart_item->getLocationId() ?: null )
                ->setStaffId( $cart_item->getStaffId() )
                ->setServiceId( $cart_item->getServiceId() )
                ->setCustomerId( $order->getCustomer()->getId() )
                ->setOrderId( $order->getOrderId() )
                ->save();
            $item = new Booking\Package();
            $item->setPackage( $package );
            $order->addItem( $item_key++, $item );
        }

        return $item_key;
    }

    /**
     * @inerhitDoc
     */
    public static function complete( DataHolders\Booking\Item $item )
    {
        /** @var Booking\Package $item */
        if ( $item->isPackage() ) {
            Notifications\Package\Sender::send( $item->getPackage() );
        }

        return $item;
    }

    /**
     * @inerhitDoc
     */
    public static function paymentCreateDetailsFromItem( $details, DataHolders\Booking\Item $item )
    {
        if ( $item->getType() === DataHolders\Booking\Item::TYPE_PACKAGE ) {
            $details = new Details\Package();
        }

        return $details;
    }

}