<?php
namespace BooklyPackages\Lib\DataHolders\Details;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\DataHolders\Booking\Item;
use Bookly\Lib\DataHolders\Details;
use BooklyPackages\Lib\Entities;
use Bookly\Lib\Entities\Payment;

class Package extends Details\Base
{
    protected $type = Payment::ITEM_PACKAGE;

    protected $fields = array(
        'service_name',
        'service_price',
        'service_tax',
        'staff_name',
        'deposit_format',
    );

    /**
     * @param \BooklyPackages\Lib\DataHolders\Booking\Package $item
     * @return void
     */
    protected function setItem( Item $item )
    {
        $this->setPackage( $item->getPackage() );
    }

    /**
     * @param Entities\Package $package
     * @param float $price
     * @return void
     */
    public function setPackage( Entities\Package $package, $price = null )
    {
        $item = new \BooklyPackages\Lib\DataHolders\Booking\Package();
        $item->setPackage( $package );

        $this->price = $price ?: $item->getServicePrice();
        $this->deposit = BooklyLib\Proxy\DepositPayments::prepareAmount( $this->getPrice(), $item->getDeposit(), 1 );

        $this->setData( array(
            'service_name' => $item->getService()->getTitle(),
            'service_price' => $this->price,
            'service_tax' => $item->getServiceTax(),
            'staff_name' => $item->getStaff() ? $item->getStaff()->getFullName() : __( 'Unassigned', 'bookly' ),
            'deposit_format' => BooklyLib\Proxy\DepositPayments::formatDeposit( $this->getDeposit(), $item->getDeposit() ),
        ) );
    }

}