<?php
namespace BooklyPackages\Lib;

use Bookly\Lib as BooklyLib;
use BooklyPackages\Backend;
use BooklyPackages\Frontend;

abstract class Plugin extends BooklyLib\Base\Plugin
{
    protected static $prefix;
    protected static $title;
    protected static $version;
    protected static $slug;
    protected static $directory;
    protected static $main_file;
    protected static $basename;
    protected static $text_domain;
    protected static $root_namespace;
    protected static $embedded;

    /**
     * @inheritDoc
     */
    protected static function init()
    {
        Backend\Components\Gutenberg\PackagesList\Block::init();

        // Register proxy methods.
        Backend\Components\Dialogs\Appointment\AttachPackage\ProxyProviders\Local::init();
        Backend\Components\Dialogs\Appointment\Edit\ProxyProviders\Shared::init();
        Backend\Components\Dialogs\Service\Edit\ProxyProviders\Local::init();
        Backend\Components\Dialogs\Service\Edit\ProxyProviders\Shared::init();
        Backend\Components\Dialogs\Staff\Edit\ProxyProviders\Local::init();
        Backend\Components\TinyMce\ProxyProviders\Shared::init();
        Backend\Modules\Appointments\ProxyProviders\Shared::init();
        Backend\Modules\Calendar\ProxyProviders\Shared::init();
        Backend\Modules\Customers\ProxyProviders\Shared::init();
        Backend\Modules\Notifications\ProxyProviders\Shared::init();
        Backend\Modules\Services\ProxyProviders\Shared::init();
        Backend\Modules\Settings\ProxyProviders\Shared::init();
        Notifications\Assets\Test\ProxyProviders\Shared::init();
        Payment\ProxyProviders\Shared::init();
        Payment\ProxyProviders\Local::init();
        ProxyProviders\Local::init();
        ProxyProviders\Shared::init();

        if ( ! is_admin() ) {
            // Init short code.
            Frontend\Modules\CustomerPackages\ShortCode::init();
        }
        Frontend\Modules\ModernBookingForm\ProxyProviders\Shared::init();
    }

    /**
     * @inerhitDoc
     */
    protected static function registerAjax()
    {
        Backend\Components\Dialogs\Appointment\AttachPackage\Ajax::init();
        Backend\Components\Dialogs\Package\Ajax::init();
        Backend\Components\Dialogs\Schedule\Ajax::init();
        Backend\Components\Dialogs\Staff\Ajax::init();
        Backend\Modules\Packages\Ajax::init();
    }
}