<?php
namespace BooklyPackages\Backend\Modules\Notifications\ProxyProviders;

use Bookly\Backend\Modules\Notifications\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareNotificationCodes( array $codes, $type )
    {
        $codes['package'] = array(
            'package_name' => array( 'description' => __( 'Name of package', 'bookly' ) ),
            'package_size' => array( 'description' => __( 'Package size', 'bookly' ) ),
            'package_price' => array( 'description' => __( 'Price of package', 'bookly' ) ),
            'package_life_time' => array( 'description' => __( 'Package life time', 'bookly' ) ),
            'cancellation_reason' => array( 'description' => __( 'Reason you mentioned while deleting package', 'bookly' ), 'if' => true ),
        );

        return $codes;
    }

    /**
     * @inheritDoc
     */
    public static function buildNotificationCodesList( array $codes, $notification_type, array $codes_data )
    {
        switch ( $notification_type ) {
            case 'new_package':
            case 'package_deleted':
                $codes = array_merge(
                    $codes_data['category'],
                    $codes_data['company'],
                    $codes_data['customer'],
                    $codes_data['package'],
                    $codes_data['service'],
                    $codes_data['staff']
                );
                if ( $notification_type != 'package_deleted' ) {
                    unset ( $codes['cancellation_reason'] );
                }
                break;
        }

        return $codes;
    }

}