<?php
namespace BooklyPackages\Backend\Components\Dialogs\Schedule;

use Bookly\Lib as BooklyLib;

class Dialog extends BooklyLib\Base\Component
{
    public static function render()
    {
        self::enqueueStyles( array(
            'alias' => array( 'bookly-backend-globals', ),
        ) );

        self::enqueueScripts( array(
            'module' => array( 'js/package-schedule-dialog.js' => array( 'bookly-backend-globals' ), ),
        ) );

        wp_localize_script( 'bookly-package-schedule-dialog.js', 'BooklyL10nPackageScheduleDialog', array(
            'mjsDateFormat' => BooklyLib\Utils\DateTime::convertFormat( 'date', BooklyLib\Utils\DateTime::FORMAT_MOMENT_JS ),
            'mjsTimeFormat' => BooklyLib\Utils\DateTime::convertFormat( 'time', BooklyLib\Utils\DateTime::FORMAT_MOMENT_JS ),
            'datePicker' => BooklyLib\Utils\DateTime::datePickerOptions( array(
                'minDate' => BooklyLib\Utils\Common::isCurrentUserAdmin() ? null : 0,
                'maxDate' => BooklyLib\Utils\Common::isCurrentUserAdmin() ? null : BooklyLib\Config::getMaximumAvailableDaysForBooking(),
            ) ),
            'ajaxurl'       => admin_url( 'admin-ajax.php' ),
        ) );

        self::renderTemplate( 'modal' );
    }
}