<?php
namespace BooklyInvoices\Lib;

use Bookly\Lib;

class Updater extends Lib\Base\Updater
{
    public function update_5_4()
    {
        $new_pc_key = 'bookly_invoices_purchase_code';
        $old_pc_key = 'bookly_invoices_envato_purchase_code';
        $current_pc = get_option( $old_pc_key, 'missing' );
        if ( $current_pc === 'missing' ) {
            add_option( $new_pc_key, '' );
        } else {
            if ( $current_pc ) {
                add_option( $new_pc_key, $current_pc );
            }
            delete_option( $old_pc_key );
        }
    }

    public function update_4_9()
    {
        add_option( 'bookly_invoices_id_fill_gaps', '0' );
        add_option( 'bookly_invoices_id_start_number', '1' );
    }

    public function update_4_0()
    {
        if ( get_option( 'bookly_invoices_font_name' ) === 'freeserif' ) {
            update_option( 'bookly_invoices_font_name', 'freesans' );
        }
    }

    public function update_3_8()
    {
        add_option( 'bookly_invoices_show_adjustments', '0' );
    }

    public function update_3_7()
    {
        add_option( 'bookly_invoices_file_prefix', 'Invoice_' );
    }

    public function update_2_7()
    {
        $this->addL10nOptions( array(
            'bookly_l10n_button_download_invoice' => __( 'Download invoice', 'bookly' ),
        ) );

        add_option( 'bookly_invoices_show_download_invoice', '0' );
    }

    public function update_2_5()
    {
        add_option( 'bookly_invoices_font_name', 'freesans' );
    }

    public function update_2_3()
    {
        $this->addL10nOptions( array(
            'bookly_l10n_invoice_bill_to_label_right' => '',
            'bookly_l10n_invoice_bill_to_data_right' => '',
            'bookly_l10n_invoice_company_label_right' => '',
            'bookly_l10n_invoice_company_data_right' => '',
            'bookly_l10n_invoice_info_data_right' => '',
            'bookly_l10n_invoice_label_top' => '',
            'bookly_l10n_invoice_label_bottom' => '',
        ) );
    }

    public function update_1_2()
    {
        delete_option( 'bookly_invoices_enabled' );
    }
}