<?php
namespace BooklyInvoices\Frontend\Modules\Booking;

use Bookly\Lib as BooklyLib;

class Ajax extends BooklyLib\Base\Ajax
{
    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array( '_default' => 'anonymous' );
    }

    /**
     * Download invoice.
     */
    public static function downloadInvoice()
    {
        /** @var BooklyLib\Entities\Payment $payment */
        $payment = BooklyLib\Entities\Payment::query( 'p' )
            ->leftJoin( 'Order', 'o', 'o.id = p.order_id' )
            ->where( 'o.token', self::parameter( 'bookly_order' ) )
            ->findOne();
        if ( $payment ) {
            BooklyLib\Proxy\Invoices::downloadInvoice( $payment );
        }

        BooklyLib\Utils\Common::emptyResponse( 404 );
    }
}