<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly
use Bookly\Backend\Components\Controls\Buttons;
use Bookly\Backend\Components\Controls\Inputs as ControlsInputs;
use Bookly\Backend\Components\Settings\Inputs;
use Bookly\Backend\Components\Settings\Selects;
use Bookly\Backend\Components;
use Bookly\Lib\Utils\Common;
use BooklyInvoices\Backend\Components\Invoice\Invoice;

?>
    <div class="tab-pane" id="bookly_settings_invoices">
        <form method="post" action="<?php echo esc_url( add_query_arg( 'tab', 'invoices' ) ) ?>">
            <div class="card-body">
                <div class="form-group">
                    <?php Inputs::renderNumber( 'bookly_invoices_due_days', __( 'Invoice due days', 'bookly' ), __( 'This setting specifies the due period for the invoice (from 1 to 365 days)', 'bookly' ), 1, 1, 365 ) ?>
                </div>
                <div class="form-group">
                    <?php Selects::renderSingle( 'bookly_invoices_font_name', __( 'Font', 'bookly' ), __( 'Choose the font for your invoice template', 'bookly' ), array( array( 'freesans', 'Freesans' ), array( 'nanumgothic', 'Nanum Gothic' ), array( 'mplus1p', 'M PLUS 1p' ), array( 'aealarabiya', 'ae_AlArabiya' ) ) ) ?>
                </div>
                <?php Inputs::renderText( 'bookly_invoices_file_prefix', __( 'Invoice file name prefix', 'bookly' ), __( 'Set a prefix for the file name that will be used for your invoices. For example, if the file name prefix is "myfile_", your PDF file will be downloaded with the "myfile_1.pdf" name', 'bookly' ) ) ?>
                <?php
                Selects::renderSingle( 'bookly_invoices_id_fill_gaps', __( 'Sequential numbering', 'bookly' ), __( 'If enabled, invoices will be numbered sequentially. If disabled, invoice numbers will match the corresponding payment numbers.', 'bookly' ), array(), array( 'data-expand' => '1' ) );
                ?>
                <div class="border-left mt-3 ml-4 pl-3 bookly_invoices_id_fill_gaps-expander"<?php if ( get_option( 'bookly_invoices_id_fill_gaps', 0 ) === '1' ) : ?> style="display:none;"<?php endif ?>>
                    <?php
                    Inputs::renderNumber( 'bookly_invoices_id_start_number', __( 'Initial invoice number', 'bookly' ), __( 'Enter the starting number for your invoices. For example, if you set it to 1000, the first invoice will be numbered 1000, the second 1001, the third 1002, and so on.', 'bookly' ) );
                    ?>
                </div>
                <?php Selects::renderSingle( 'bookly_invoices_show_adjustments', __( 'Show manual adjustments', 'bookly' ) ) ?>
                <div class="form-group">
                    <label class="mb-0"><?php esc_html_e( 'Invoice template', 'bookly' ) ?></label>
                    <small class="form-text text-muted mb-1"><?php esc_html_e( 'Specify the template for the invoice.', 'bookly' ) ?></small>
                    <?php echo Invoice::appearance() ?>
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <a class="btn btn-default" href="<?php echo admin_url( 'admin-ajax.php?action=bookly_invoices_preview&csrf_token=' . Common::getCsrfToken() ) ?>"><?php esc_html_e( 'Preview', 'bookly' ) ?></a>
                <?php ControlsInputs::renderCsrf() ?>
                <?php Buttons::renderSubmit( null, 'mx-2' ) ?>
                <?php Buttons::renderReset() ?>
            </div>
        </form>
    </div>
<?php Components\Editable\Elements::renderModals( 'bookly-settings-invoices' ) ?>