<?php
namespace BooklyFiles\Lib;

use Bookly\Lib;

class Updater extends Lib\Base\Updater
{
    public function update_3_9()
    {
        $new_pc_key = 'bookly_files_purchase_code';
        $old_pc_key = 'bookly_files_envato_purchase_code';
        $current_pc = get_option( $old_pc_key, 'missing' );
        if ( $current_pc === 'missing' ) {
            add_option( $new_pc_key, '' );
        } else {
            if ( $current_pc ) {
                add_option( $new_pc_key, $current_pc );
            }
            delete_option( $old_pc_key );
        }
    }

    public function update_3_4()
    {
        $this->alterTables( array(
            'bookly_files' => array(
                'ALTER TABLE `%s` ADD COLUMN `ci_id` INT NULL',
            ),
        ) );
        delete_option( 'bookly_files_enabled' );
    }

    public function update_3_1()
    {
        add_option( 'bookly_files_extensions', '' );
        $this->addL10nOptions( array(
            'bookly_l10n_incorrect_file_type' => __( 'File\'s extension is not allowed', 'bookly' ),
        ) );
    }

    public function update_1_8()
    {
        $this->upgradeCharsetCollate( array(
            'bookly_customer_appointment_files',
            'bookly_files',
        ) );
    }

    public function update_1_3()
    {
        /** @global \wpdb $wpdb */
        global $wpdb;

        // Rename tables.
        $tables = array(
            'customer_appointment_files',
            'files',
        );
        $query = 'RENAME TABLE ';
        foreach ( $tables as $table ) {
            $query .= sprintf( '`%s` TO `%s`, ', $this->getTableName( 'ab_' . $table ), $this->getTableName( 'bookly_' . $table ) );
        }
        $query = substr( $query, 0, -2 );
        $wpdb->query( $query );
    }

    public function update_1_1()
    {
        $this->alterTables( array(
            'ab_files' => array(
                'ALTER TABLE `%s` ADD COLUMN `custom_field_id` INT NULL',
            ),
        ) );
    }
}