<?php
namespace BooklyFiles\Frontend\Modules\Booking\ProxyProviders;

use Bookly\Frontend\Modules\Booking\Proxy;
use BooklyFiles\Lib;

class Local extends Proxy\Files
{
    /**
     * @inerhitDoc
     */
    public static function renderField( \stdClass $field, array $data, $type )
    {
        if ( $field->type === 'file' ) {
            $fields = array(
                array(
                    'id' => $field->id,
                    'value' => isset( $data[ $field->id ] ) ? $data[ $field->id ] : null,
                ),
            );

            $names = $type === 'custom-field'
                ? Lib\ProxyProviders\Local::getFileNamesForCustomFields( $fields )
                : Lib\ProxyProviders\Local::getFileNamesForCustomerInformationFields( $fields );

            $name = $names ? $names[ $field->id ] : '';

            self::renderTemplate( '_6_details', compact( 'field', 'data', 'name', 'type' ) );
        }
    }
}