<?php
/**
 * AX Social Stream 3.6.0
 * Copyright 2014-2019 Axent Media (support@axentmedia.com)
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AXS_Hero_Layout extends AXS_Layout {
	function __construct() {
		add_filter( 'axs_supported_layouts_hero', function() {
			return ['carousel'];
		});
		// If using the same theme for different streams on the same page
		if ( ! has_filter( 'axs_inline_styles_hero' )  ) {
			add_filter( 'axs_inline_styles_hero', array( $this, 'axs_inline_styles_callback'), 10, 1 );
			add_filter( 'axs_create_item_hero', array( $this, 'axs_create_item_callback'), 10, 6 );
			add_filter( 'axs_create_ad_hero', array( $this, 'axs_create_ad_callback'), 10, 4 );
			add_filter( 'axs_carousel_classes_hero', array( $this, 'axs_carousel_classes_callback') );
		}
	}
	
	function axs_create_item_callback( $feed_class, $param, $attr = array(), $sbi = 0, $i = 0, $ifeed = 0 ) {
		$filtername = ' '.$feed_class.'-'.$i.'-'.$ifeed;
		$playstate = (isset($param['play']) && ! empty($param['play'])) ? '<div class="sb-playstate"></div>' : '';
		$user_title = (isset($param['user']['title']) && ! empty($param['user']['title'])) ? $param['user']['title'] : $param['user']['name'];
		$datasize = (isset($param['size']) && ! empty($param['size'])) ? ' data-size="' . $param['size'] . '"' : '';
		$imgAlt = $this->axs_create_alt($feed_class, $param);

		$item_data_link = isset($param['url']) ? 'data-link="'.$param['url'].'"' : '';
		$item_data_is_lightbox = (isset($param['iframe']) && !empty($param['iframe']) && in_array($param['iframe'],['icbox','iframe'])) ? ' data-lightbox="true"' : ' data-lightbox="false"';

		$noclass = array();
		if ( empty($this->output['info']) )
			$noclass[] = ' sb-nofooter';
		if ( empty($param['thumb']) || empty($this->output['thumb']) )
			$noclass[] = ' sb-nothumb';
		if ( count($noclass) > 1 ) {
			$noclass = array();
			$noclass[] = ' sb-noft';
		}

		$no_meta = ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) ? false : true;
		if ($no_meta)
			$noclass[] = ' sb-nometa';

		// thumb block
		$thumb = '';
		if ( ! empty($param['thumb']) && isset($this->output['thumb']) && ! empty($this->output['thumb'])) {
			$aurl = htmlspecialchars($param['thumburl'] ?? ($param['url'] ?? ''));
			if (isset($param['object']) && ! empty($param['object']) && isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'media') {
				$aurl32 = sprintf("%u", crc32($aurl) );
				$aurl = "#$aurl32";
				$thumb .= '
				<div style="display: none">
					<div class="sb-object" id="'.$aurl32.'">
						' . $param['object'] . '
					</div>
				</div>';
			}

			$sbimg = (isset($attr['lazyload']) && ! empty($attr['lazyload'])) ? 'data-lazy="' . htmlspecialchars($param['thumb']) . '"' : 'src="' . htmlspecialchars($param['thumb']) . '"';
			$thumb .= '
			<img class="ax-slider__main-img sb-img" ' . $sbimg . ' alt="' . $imgAlt . '" />'.$playstate;
		}
		
		$idstr = ' id="'.$sbi.'"';
		if (isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'slideshow') {
			$inline = ' data-href="#inline_'.$sbi.'"';
			$sbinline = ' sb-inline';
		} else {
			$inline = ' data-href="' . ($aurl ?? '') . '"';
			$sbinline = '';
		}

		$date_text = !empty($param['date']) ? '<a href="' . ($param['url'] ?? '') . '"'.$this->target.'>' . axs_friendly_date($param['date'], $this->attr['dateformat']) . '</a>' : '';

		$header = $headerinfo = $user_text = '';
		// user block
		if ( ( !empty($param['user']) && !empty($this->output['user']) ) || !empty($this->output['info']) ) {
			if (isset($param['user']['title']) && !empty($param['user']['title']) && !empty($param['user']['name']) ) {
				$user_title = $param['user']['title'];
				$user_name = '@'.$param['user']['name'];
				$user_text = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>' . $user_name . '</a>' : $user_name;
			} else {
				$user_title = $param['user']['name'] ?? '';
				if ( isset($param['user']['status']) && !empty($param['user']['status']) ) {
					$user_text = ( isset($param['url']) && !empty($param['url']) ) ? '<a href="' . $param['url'] . '"'.$this->target.'>' . $param['user']['status'] . '</a>' : $param['user']['status'];
				}
			}

			if (isset($param['user']['image']) && !empty($param['user']['image']) && !empty($this->output['user']) ) {
				$user_image = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'><img class="ax-slider__avatar-img sb-img" alt="' . $param['user']['name'] . '" src="' . $param['user']['image'] . '"></a>' : '<img class="ax-slider__avatar-img sb-img" alt="' . $param['user']['name'] . '" src="' . $param['user']['image'] . '">';
				$headerinfo .= '
					<div class="ax-slider__avatar">
						' . $user_image . '
					</div>';
			} else {
				$no_thumb_class = ' sb-nouthumb';
			}

			if ( ($user_title || $user_text) && !empty($this->output['user']) ) {
				$user_title_linked = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>'.$user_title.'</a>' : $user_title;
				$headerinfo .= '
				<div class="ax-slider__info'.($no_thumb_class ?? '').'">
					<div class="ax-slider__name">' . $user_title_linked . '</div>
					<div class="ax-slider__profile-link">
						' . $user_text . ( $user_text ? ' / ' : '' ) . $date_text . '
					</div>
				</div>';
			}

			if ( !empty($this->output['info']) ) {
				$headerinfo .= '
				<i class="ax-slider__icon-type">
					<i class="fab fa-' . $feed_class . '"></i>
				</i>';
			}

			if ( !empty($headerinfo) ) {
				$header .= '
				<div class="ax-slider__header">
					' . $headerinfo . '
				</div>';
			}
		}
		
		// body block
		$body = '';
		if ( (isset($param['text']) && ! empty($param['text']) && isset($this->output['text']) && ! empty($this->output['text'])) ) {
			$expandclass = (empty($thumb)) ? ' sb-expand' : '';

			if (isset($param['title']) && ! empty($param['title']) && isset($this->output['title']) && ! empty($this->output['title']) && isset($attr['carousel']) && ! empty($attr['carousel'])) {
				// @todo: handle title
				$inner_title = '
				<span class="sb-title">
					' . $param['title'] . '
				</span>';
			} else {
				$expandclass .= ' sb-notitle';
			}
			
			$body .= '
			<div class="ax-slider__body'.$expandclass.'">
				<div class="ax-slider__description">
					' . ($inner_title ?? '') . '
					' . $param['text'] . '
				</div>
			</div>';
		}

		$footer = $metashare = '';
		// comments/likes block
		if ( ! $no_meta ) {
			$ticons = ['likes' => 'far fa-heart', 'comments' => 'fas fa-comment', 'retweets' => 'fas fa-retweet'];
			if ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) {
				foreach ($param['meta'] as $key => $meta) {
					if ( ! empty($meta['total']) ) {
						if ( intval($meta['total']['count']) > 0 ) {
							$metashare .= '
							<div class="ax-slider__'.$key.'">'
							. ( isset($meta['total']['url']) ? '<a href="' . $meta['total']['url'] . '"'.$this->target.'>' : '') . '
								<i class="ax-slider__icon-footer '.($ticons[$key] ?? "").'" title="' . ucfirst( __( $key, 'social-board' ) ) . '"></i>
								<span class="ax-slider__label">' . countFormatter($meta['total']['count']) . '</span>'
								. ( isset($meta['total']['url']) ? '</a>' : '') . '
							</div>';
						}
					}
				}
			}
		}
		// END: comments/likes block

		// share block
		if ( isset($param['url']) && ! empty($param['url']) && isset($this->output['share']) && ! empty($this->output['share']) ) {
			if (isset($param['share']) && ! empty($param['share']))
				$metashare .= $param['share'];
			else {
				$sharetitle = urlencode( strip_tags($param['title'] ?? '') );
				$sharemedia = urlencode( $param['thumb'] ?? '' );
				$metashare .= '
				<div class="ax-slider__share">
					<a class="ax-slider__share-icon ax-slider__share-icon--facebook" href="https://www.facebook.com/sharer.php?u=' . urlencode($param['url']) . '&amp;t=' . ($sharetitle ?? '') . '"'.$this->target.'>
						<i class="fab fa-facebook-f"></i>
					</a>
					<a class="ax-slider__share-icon ax-slider__share-icon--twitter" href="https://twitter.com/intent/tweet?url=' . urlencode($param['url']) . '&amp;text=' . ($sharetitle ?? '') . '"'.$this->target.'>
						<i class="fab fa-twitter-square"></i>
					</a>
					<a class="ax-slider__share-icon ax-slider__share-icon--pinterest" href="//pinterest.com/pin/create/link/?url=' . urlencode($param['url']) . '&amp;description=' . ($sharetitle ?? '') . '&amp;media=' . ($sharemedia ?? '') . '"'.$this->target.'>
						<i class="fab fa-pinterest-square"></i>
					</a>
					<a class="ax-slider__share-icon ax-slider__share-icon--linkedin" href="https://www.linkedin.com/shareArticle?mini=true&amp;url=' . urlencode($param['url']) . '&amp;title=' . ($sharetitle ?? '') . '"'.$this->target.'>
						<i class="fab fa-linkedin"></i>
					</a>
					<a href="javascript:void(0)" class="ax-slider__share-icon ax-slider__share-icon--main">
						<i class="fas fa-share-alt"></i>
					</a>
				</div>';
			}
		}

		// footer block
		if ( ! empty($metashare) ) {
			$footer .= '
			<div class="ax-slider__footer">
				' . $metashare . '
			</div>';
		}
		
		if($child_medias = $this->axs_create_child_items($param,$sbi)){
			$is_child_media = '<i class="sb-child-media-true"></i>';
		}
		
		$iframe = (isset($param['iframe']) && ! empty($param['iframe'])) ? ' '.$param['iframe'] : '';
		$out = '
			<div class="ax-slider__item sb-item sb-' . $feed_class . $filtername . $sbinline . $iframe .'"'.$idstr.$inline.$datasize.' '.$item_data_link.$item_data_is_lightbox.'>
				' . ($is_child_media ?? '') . $thumb . ($child_medias ?? '') . '
				<div class="ax-slider__overlay"></div>
				<div class="ax-slider__inner' . ( implode('', $noclass) ) . '">
					' . $header . '
					' . $body . '
					' . $footer . '
				</div>
			</div>';
		$out .= "\n";

		return $out;
	}

	function axs_create_ad_callback($adgrid, $adstyle, $adcontent, $ad) {
		$adout = '
		<div class="ax-slider__item">
			<div class="sb-advert">
				<div class="sb-container"'.(isset($adstyle) && ! empty($adstyle) ? ' style="'.$adstyle.'"' : '').'>';
				$adout .= $adcontent;
				$adout .= '
				</div>
			</div>
		</div>' . "\n";

		return $adout;
	}

	function axs_carousel_classes_callback( $value ) {
		$skin = $this->themetypeoption['skin'] ?? 'dark';
		$hover_effect = $this->themetypeoption['hover_effect'] ?? 'rotate';
		
		return ' ax-slider--' . $skin . '-theme ax-slider--hover-effect-' . $hover_effect . ' ax-slider--diff' . $value;
	}

	function axs_inline_styles_callback( $args ) {
		extract($args);

		if (isset($this->attr['carousel']) && ! empty($this->attr['carousel'])) {
			$slide_height = $this->attr['cs_height']['thumb'] + $this->attr['cs_height']['text'] + 120;
			$style["$dotboard.sb-carousel .ax-slider__item"][] = 'height: '.$slide_height.'px';
		}

		return $style;
	}
}
