<?php
/**
 * AX Social Stream
 * Copyright 2014-2019 Axent Media (support@axentmedia.com)
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AXS_Brick_Layout extends AXS_Layout {
	public $grid_counter = 5;
	public $item_counter = 0;

	function __construct() {
		add_filter( 'axs_supported_layouts_brick', function() {
			return ['grid'];
		});
		// If using the same theme for different streams on the same page
		if ( ! has_filter( 'axs_inline_styles_brick' )  ) {
			add_filter( 'axs_inline_styles_brick', array( $this, 'axs_inline_styles_callback'), 10, 1 );
			add_filter( 'axs_create_item_brick', array( $this, 'axs_create_item_callback'), 10, 6 );
			add_filter( 'axs_create_ad_brick', array( $this, 'axs_create_ad_callback'), 10, 4 );
			add_filter( 'axs_theme_classes_brick', array( $this, 'axs_theme_classes_callback') );
		}
	}
	
	function axs_create_item_callback( $feed_class, $param, $attr = array(), $sbi = 0, $i = 0, $ifeed = 0 ) {
		$filtername = ' '.$feed_class.'-'.$i.'-'.$ifeed;
		$iconSocial = '<span class="sb-iconm sb-' . $feed_class . '"><i class="sb-iconm-inner sb-icon sb-' . $feed_class . '"></i></span>';
		$playstate = (isset($param['play']) && !empty($param['play'])) ? '<div class="sb-playstate"></div>' : '';
		$datasize = (isset($param['size']) && !empty($param['size'])) ? ' data-size="' . $param['size'] . '"' : '';
		$imgAlt = $this->axs_create_alt($feed_class, $param);

		$item_data_link = isset($param['url']) ? ' data-link="'.$param['url'].'"' : '';
		$item_data_is_lightbox = (isset($param['iframe']) && !empty($param['iframe']) && in_array($param['iframe'],['icbox','iframe'])) ? ' data-lightbox="true"' : ' data-lightbox="false"';

		$noclass = array();
		if ( empty($this->output['info']))
			$noclass[] = ' sb-nofooter';
		if ( empty($param['thumb']) || empty($this->output['thumb']))
			$noclass[] = ' sb-nothumb';
		if ( count($noclass) > 1 ) {
			$noclass = array();
			$noclass[] = ' sb-noft';
		}
		$inner = '<div class="sb-container'.( implode('', $noclass) ).'">';

		$thumb_media_class = '';
		if ( isset($this->themedefoption['hover_effect']) && $hover_effect = $this->themedefoption['hover_effect']) {
			$thumb_media_class .= " sb-$hover_effect";
		}
		if ($child_medias = $this->axs_create_child_items($param,$sbi)) {
			$inner .= $child_medias;
			$thumb_media_class .= " sb-child-media-true";
		}
		
		$thumb = $sbthumb = '';
		if (!empty($param['thumb']) && !empty($this->output['thumb'])) {
			$iframe = (!empty($param['iframe'])) ? ' class="'.$param['iframe'].'"' : '';
			$aurl = htmlspecialchars($param['thumburl'] ?? $param['url'] ?? '' );
			if (!empty($param['object']) && isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'media') {
				$aurl32 = sprintf("%u", crc32($aurl) );
				$aurl = "#$aurl32";
				$sbthumb .= '
				<div style="display: none">
					<span class="sb-object" id="'.$aurl32.'">
						' . $param['object'] . '
					</span>
				</div>';
			}
			$sbthumb = '
			<div class="sb-thumb'.($thumb_media_class ?? '').'">
				<a href="' . $aurl . '"'.$iframe.$datasize.$this->target.'><img class="sb-img" data-original="' . htmlspecialchars($param['thumb']) . '" src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iLTQzIC00MyAxMjQgMTI0IiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHN0cm9rZT0iI2ZmZiI+ICAgIDxnIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+ICAgICAgICA8ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgxIDEpIiBzdHJva2Utd2lkdGg9IjIiPiAgICAgICAgICAgIDxjaXJjbGUgc3Ryb2tlLW9wYWNpdHk9Ii41IiBjeD0iMTgiIGN5PSIxOCIgcj0iMTgiLz4gICAgICAgICAgICA8cGF0aCBkPSJNMzYgMThjMC05Ljk0LTguMDYtMTgtMTgtMTgiPiAgICAgICAgICAgICAgICA8YW5pbWF0ZVRyYW5zZm9ybSAgICAgICAgICAgICAgICAgICAgYXR0cmlidXRlTmFtZT0idHJhbnNmb3JtIiAgICAgICAgICAgICAgICAgICAgdHlwZT0icm90YXRlIiAgICAgICAgICAgICAgICAgICAgZnJvbT0iMCAxOCAxOCIgICAgICAgICAgICAgICAgICAgIHRvPSIzNjAgMTggMTgiICAgICAgICAgICAgICAgICAgICBkdXI9IjFzIiAgICAgICAgICAgICAgICAgICAgcmVwZWF0Q291bnQ9ImluZGVmaW5pdGUiLz4gICAgICAgICAgICA8L3BhdGg+ICAgICAgICA8L2c+ICAgIDwvZz48L3N2Zz4=" alt="'.$imgAlt.'">'.$playstate.'</a>
			</div>';
		}
		$inner .= $sbthumb;
		
		$idstr = ' id="'.$sbi.'"';
		if (isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'slideshow') {
			$inline = ' data-href="#inline_'.$sbi.'"';
			$sbinline = ' sb-inline';
		} else {
			$inline = $sbinline = '';
		}
		
		if ( ! empty($this->output['info']) ) {
			$inner .= $iconSocial;
		}

		$inner .= '
			<div class="sb-inner">
				<div class="sb-inner2">';
		
		if (isset($param['text']) && !empty($param['text']) && isset($this->output['text']) && !empty($this->output['text'])) {
			$expandclass = (empty($thumb)) ? ' sb-expand' : '';
			$inner .= '<span class="sb-text'.$expandclass.'">';
			if (isset($attr['scroll']) && !empty($attr['scroll']))
				$inner .= '<p class="marquee">';

			if (isset($param['title']) && !empty($param['title']) && isset($this->output['title']) && !empty($this->output['title'])) {
				$inner .= '
				<span class="sb-title">
					' . $param['title'] . '
				</span>';
			}
			$inner .= $param['text'] ?? '';
			
			if (isset($attr['scroll']) && !empty($attr['scroll']))
				$inner .= '</p>';

			$inner .= '</span>';
		}

		if (!empty($param['tags']) && !empty($this->output['tags'])) {
			$inner .= '
			<span class="sb-text">
				' . $param['tags'] . '
			</span>';
		}
		$inner .= '</div>';
		
		if ( !empty($this->output['user']) || !empty($this->output['comments']) || !empty($this->output['likes']) ) {
			$inner .= '
			<div class="sb-inner3">
				<div>';

			if ( isset($param['user']) && !empty($param['user']) ) {
				if (isset($param['user']['title']) && !empty($param['user']['title']) && isset($param['user']['name']) && !empty($param['user']['name'])) {
					$user_title = $param['user']['title'] ?? '';
				} else {
					$user_title = $param['user']['name'] ?? '';
				}

				$inner .= '
					<div class="sb-user">';
				if (isset($param['user']['image']) && !empty($param['user']['image'])) {
					$user_image = ( !empty($param['user']['url']) ) ? '<a href="' . ($param['user']['url'] ?? '') . '"'.$this->target.'><img class="sb-img" alt="' . ($param['user']['name'] ?? '') . '" src="' . $param['user']['image'] . '"></a>' : '<img class="sb-img" alt="' . ($param['user']['name'] ?? '') . '" src="' . $param['user']['image'] . '">';
					$inner .= '
					<div class="sb-uthumbcon"><div class="sb-uthumb">'.$user_image.'</div></div>';
				} else {
					$no_thumb_class = ' sb-nouthumb';
				}
				$user_title_linked = ( !empty($param['user']['url']) ) ? '<a href="' . ($param['user']['url'] ?? '') . '"'.$this->target.'>'.$user_title.'</a>' : $user_title;
				$inner .= '
					<div class="sb-uinfo'.($no_thumb_class ?? '').'">
						<div class="sb-utitle">' . $user_title_linked . '</div>';
				$inner .= '
					</div>
				</div>';
			}
			
			// comments/likes block
			if ( !empty($param['meta']) && ( !empty($this->output['comments']) || !empty($this->output['likes']) ) ) {
				$ticons = ['likes' => 'like', 'comments' => 'comments', 'retweets' => 'retweet'];
				$mc = 0;
				$inner .= '
				<span class="sb-metadata">';
				if ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) {
					foreach ($param['meta'] as $key => $meta) {
						if ( ! empty($meta['total']) ) {
							if ($mc == 0 ) {
								$inner .= '<span class="sb-meta">';
								$mc = 1;
							}
							if ( intval($meta['total']['count']) > 0 ) {
								$inner .= '
								<span class="' . $key . '" title="' . ucfirst( __( $key, 'social-board' ) ) . '">'
								. ( isset($meta['total']['url']) ? '<a href="' . $meta['total']['url'] . '"'.$this->target.'>' : '') . '
									<i class="sb-bico sb-'.(!empty($meta['total']['class']) ? $meta['total']['class'] : $ticons[$key]).'"></i> ' . countFormatter($meta['total']['count'])
								. ( isset($meta['total']['url']) ? '</a>' : '') . '
								</span>';
							}
						}
					}
					if ($mc == 1) {
						$inner .= '</span>';
						$mc = 0;
					}
				}
				$inner .= '
				</span>';
			}
			// END: comments/likes block
			$inner .= '
				</div>
			</div>';
		}
		
		$us = '';
		if ( $param['date'] && !empty($this->output['info']) ) {
		$us .= '
				<div class="sb-date">';
		$us .= ( !empty($param['url']) ) ? '<a href="' . ($param['url'] ?? '') . '"'.$this->target.'>' . axs_friendly_date($param['date'], $this->attr['dateformat']) . '</a>' : axs_friendly_date($param['date'], $this->attr['dateformat']);
		$us .= '
				</div>';
		}
		if ( !empty($param['url']) && !empty($this->output['share']) ) {
			if ( isset($param['share']) && !empty($param['share']) ) {
				$us .= $param['share'];
			} else {
				$sharetitle = urlencode( strip_tags($param['title'] ?? '') );
				$us .= '
				<span class="sb-share">
					<a class="sb-facebook sb-hover" href="https://www.facebook.com/sharer.php?u=' . urlencode($param['url']) . '&t=' . ($sharetitle ?? '') . '"'.$this->target.'>
						<i class="sb-sicon sb-facebook"></i>
					</a>
					<a class="sb-twitter sb-hover" href="https://twitter.com/intent/tweet?url=' . urlencode($param['url']) . '&text=' . ($sharetitle ?? '') . '"'.$this->target.'>
						<i class="sb-sicon sb-twitter"></i>
					</a>
					<a class="sb-pinterest sb-hover" href="//pinterest.com/pin/create/link/?url=' . urlencode($param['url']) . '&description=' . ($sharetitle ?? '') . '"'.$this->target.'>
						<i class="sb-sicon sb-pinterest"></i>
					</a>
					<a class="sb-linkedin sb-hover" href="https://www.linkedin.com/shareArticle?mini=true&url=' . urlencode($param['url']) . '&title=' . ($sharetitle ?? '') . '"'.$this->target.'>
						<i class="sb-sicon sb-linkedin"></i>
					</a>
				</span>';
			}
		}
		if (isset($us) && !empty($us))
			$inner .= '
			<div class="sb-info">
				' . $us . '
			</div>';
		$inner .= '
		</div>';

		$classes = 'sb-' . $feed_class . $filtername . $sbinline;
		return $this->set_column($attr, $classes, $inner, $idstr . $inline,'',$item_data_link,$item_data_is_lightbox);
	}

	function axs_create_ad_callback($adgrid, $adstyle, $adcontent, $ad) {
		$inner = '<div class="sb-container"'.(!empty($adstyle) ? ' style="'.$adstyle.'"' : '').'>';
		$inner .= $adcontent;
		$classes = 'sb-advert';
		$column_classes = (isset($this->attr['columns_style']) && $this->attr['columns_style'] == "1") ? $adgrid : '';
		
		return $this->set_column($this->attr, $classes, $inner, '', $column_classes);
	}

	function set_column($attr, $classes = '', $inner = '', $inline_attr = '', $column_classes = '',$item_data_link = '',$item_data_is_lightbox = '') {
		$out = '';
		$gridclass = '';

		if (isset($attr['columns_style']) && $attr['columns_style'] == "1-2") {
			if ($this->item_counter % 3 == 0)
				$out .= '<div class="sb-column'.$column_classes.'">';

			$gridclass = ($this->grid_counter == 5 || $this->grid_counter == 4) ? ' sb-twofold' : ' sb-solo';

			if ($this->grid_counter == 5) {
				$this->grid_counter = 0;
			} else {
				$this->grid_counter++;
			}
		} else {
			$out .= '<div class="sb-column'.$column_classes.'">';
		}

		$out .= '
		<div class="sb-item'.$gridclass.' ' . $classes .'"' . $inline_attr . ' '.$item_data_link.$item_data_is_lightbox.'>
			' . $inner;
		$out .= '
		</div>
		</div>' . "\n";
		
		if (isset($attr['columns_style']) && $attr['columns_style'] == "1-2") {
			if ($this->item_counter % 3 == 2)
				$out .= '</div>';

			$this->item_counter++;
		} else {
			$out .= '</div>';
		}
		
		return $out;
	}

	function axs_create_colors( $dotboard ) {
		$social_colors = $this->themedefoption['social_colors'];
		$style = array();
		foreach ($social_colors as $colorKey => $colorVal) {
			if ( is_array($this->feed_keys[$colorKey]) ) {
				$feedname = key($this->feed_keys[$colorKey]);
				// set colors for networks
				if (isset($colorVal) && !empty($colorVal) && $colorVal != 'transparent' ) {
					if (isset($this->attr['lightboxtype']) && $this->attr['lightboxtype'] == 'slideshow')
						$style['.sb-slide-icon.sb-'.$feedname][] = 'background-color: '.$colorVal.' !important';

					$dotfilter = $dotboard;
					$style[$dotfilter.' .sb-'.$feedname.' .sb-iconm::before'][] = 'border-color: transparent '.$colorVal.' transparent transparent';
					$style[$dotfilter.' .sb-'.$feedname.'.sb-hover:hover, '.$dotfilter.' .sb-'.$feedname.'.active'][] = 'background-color: '.$colorVal.' !important;border-color: '.$colorVal.' !important;color: #fff !important';
				}
			}
		}
			
		// set item background color
		if ( isset($this->attr['item_background_color']) && !empty($this->attr['item_background_color']) ) {
			$style["$dotboard .sb-item .sb-inner"][] = 'background-color: '.$this->attr['item_background_color'];
		}
		if ( empty($this->output['info']) && empty($this->output['share'])) {
			$style["$dotboard .sb-item .sb-user"][] = 'border-bottom: 0';
		}
		
		// set item border
		if ( isset($this->attr['item_border_color']) && !empty($this->attr['item_border_color']) ) {
			$dontbordersize = true;
			$style["$dotboard .sb-item .sb-container"][] = 'border: '.($this->attr['item_border_size'] ?? '').'px solid '.$this->attr['item_border_color'];
		}
		if ( isset($this->attr['item_border_size']) && !empty($this->attr['item_border_size']) && empty($dontbordersize) ) {
			$style["$dotboard .sb-item .sb-container"][] = 'border-width: '.($this->attr['item_border_size'] ?? '').'px';
		}
		
		return $style;
	}

	function axs_theme_classes_callback( $value ) {
		$skin = $this->themetypeoption['skin'] ?? 'light';
		
		return 'sb-brick-' . $skin . '-skin' . $value;
	}

	function axs_inline_styles_callback( $args ) {
		extract($args);

		if (isset($this->themedefoption['social_colors']) && !empty($this->themedefoption['social_colors'])) {
			$style = $this->axs_create_colors($dotboard);
		}

		return $style;
	}

	function axs_add_scripts_callback( $args ) {

	}
}
