(function ($) {
	$.fn.SbShowMore = function (options) {
		var defaults = {
			btnText: "Show More",
			w768: 3,
			w600: 2,
			w480: 2,
			w320: 1
		}

		var _this_id = $(this).attr("id");
		var _this_parent = $(this).closest("div[id^='sb_']");
		var settings = $.extend({}, defaults, options);
		var SbItems = $(this).children(".sb-item");
		if (!SbItems.length) return false;
		var _width = jQuery(window).width();

		if ($(".sb-item:hidden").length) {
			$(".sb-item:hidden").show();
		}
		if ($("#sb_show_more_"+ _this_id).length) {
			$("#sb_show_more_"+ _this_id).remove();
		}
		if (_this_parent.children(".sb-loadmore").length) {
			_this_parent.children(".sb-loadmore").show();
		}

		if (_width <= 768) {
			var MaxShowItems;
			if ($(this).width() <= 768) {
				MaxShowItems = settings.w768;
			}
			if ($(this).width() <= 600) {
				MaxShowItems = settings.w600;
			}
			if ($(this).width() <= 480) {
				MaxShowItems = settings.w480;
			}
			if ($(this).width() <= 320) {
				MaxShowItems = settings.w320;
			}

			if (!MaxShowItems) {
				MaxShowItems = 12;
			}

			if (SbItems.length <= MaxShowItems) {
				return false;
			}

			SbItems.addClass("sb-item-hide");
			SbItems.each(function (i, e) {
				if (i > (MaxShowItems - 1)) {
					return false;
				}
				
				$(this).removeClass("sb-item-hide");
			});
			
			if (_this_parent.children(".sb-loadmore").length) {
				_this_parent.children(".sb-loadmore").attr("data-parent",_this_id).hide();
			}
			
			$(this).after('<div id="sb_show_more_'+ $(this).attr("id") +'" class="sb-loadshowmore"><p> '+ settings.btnText +' </p></div>');

		}

		$(document).on("click", ".sb-loadshowmore", function () {
			var _id = $(this).attr("id");
			var _itemsBox = _id.replace("sb_show_more_", "#");
			var _parent = _itemsBox.replace("#", "");
			$(_itemsBox).children(".sb-item").removeClass("sb-item-hide");
			$(this).remove();
			if ($(".sb-loadmore[data-parent='"+ _parent +"']").length) {
				$(".sb-loadmore[data-parent='"+ _parent +"']").show(0, function () {
					$(window).scrollTop($(window).scrollTop() + 1);
				});
			}
		});
	};
}(jQuery));

