<?php

namespace AXS_AX_SOCIAL\WP;

class AXS_Wordpress
{
	public function GetCategoriesSelectList()
	{
		$cats = get_categories();
		if($cats){
			$return = array();
			$return[''] = __( 'Select category', 'social-board-admin' );
			foreach ($cats as $cat){
				$return[$cat->term_id] = __( $cat->name, 'social-board-admin' );
			}
			return $return;
		}
	}
	public function GetIntermediateImageSizes()
	{
		$return = array(
			"" => __( 'Original width', 'social-board-admin' )
		);
		if(!empty(get_intermediate_image_sizes())){
			foreach (get_intermediate_image_sizes() as $i){
				$w = (!empty(get_option( $i . '_size_w' ))) ? ' - ' . get_option( $i . '_size_w' ) . 'px' : "";
				$return[$i] = __( $i . $w, 'social-board-admin' );
			}
		}
		return $return;
	}
	public function GetResponse($set=array())
	{
		$def = array(
			"action" => null,
			"numberposts" => 5,
			"feed_value" => "",
		);
		
		$op = array_merge($def,$set);
		
		if($op["action"] == "category"){
			$op["category"] = $op["feed_value"];
			unset($op["feed_value"]);
		}
		if($op["action"] == "tag"){
			$op["tag"] = $op["feed_value"];
			unset($op["feed_value"]);
		}

		if(!empty($op["action"]) && (!empty($op["tag"]) || !empty($op["category"]))) return get_posts($op);
	}
}