<?php

namespace AXS_AX_SOCIAL\INSTAGRAM;

class AXS_Instagram {
	public $cache, $forceCrawl, $debug_log, $settings;

    function __construct() {
        $this->settings = get_option("AXS_Settings_Page") ? get_option("AXS_Settings_Page") : get_option("SB_Settings_Page");
    }

	public function GetInstagramOption() {
		return ! empty($this->settings['section_instagram']) ? $this->settings['section_instagram'] : null;
	}

	public function GetInstagramAccounts() {
		$op = $this->GetInstagramOption();
		return ! empty($op['instagram_accounts']) ? $op['instagram_accounts'] : null;
	}

	public function GetId($feed_value) {
		$instagram_accounts = $this->GetInstagramAccounts();
		if ( is_array($instagram_accounts) or is_object($instagram_accounts) ) {
			if ( array_key_exists($feed_value, $instagram_accounts) ) {
				return $feed_value;
			} else {
				foreach ($instagram_accounts as $r) {
					if ($r["username"] == $feed_value or $r["access_token"] == $feed_value) {
						return $r["id"];
					}
				}
			}
		}

		return $feed_value;
	}

	// Find Instagram business account
	public function GetAccount($feed_value) {
		$feed_account = '';
		$op = $this->GetInstagramOption();
		if ( ! empty($op['instagram_bussiness_accounts']) ) {
			foreach ($op['instagram_bussiness_accounts'] as $account) {
				// If access token found for this account by ID
				if ( isset($account['accounts'][$feed_value]) ) {
					$feed_account = $account['accounts'][$feed_value];
				} else {
					// If not found, search by username
					if(isset($account['accounts']) && (is_array($account['accounts']) || is_object($account['accounts']))){
						foreach ($account['accounts'] as $iaccount) {
							if ( isset($iaccount['username']) && $iaccount['username'] == $feed_value ) {
								$feed_account = $iaccount;
								break;
							}
						}
					}
				}
			}
        }

        return $feed_account;
	}

    private function GetRefreshToken($access_token) {
		$feed_url = "https://graph.instagram.com/refresh_access_token?grant_type=ig_refresh_token&access_token=".$access_token;
		$is_cached = $this->cache->is_cached($feed_url);
		$content = ( ! $this->forceCrawl ) ? $this->cache->get_data($feed_url, $feed_url) : $this->cache->do_curl($feed_url);
		if ( empty($content) ) return;
		$feed = json_decode($content);

		if ( isset($feed->access_token) ) {
			return $feed;
		} else {
			if ( ! empty($feed->error) ) {
				if ( ! empty($feed->error->message) && ! $is_cached ) {
					$error_msg = $feed->error->message;
					if ( ! empty($feed->error->error_user_msg) )
						$error_msg .= "\n" . $feed->error->error_user_msg;
					if ($this->debug_log) {
						axs_log( 'Instagram error: '. $error_msg .' - ' . $feed_url );
					}
				}
				return;
			}
		}
    }

	public function GetAccessToken($id) {
		$Accounts = $this->GetInstagramAccounts();
		if ($Accounts) {
			if ( array_key_exists($id, $Accounts) ) {
				if ( ! empty($Accounts[$id]["access_token"]) ) {
					$token = $Accounts[$id]["access_token"];
					
					// Refresh token if expired
					
					// r3.8.2 < compatibility fix
					if ( ! isset($Accounts[$id]['expires_in']))
						$Accounts[$id]['expires_in'] = 5183996;
					if ( ! isset($Accounts[$id]['updated_at']) )
						$Accounts[$id]['updated_at'] = time();
					// END - r3.8.2 < compatibility fix

					$is_expired = time() > $Accounts[$id]['updated_at'] + $Accounts[$id]['expires_in'] - 86400;
					// 86400 = 24 hours is left to expire
					if ($is_expired) {
						$newToken = $this->GetRefreshToken($token);
						if ( ! empty($newToken) ) {
							$token = $newToken->access_token;

							// Update token
							$setoptions = $this->settings;
							$setoptions['section_instagram']['instagram_accounts'][$id]["access_token"] = $token;
							$setoptions['section_instagram']['instagram_accounts'][$id]["expires_in"] = $newToken->expires_in;
							$setoptions['section_instagram']['instagram_accounts'][$id]["updated_at"] = time();
							update_option("AXS_Settings_Page", $setoptions);
						}
					}

					return $token;
				}
			}
		}
	}

	public function GetUser($id) {
		$access_token = $this->GetAccessToken($id);
		$feed_url = "https://graph.instagram.com/me?fields=account_type,id,media_count,username,media&access_token=".$access_token;
		$is_cached = $this->cache->is_cached($feed_url);
		$content = ( ! $this->forceCrawl ) ? $this->cache->get_data($feed_url, $feed_url) : $this->cache->do_curl($feed_url);
		
		if ( empty($content) ) return;

		$feed = json_decode($content);
		
		if ( isset($feed->account_type) ) {
			return $feed;
		} else {
			if ( ! empty($feed->error) ) {
				if ( ! empty($feed->error->message) && ! $is_cached ) {
					if ($this->debug_log)
						axs_log( 'Instagram error: '.$feed->error->message.' - ' . $feed_url );
				}
				$feed = null;
			}
		}
		
		return;
	}

	public function GetMedias($id, $limit, $after = null) {
		$user = $this->GetUser($id);
		$access_token = $this->GetAccessToken($id);
		
		if ( (int) $limit < 1) $limit = 1;
		
		if ( ! empty($user) ) {
			$after_str = ! empty($after) ? "&after={$after}" : '';
			$fields = "caption,id,media_type,media_url,permalink,thumbnail_url,timestamp,username,children{id,media_type,media_url,permalink,thumbnail_url,timestamp,username}";
			$feed_url = "https://graph.instagram.com/{$user->id}/media?fields={$fields}&limit={$limit}{$after_str}&access_token=".$access_token;

			$is_cached = $this->cache->is_cached($feed_url);
			$content = ( ! $this->forceCrawl ) ? $this->cache->get_data($feed_url, $feed_url) : $this->cache->do_curl($feed_url);
			if (empty($content)) return;

			$feed = json_decode($content);
			if ( isset($feed->data) && ! empty($feed->data) ) {
				return $feed;
			} else {
				if ( ! empty($feed->error) ) {
					if ( ! empty($feed->error->message) && ! $is_cached ) {
						if ($this->debug_log) {
							axs_log( 'Instagram error: '.$feed->error->message.' - ' . $feed_url );
						}
					}
					$feed = null;
				}
			}

			return;
		}
	}

	public function GetContent($id, $limit = 25, $after = null) {
		$user = $this->GetUser($id);
		if ($user) {
			$media = $this->GetMedias($id, (int)$limit, $after);
			if ($media) {
				return $this->GetData($media, $user);
			}
		}
	}

	public function GetData($media, $user = null) {
		$mediaDatas = array();
		if ( ! empty($media->data) )
			foreach ($media->data as $r) {
				
				$link = isset($r->permalink) ? $r->permalink : (isset($r->link) ? $r->link : "");
				$type = isset($r->media_type) ? $r->media_type : (isset($r->type) ? $r->type : "");

				$shortcode = !empty($link) ? array_values(array_filter(explode("/", parse_url($link, PHP_URL_PATH))))[1] : "";
				if(isset($r->shortcode)){
					$shortcode = $r->shortcode;
				}
				
				$created_time = isset($r->created_time) ? $r->created_time : (isset($r->timestamp) ? strtotime($r->timestamp) : time());
				
				$caption = isset($r->caption) ? $r->caption : "";
				if(is_object($caption) && property_exists($caption,"text")){
					$caption = $caption->text;
				}

				$images_url = "";
				if (isset($r->images)) {
					$images_url = $r->images;
				}
				if (empty($images_url) && $type == "IMAGE") {
					$images_url = $r->media_url;
				}
				if (empty($images_url) && $type == "VIDEO" && isset($r->thumbnail_url)) {
					$images_url = $r->thumbnail_url;
				}
				if (empty($images_url) && $type == "CAROUSEL_ALBUM") {
					if (isset($r->media_url) && !in_array("video", explode("-", parse_url($r->media_url)["host"]))) {
						$images_url = $r->media_url;
					} else {
						if (isset($r->children) && isset($r->children->data)) {
							foreach ($r->children->data as $cdr) {
								if (isset($cdr->media_type)) {
									if ($cdr->media_type == "IMAGE") {
										$images_url = $cdr->media_url;
										break;
									}
									if ($cdr->media_type == "VIDEO" && isset($cdr->thumbnail_url)) {
										$images_url = $cdr->thumbnail_url;
										break;
									}
								}
							}
						}
					}
				}

				// Hashtag Feed Fix: Do not show the item if it is not containing a photo
				if (empty($images_url)) {
					continue;
				}

				$square_images = isset($r->square_images) ? $r->square_images : array();
				
				$videos_url = "";
				if($type == "VIDEO"){
					if(isset($r->media_product_type) && $r->media_product_type == "IGTV" ){
						
					} else {
						if(isset($r->videos)){
							$videos_url = $r->videos;
						}
						else{
							if(isset($r->media_url)){
								$videos_url = $r->media_url;
							}
						}
					}
				}

				$like_count = isset($r->likes) && isset($r->likes->count) ? $r->likes->count : (isset($r->like_count) ? $r->like_count : 0);
				$comments_count = isset($r->comments) && isset($r->comments->count) ? $r->comments->count : (isset($r->comments_count) ? $r->comments_count : 0);

				$data = array(
					"id" => $r->id,
					"link" => $link,
					"type" => $type,
					"shortcode" => $shortcode,
					"created_time" => $created_time,
					"caption" => (object) array(
						"text" => $caption
					),
					"images" => $this->GetImages($images_url),
					"square_images" => $this->GetSquareImages($square_images),
					"videos" => $this->GetVideos($videos_url),
					"likes" => $this->GetLikes($like_count),
					"comments" => $this->GetComments($comments_count),
				);
				
				if(isset($r->media_product_type)){
					$data["product_type"] = $r->media_product_type;
				}
				
				if ($type == "CAROUSEL_ALBUM") {
					if (isset($r->children) && isset($r->children->data) ) {
						foreach ($r->children->data as $media_child) {
							if (isset($media_child->media_type) ) {
								if ($media_child->media_type == "IMAGE") {
									$data["sidecar_media"][] = $media_child->media_url;
								}
								if ($media_child->media_type == "VIDEO" && isset($media_child->thumbnail_url) ) {
									$data["sidecar_media"][] = $media_child->thumbnail_url;
								}
							}
						}
					} else {
						if (isset($r->sidecar_media) && !empty($r->sidecar_media) ) {
							foreach ($r->sidecar_media as $media_sidecar) {
								if ( ! in_array("video",explode("-",parse_url($media_sidecar)["host"]) ) ) {
									$data["sidecar_media"][] = $media_sidecar;
								}
							}
						}
					}
				}
				
				if(isset($r->user) || !empty($user) || isset($r->username) || isset($r->owner)){
					
					if(isset($r->user) && !empty($r->user)){
						$userData = (array) $r->user;
					}
					else if(isset($r->owner) && !empty($r->owner)){
						$userData = (array) $r->owner;
					}
					else if(!empty($user)){
						$userData = (array) $user;
					}
					else if(isset($r->username) && !empty($r->username)){
						$userData = array(
							"username" => $r->username
						);
					}
					
					if(isset($userData) && !empty($userData)){
						$data["user"] = (object) array(
							"id" => $userData["id"] ?? "",
							"username" => $userData["username"] ?? "",
							"full_name" => $userData["full_name"] ?? "",
							"profile_picture" => isset($userData["profile_picture"]) ? $userData["profile_picture"] : (isset($userData["profile_picture_url"]) ? $userData["profile_picture_url"] : "" )
						);
					}
					
				}

				$mediaDatas[] = (object) $data;
			}

		return (object) array(
			"pagination" => (object) array(
				"next_max_id" => $media->paging->cursors->after ?? ""
			),
			"data" => $mediaDatas
		);
	}

	public function GetImages($url = "") {
		if(!empty($url) && (is_array($url) || is_object($url))){
			$url = array_map(function ($item){
				if(is_object($item) || is_array($item)){
					$item = (array) $item;
					return $item["url"] ?? "";
				}

				return $item;

			},(array) $url);
		}

		$return = (object) array(
			"thumbnail" => (object) array(
				"url" => (is_array($url) && isset($url["thumbnail"])) ? $url["thumbnail"] : $url
			),
			"low_resolution" => (object) array(
				"url" => (is_array($url) && isset($url["low_resolution"])) ? $url["low_resolution"] : $url
			),
			"standard_resolution" => (object) array(
				"url" => (is_array($url) && isset($url["standard_resolution"])) ? $url["standard_resolution"] : $url
			),
			"high_resolution" => (object) array(
				"url" => (is_array($url) && isset($url["high_resolution"])) ? $url["high_resolution"] : $url
			),
		);
		return $return;
	}

	public function GetSquareImages($url = "") {
		return (array) $url;
	}

	public function GetVideos($url = "") {
    	
    	if(empty($url)){
    		return ;
		}
    	
    	if(is_object($url)){
    		return $url;
		}
    	
		return (object) array(
			"low_resolution" => (object) array(
				"url" => $url
			),
			"standard_resolution" => (object) array(
				"url" => $url
			),
			"low_bandwidth" => (object) array(
				"url" => $url
			)
		);
	}

	public function GetComments($comments = '')
	{
		return (object) array(
			"count" => $comments
		);
	}
	public function GetLikes($likes = '')
	{
		return (object) array(
			"count" => $likes
		);
	}
	
}