<?php

/**
 * AX Social Stream
 * Copyright 2018 Axent Media (support@axentmedia.com)
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AXS_Layout {
  public $target, $output;
  public $themetypeoption, $themedefoption;
  public $layout, $feed_keys, $type, $attr;

  function supported_layouts() {
    return apply_filters( "axs_supported_layouts_{$this->layout}", '' );
  }

  function create_item( $feed_class, $param, $attr = array(), $sbi = 0, $i = 0, $ifeed = 0 ) {
    return apply_filters( "axs_create_item_{$this->layout}", $feed_class, $param, $attr, $sbi, $i, $ifeed );
  }

  function create_slideitem( $feed_class, $param, $sbi = 0, $i = 0, $ifeed = 0 ) {
    return apply_filters( "axs_create_slideitem_{$this->layout}", $feed_class, $param, $sbi, $i, $ifeed );
  }

  function create_ad( $adgrid, $adstyle, $adcontent, $ad ) {
    return apply_filters( "axs_create_ad_{$this->layout}", $adgrid, $adstyle, $adcontent, $ad );
  }

  function axs_inline_styles( $args ) {
    return apply_filters( "axs_inline_styles_{$this->layout}", $args );
  }

  function axs_theme_classes() {
    return apply_filters( "axs_theme_classes_{$this->layout}", '' );
  }

  function axs_carousel_classes() {
    return apply_filters( "axs_carousel_classes_{$this->layout}", '' );
  }

  function axs_create_alt($feed_class, $param) {
		if ( isset($param["title"]) && ! empty($param["title"]) ) {
			return strip_tags($param["title"]);
		}
		elseif ( isset($param["text"]) && ! empty($param["text"]) && !empty(preg_replace('@<(\w+)\b.*?>.*?</\1>@si', '', $param["text"])) ) {
			$alt = preg_replace('@<(\w+)\b.*?>.*?</\1>@si', '', $param["text"]);
			return (mb_strlen(strip_tags($alt), 'utf8') <= 100) ?  strip_tags($alt) : substr(strip_tags($alt), 0, 96) . "....";
		}
		elseif ( isset($param["user"]["title"]) && ! empty($param["user"]["title"]) ) {
			return strip_tags($param["user"]["title"]);
		}
		elseif ( isset($param["user"]["name"]) && ! empty($param["user"]["name"]) ) {
			return $param["user"]["name"];
		}
		else {
			return $feed_class;
		}
  }

	function axs_create_child_items($param, $sbi) {
		if ( isset($param["child"]["medias"]) && ! empty($param["child"]["medias"]) && is_array($param["child"]["medias"]) ) {
			$out = "";
			foreach ($param["child"]["medias"] as $r) {
				$out .= '<img style="display:none" src="'.$r.'"/>';
			}
			return '<div style="display:none" id="childs_'.$sbi.'">'.$out.'</div>';
		}
	}
}
