<?php
/**
 * AX Social Stream
 * Copyright 2014 Axent Media (support@axentmedia.com)
 */

class Elementor_AX_Social_Stream_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'Elementor_AX_Social_Stream';
    }

    public function get_title() {
        return __( 'AX Social Stream', 'social-board-admin' );
    }

    public function get_icon() {
        return 'eicon-social-icons';
    }

    public function get_categories() {
        return [ 'general' ];
    }

    protected function _register_controls() {

        $items = array();
        $choices = array();

        // get sb items
        $items = axs_getPostTitles('sb_posts');

        foreach ($items as $itemKey => $itemValue) {
            $choices[$itemKey] = $itemValue;
        }

        if ( empty( $choices ) ) {
            $choices[] = array( __( 'No Social Stream items available.', 'social-board-admin' ) => '' );
        }

        $this->start_controls_section(
            'Elementor_AX_Social_Stream_section',
            [
                'label' => __( 'Content', 'social-board-admin' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'id',
            [
                'label' => __( 'Social Stream', 'social-board-admin' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $choices
            ]
		);
		
        $this->add_control(
            'type',
            [
                'label' => __( 'Display Mode', 'social-board-admin' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'wall' => __("Masonry", 'social-board-admin'),
                    'timeline' => __("Timeline", 'social-board-admin'),
                    'feed' => __('Rotating Feed', 'social-board-admin'),
                    'carousel' => __('Carousel', 'social-board-admin'),
                    'grid' => __('Grid', 'social-board-admin')
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $shortcode = '[social_board id="'.$settings["id"].'" type="'.$settings["type"].'"]';
        ?>
        <div class="elementor_ax_social_stream"><?php echo do_shortcode($shortcode); ?></div>
        <?php

    }
}
