<?php

/**
 * AX Social Stream
 * Copyright © 2014 Axent Media LLC, All Rights Reserved.
 * https://axentmedia.com/support/
 */

// Create the setting page
class AXS_Settings_Page extends SB_AdminPageFramework {
	private $api_page_url;
	private $linkedin_token_url,
			$twitter_token_url,
			$facebook_token_url,
			$instagram_token_url,
			$instagram_facebook_token_url,
			$soundcloud_token_url,
			$tiktok_token_url;
	const FACEBOOK_API_VERSION = 'v13.0';
	const TOKEN_SERVER = 'https://axentmedia.com/';
    
    public function start_AXS_Settings_Page() {
		$purchase_code_param = '&purchase_code='.axs_license_key().'&slug=ax-social-stream';

        // Set get token urls
        $this->twitter_token_url = self::TOKEN_SERVER.'twitter-access-token/?return_url='.$GLOBALS['sb_apipage_url'].$purchase_code_param;
        $this->linkedin_token_url = self::TOKEN_SERVER.'linkedin-access-token/?return_url='.$GLOBALS['sb_apipage_url'].$purchase_code_param;
		$this->facebook_token_url = self::TOKEN_SERVER.'facebook-access-token/?return_url='.$GLOBALS['sb_apipage_url'].$purchase_code_param;
		$this->instagram_token_url = self::TOKEN_SERVER.'instagram-access-token/?action=get_instagram_token&return_url='.$GLOBALS['sb_apipage_url'].$purchase_code_param;
		$this->instagram_facebook_token_url = self::TOKEN_SERVER.'instagram-facebook-access-token/?instagram=yes&return_url='.$GLOBALS['sb_apipage_url'].$purchase_code_param;
		$this->soundcloud_token_url = self::TOKEN_SERVER.'soundcloud-access-token/?return_url='.$GLOBALS['sb_apipage_url'].$purchase_code_param;
		$this->tiktok_token_url = self::TOKEN_SERVER.'tiktok-access-token/?action=get_tiktok_token&return_url='.$GLOBALS['sb_apipage_url'].$purchase_code_param;

		$this->api_page_url = admin_url( 'edit.php?post_type=sb_posts&page=sb_settings&tab=api' );

        // Add inline scripts
        add_filter('admin_footer', array( &$this, 'axs_settings_inline_script' ) );
    }

    /**
     * Sets up pages.
     */
    public function setUp() {
        /* ( optional ) this can be set via the constructor. For available values, see https://codex.wordpress.org/Roles_and_Capabilities */
        $this->setCapability( 'manage_options' );
        
        /* ( required ) Set the root page */
        $this->setRootMenuPageBySlug( 'edit.php?post_type=sb_posts' );
        
        $this->addSubMenuItems(
            array(
                'title' => __( 'Stream Settings', 'social-board-admin' ),
                'page_slug' => 'sb_settings',
                'show_debug_info' => false
            ),
            array(
                'title' => __( 'Documentation', 'social-board-admin' ),
                'href' => AXS_DOCS,
                'show_page_heading_tab' => false
            )
        );
        
        $this->setPluginSettingsLinkLabel( __( 'Settings', 'social-board-admin' ) );
        $this->oProp->aFooterInfo['sRight'] = '';
    }
    
    /**
     * The pre-defined callback method triggered when one of the added pages loads
     */
    public function load_AXS_Settings_Page( $oAdminPage ) { // load_{instantiated class name}
    
        /* ( optional ) Determine the page style */
        $this->setPageHeadingTabsVisibility( false ); // disables the page heading tabs by passing false.
        $this->setInPageTabTag( 'h2' ); // sets the tag used for in-page tabs
    }
    
    /**
     * The pre-defined callback method that is triggered when the page loads.
     */
    public function load_sb_settings( $oAdminPage ) { // load_{page_slug}
        
        /*
         * Add in-page tabs
         * Page-heading tabs show the titles of sub-page items which belong to the set root page. 
         * In-page tabs show tabs that you define to be embedded within an individual page.
         */
        $this->addInPageTabs(
            /*
             * In-page tabs to display built-in field types
             * */
            'sb_settings', // set the target page slug so that the 'page_slug' key can be omitted from the next continuing in-page tab arrays.
            array(
                'tab_slug' => 'layouts', // avoid hyphen(dash), dots, and white spaces
                'title' => __( 'Enabled Layouts', 'social-board-admin' ),
                'order' => 1 // ( optional ) - if you don't set this, an index will be assigned internally in the added order
            ),
            array(
                'tab_slug' => 'setting', // avoid hyphen(dash), dots, and white spaces
                'title' => __( 'Display Setting', 'social-board-admin' ),
            ),
            array(
                'tab_slug' => 'api',
                'title' => __( 'API Credentials', 'social-board-admin' )
            ),
            array(
                'tab_slug' => 'reset',
                'title' => __( 'Reset Options', 'social-board-admin' )
            ),
            array(
                'tab_slug' => 'licensing',
                'title' => __( 'Licensing', 'social-board-admin' )
            )
        );
        
        $debuglog = SB_AdminPageFramework::getOption( 'AXS_Settings_Page', array( 'setting', 'debuglog' ), 0 ) ?? SB_AdminPageFramework::getOption( 'SB_Settings_Page', array( 'setting', 'debuglog' ), 0 );
        if ($debuglog)
            $this->addInPageTabs(
                array(
                    'tab_slug' => 'debug',
                    'title' => __( 'Debug', 'social-board-admin' ),
                )
            );
        
        /*
         * Add setting sections
         * Section needs to be created prior to fields.
         * Use the addSettingSections() method to create sections and use the addSettingFields() method to create fields.
         */
        $this->addSettingSections(
            'sb_settings', // the target page slug
            array(
                'section_id'        => 'setting',
                'page_slug'         => 'sb_settings', // <-- the method remembers the last used page slug and the tab slug so they can be omitted from the second parameter.
                'tab_slug'          => 'setting', // <-- similar to the page slug, if the tab slug is the same as the previous one, it can be omitted.
                'title'             => __( 'General Setting', 'social-board-admin' ),
                'description'       => __( 'These options apply to all display modes.', 'social-board-admin' )
            )
        );

        $this->addSettingSections(
            'sb_settings', // the target page slug
            array(
                'section_id'        => 'proxysetting',
                'page_slug'         => 'sb_settings',
                'tab_slug'          => 'setting',
                'title'             => __( 'Proxy Setting', 'social-board-admin' ),
                'description'       => __( 'All requests to APIs will be sent over this HTTP proxy if you set here.', 'social-board-admin' )
            )
        );

        // get enabled layouts
        $enabled_layouts = axs_enabled_layouts();
        
        if ( ! empty($enabled_layouts['wall']) )
            $this->addSettingSections(
                'sb_settings', // the target page slug
                array(
                    'section_id'        => 'wallsetting',
                    'tab_slug'          => 'setting',
                    'title'             => __( 'Masonry Display Setting', 'social-board-admin' ),
                    'description'       => __( 'These options only apply to the Masonry display mode.', 'social-board-admin' )
                )
            );

        if ( ! empty($enabled_layouts['feed']) )
            $this->addSettingSections(
                'sb_settings', // the target page slug
                array(
                    'section_id'        => 'feedsetting',
                    'tab_slug'          => 'setting',
                    'title'             => __( 'Rotating Feed Display Setting', 'social-board-admin' ),
                    'description'       => __( 'These options only apply to the rotating feed display mode.', 'social-board-admin' )
                )
            );

        if ( ! empty($enabled_layouts['carousel']) )
            $this->addSettingSections(
                'sb_settings', // the target page slug
                array(
                    'section_id'        => 'carouselsetting',
                    'tab_slug'          => 'setting',
                    'title'             => __( 'Carousel Display Setting', 'social-board-admin' ),
                    'description'       => __( 'These options only apply to the carousel display mode.', 'social-board-admin' )
                )
            );

        if ( ! empty($enabled_layouts['grid']) )
            $this->addSettingSections(
                'sb_settings', // the target page slug
                array(
                    'section_id'        => 'gridsetting',
                    'tab_slug'          => 'setting',
                    'title'             => __( 'Grid Display Setting', 'social-board-admin' ),
                    'description'       => __( 'These options only apply to the grid display mode.', 'social-board-admin' )
                )
            );

        if ( ! empty($enabled_layouts['timeline']) )
            $this->addSettingSections(
                'sb_settings', // the target page slug
                array(
                    'section_id'        => 'timelinesetting',
                    'tab_slug'          => 'setting',
                    'title'             => __( 'Timeline Display Setting', 'social-board-admin' ),
                    'description'       => __( 'These options only apply to the timeline display mode.', 'social-board-admin' )
                )
            );
        
        $this->addSettingSections(
            'sb_settings', // the target page slug
            array(
                'section_id'  => 'section_facebook',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'Facebook API Credentials',
                'description' => 'Required For All Facebook Feeds. <a href="'. AXS_DOCS . '#facebook-api" target="_blank">Check this tutorial</a> for more details on how to connect your Facebook accounts/pages to the plugin.'
            ),
            array(
                'section_id'  => 'section_twitter',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'Twitter API Credentials',
                'description' => 'Required For All Twitter Feeds. <a href="'. AXS_DOCS . '#twitter-api" target="_blank">Check this tutorial</a> for more details on how to connect your Twitter accounts to the plugin.<br>Due to another sudden change in the Twitter API, updating feeds is limited to 2 updates per day.'
			),
			array(
                'section_id'  => 'section_instagram',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'Instagram API Credentials',
				'description' => 'Required For All Instagram Feeds.'
			),
			array(
                'section_id'  => 'section_tiktok',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'TikTok API Credentials',
				'description' => 'Required For All TikTok Feeds. <a href="'. AXS_DOCS . '#tiktok-api" target="_blank">Check this tutorial</a> for more details on how to connect your TikTok accounts to the plugin.'
			),
            array(
                'section_id'  => 'section_google',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'Google API Credentials',
                'description' => 'Required For All YouTube Feeds. <a href="'. AXS_DOCS . '#google-api" target="_blank">Check this tutorial</a> for more details on how to get your Google API KEY.'
            ),
            array(
                'section_id'  => 'section_tumblr',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'Tumblr API Credentials',
                'description' => 'Required For All Tumblr Feeds. <a href="'. AXS_DOCS . '#tumblr-api" target="_blank">Check this tutorial</a> for more details on how to get your Tumblr API Key.'
            ),
            array(
                'section_id'  => 'section_flickr',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'Flickr API Credentials',
                'description' => 'Required For All Flickr Feeds. <a href="'. AXS_DOCS . '#flickr-api" target="_blank">Check this tutorial</a> for more details on how to get your Flickr API Key.'
            ),
            array(
                'section_id'  => 'section_vimeo',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'Vimeo API Credentials',
                'description' => 'Required For All Vimeo Feeds. <a href="'. AXS_DOCS . '#vimeo-api" target="_blank">Read this documentation</a> to find out how to obtain your Vimeo Access Token.'
            ),
            array(
                'section_id'  => 'section_vk',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'VK API Credentials',
                'description' => 'Required For All VK Feeds. <a href="'. AXS_DOCS . '#vk-api" target="_blank">Check this tutorial</a> for more details on how to get your VK Service Token.'
            ),
            array(
                'section_id'  => 'section_soundcloud',
                'page_slug'   => 'sb_settings',
                'tab_slug'    => 'api',
                'title'       => 'SoundCloud API Credentials',
                'description' => 'Required For All SoundCloud Feeds. <a href="'. AXS_DOCS . '#soundcloud-api" target="_blank">Check this tutorial</a> for more details on how to get your SoundCloud Access Token.'
            )
        );
        
        $oAdminPage->addSettingSections(
            'sb_settings', // the target page slug
            array(
                'tab_slug'          => 'reset',
                'section_id'        => 'section_reset',
                'title'             => __( 'Reset Default Options', 'social-board-admin' )
            ),
            array(
                'tab_slug'          => 'licensing',
                'section_id'        => 'section_licensing',
                'title'             => __( 'Register AX Social Stream', 'social-board-admin' )
            ),
            array(
                'tab_slug'          => 'layouts',
                'section_id'        => 'section_layouts',
                'title'             => __( 'Enable/Disable Stream Layouts', 'social-board-admin' )
            )
        );
        
        /*
         * ( optional ) Adds setting fields into the meta box.
         */
        $this->addSettingFields(
            array(
                'section_id' => 'setting',
                'field_id' => 'theme',
                'type' => 'select',
                'title' => __( 'Stream Theme', 'social-board-admin' ),
                'label' => axs_getPostTitles('sb_themes'),
                'attributes' => array(
                    'select' => array(
                        'style' => "width: 150px;"
                    )
                ),
                'description' => __( 'Select a theme to style your Social Stream.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'results',
                'type' => 'number',
                'title' => __( 'Results Limit', 'social-board-admin' ),
                'default' => 20,
                'attributes' => array(
                    'max'   => 60,
                    'min'   => 1,
                    'step'  => 1
                ),
                'description' => __( 'Limiting the total number of results to display on the Social Stream per page from all connected feeds - Maximum 100.<br /><strong>Note: </strong>You can also set the number of results to display separately per each social network per page within the Social Stream Configurations page.<br /><strong>Note: </strong>There is a restriction for number of feed output results on each social network. For example, if you enter 100 as "Results Limit", you will only get 50 items from YouTube in each request.<br />Facebook Group: 20, Tumblr: 50, Pinterest = 25, YouTube: 50, Vimeo: 20, Deviantart: 60, RSS: 10 mostly', 'social-board-admin' )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'words',
                'type' => 'number',
                'title' => __( 'Words Limit', 'social-board-admin' ),
                'default' => 40,
                'attributes' => array(
                    'max'   => 500,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Limiting the description words count to display for each item on the Social Stream - Leave empty for no limit.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'commentwords',
                'type' => 'number',
                'title' => __( 'Comment Words Limit', 'social-board-admin' ),
                'default' => 20,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Limiting the comment words count to display for each item - Leave empty for no limit.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'titles',
                'type' => 'number',
                'title' => __( 'Title Limit', 'social-board-admin' ),
                'default' => 15,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Limit of the title words count to display for each item on the Social Stream - Leave empty for no limit.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'dateformat',
                'title' => __( 'Date Format', 'social-board-admin' ),
                'description' => __( 'This will defines, how to display the date/time on items.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'friendly',
                'label' => array(
                    'friendly' => 'Friendly',
                    'date' => 'Date only',
                    'datetime' => 'Date + time'
                )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'userinfo',
                'title' => __( 'User Info Position & Detail', 'social-board-admin' ),
                'description' => __( 'This will define, how to display the user info for each item on the Social Stream.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'top',
                'label' => array(
                    'top' => 'Name/Title/Thumbnail at top',
                    'bottom' => 'Name/Title at bottom'
                )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'lightboxtype',
                'title' => __( 'Lightbox Content', 'social-board-admin' ),
                'description' => __( 'This will define, how to display the Social Stream item information in lightbox window.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'media',
                'label' => array(
                    'media' => 'Single media only',
                    'slideshow' => 'Slideshow detailed'
                )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'slicepoint',
                'type' => 'number',
                'title' => __( 'Expand text slice point', 'social-board-admin' ),
                'default' => 300,
                'attributes' => array(
                    'min'   => 0,
                    'step'  => 10
                ),
                'description' => __( 'Limiting the description characters count to see the read more link - Leave empty for no limit.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'setting',
                'field_id' => 'layout_image',
                'title' => __( 'Item Image Style', 'social-board-admin' ),
                'description' => __( 'This will define, how to display the image for each item on the Social Stream.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'imgexpand',
                'label' => array(
                    'imgexpand' => 'Expanded image at top',
                    'imgnormal' => 'Normal image at middle'
                )
            ),
            array (
                'field_id' => 'readmore',
                'type' => 'checkbox',
                'title' => __( 'Read More', 'social-board-admin' ),
                'label' => __( 'Link long blocks of text', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, the (&#8230;) character at the bottom of each feed item will be linked to the rest of the content.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'order',
                'type' => 'select',
                'title' => __( 'Ordering', 'social-board-admin' ),
                'label' => array(
                    'date' => __( 'Date - DESC', 'social-board-admin' ),
                    'date_asc' => __( 'Date - ASC', 'social-board-admin' ),
                    'random' => __( 'Random', 'social-board-admin' ),
                    'default' => __( 'Default', 'social-board-admin' )
                ),
                'default' => 'date',
                'attributes'    => array(
                    'select' => array(
                        'style' => "width: 150px;",
                    ),
                ),
                'description' => __( 'Select whether to order the results depending on date of each item, randomly or by API default.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'loadmore',
                'title' => __( 'Load More', 'social-board-admin' ),
                'label' => __( 'Load more social items (Next page)', 'social-board-admin' ),
                'description' => __( 'If "Load more button" is checked, a load more bar will appear at the bottom of the social stream (only Masonry, Grid and Timeline layouts) and loads more social items if clicked.<br>If "Infinite scroll" is checked, the new social items appear each time you scroll to the end of page.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'media',
                'label' => array(
                    '0' => 'Disabled',
                    '1' => 'Load more button',
                    '2' => 'Infinite scroll'
                )
            ),
            array(
                'field_id' => 'links',
                'type' => 'checkbox',
                'title' => __( 'Links Target', 'social-board-admin' ),
                'label' => __( 'Open links in new window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all links will open in a new window else they will be open in the parent window.', 'social-board-admin' )
            ),
			array(
				'field_id' => 'full_item_link',
				'type' => 'checkbox',
				'title' => __( 'Link Full Item', 'social-board-admin' ),
				'label' => __( 'Link whole item to original', 'social-board-admin' ),
				'default' => false,
				'description' => __( 'If checked, the whole item will be linked to the original post.', 'social-board-admin' )
			),
            array(
                'field_id' => 'nofollow',
                'type' => 'checkbox',
                'title' => __( 'Nofollow Links', 'social-board-admin' ),
                'label' => __( 'Add nofollow attribute on links', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all links will have the status of nofollow.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'https',
                'type' => 'checkbox',
                'title' => __( 'Use HTTPS', 'social-board-admin' ),
                'label' => __( 'Load images over https', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all links and images will be getting over https.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'lazyload',
                'type' => 'checkbox',
                'title' => __( 'Images Lazy Loading', 'social-board-admin' ),
                'label' => __( 'Enable lazy loading for images', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, images will load as visitors scroll down the screen instead of loading all images at once.', 'social-board-admin' )
            ),
            array(
                'field_id'      => 'display_ads',
                'title'         => __( 'Displaying Ads', 'social-board-admin' ),
                'type'          => 'checkbox',
                'label'         => array(
                    'wall' => __( 'Masonry', 'social-board-admin' ) . ' (' . __( 'Display ads on masonry wall', 'social-board-admin' ) . ')',
                    'grid' => __( 'Grid', 'social-board-admin' ) . ' (' . __( 'Display ads on grid', 'social-board-admin' ) . ')',
                    'timeline' => __( 'Timeline', 'social-board-admin' ) . ' (' . __( 'Display ads on timeline', 'social-board-admin' ) . ')',
                    'feed' => __( 'Rotating Feed', 'social-board-admin' ) . ' (' . __( 'Display ads in rotating feed', 'social-board-admin' ) . ')',
                    'carousel' => __( 'Carousel', 'social-board-admin' ) . ' (' . __( 'Display ads in slides', 'social-board-admin' ) . ')'
                ),
                'default' => array(
                    'wall' => true,
                    'grid' => true,
                    'timeline' => false,
                    'feed' => false,
                    'carousel' => false,
                ),
                'description'   => __( 'If any of these items is checked, the ads (from Manage Ads) will be displayed on it.', 'social-board-admin' ),
                'after_label'   => '<br />',
            ),
            array(
                'field_id' => 'filters',
                'type' => 'checkbox',
                'title' => __( 'Filter Networks', 'social-board-admin' ),
                'label' => __( 'Display filter networks icons', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, a navigation bar of all active network icons will appear at the bottom of the rotating feed or above the Masonry wall. These icons will allow the user to filter the Social Stream items.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'filter_ads',
                'type' => 'checkbox',
				'title' => __( 'Filter Ads', 'social-board-admin' ),
                'label' => __( 'Filter ads with other items', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, the ad items will be also filtered along with the social items on your stream.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'display_all',
                'title' => __( 'Display Show All', 'social-board-admin' ),
                'description' => __( 'Show All button will appear at the first or end of the social network filtering navigation bar.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => '',
                'label' => array(
                    '' => 'At the first',
                    '1' => 'At the end',
                    'disabled' => 'Disabled'
                )
            ),
            array(
                'field_id' => 'default_filter',
                'type' => 'select',
                'title' => __( 'Filtered by Default', 'social-board-admin' ),
                'label' => array(
                    '' => __( 'Show All', 'social-board-admin' ),
                    'facebook' => __( 'Facebook', 'social-board-admin' ),
                    'twitter' => __( 'Twitter', 'social-board-admin' ),
                    'tumblr' => __( 'Tumblr', 'social-board-admin' ),
                    'delicious' => __( 'Delicious', 'social-board-admin' ),
                    'pinterest' => __( 'Pinterest', 'social-board-admin' ),
                    'flickr' => __( 'Flickr', 'social-board-admin' ),
                    'instagram' => __( 'Instagram', 'social-board-admin' ),
                    'youtube' => __( 'YouTube', 'social-board-admin' ),
                    'vimeo' => __( 'Vimeo', 'social-board-admin' ),
                    'deviantart' => __( 'Deviantart', 'social-board-admin' ),
                    'rss' => __( 'RSS', 'social-board-admin' ),
                    'soundcloud' => __( 'SoundCloud', 'social-board-admin' ),
                    'vk' => __( 'VK', 'social-board-admin' ),
					'wordpress' => __( 'WordPress', 'social-board-admin' )
                ),
                'default' => '',
                'attributes'    => array(
                    'select' => array(
                        'style' => "width: 150px;",
                    ),
                ),
                'description' => __( 'Which filtering button to be selected by default.', 'social-board-admin' )
            ),
            array(
                'field_id'      => 'filters_order',
                'type'          => 'inline_mixed', // Multiple Sortable Checkboxes
                'title'         => __( 'Filter Networks Ordering/Visibility', 'social-board-admin' ),
                'sortable'      => true,
                'content'       => $this->___getRowCheckboxes( 0, array( 'facebook' => 1 ) ), // checked by default
                array(
                    'content'   => $this->___getRowCheckboxes( 1, array( 'twitter' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 2, array( 'tumblr' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 3, array( 'delicious' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 4, array( 'pinterest' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 5, array( 'flickr' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 6, array( 'instagram' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 7, array( 'youtube' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 8, array( 'vimeo' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 9, array( 'deviantart' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 10, array( 'rss' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 11, array( 'soundcloud' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 12, array( 'vk' => 1 ) )
                ),
                array(
                    'content'   => $this->___getRowCheckboxes( 13, array( 'vine' => 1 ) )
                ),
				array(
					'content'   => $this->___getRowCheckboxes( 14, array( 'wordpress' => 1 ) )
				),
				array(
					'content'   => $this->___getRowCheckboxes( 15, array( 'tiktok' => 1 ) )
				),
                'description' => __( 'Order of the filtering navigation bar that appear at the bottom of the rotating feed or above the Masonry wall. <strong>Do not forget to save the changes.</strong>', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                ),
			),
            array(
                'field_id' => 'cache',
                'type' => 'number',
                'title' => __( 'Cache Time', 'social-board-admin' ),
                'default' => 720,
                'attributes' => array(
                    'min'   => 60,
                    'step'  => 60
                ),
                'description' => __( 'The time delay for caching of Social Streams (in minutes) - reduces up download time. Make sure the `cache` folder inside the plugin folder is writable by the server (depending on your web hosting server, permissions set to 755, 775, or 777).
                <p style="color:red"><strong style="text-transform: uppercase;">Attention:</strong> Setting cache time to low values may results getting banned on social APIs due to access rate limiting.</p>
                <div style="padding-top: 10px; display: block;"><a class="button button-small sb-clearcache" type="button" data-nonce="'.wp_create_nonce( 'clearcache' ).'">Clear Cache</a> &nbsp; <label id="sb-clearcache-msg"></label></div>',
                'social-board-admin' )
                // <br><strong>Twitter:</strong> You are limited to 2 requests / day per license key.
            ),
            array(
                'field_id' => 'crawl',
                'type' => 'number',
                'title' => __( 'Crawl Per Request', 'social-board-admin' ),
                'default' => 10,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 1,
                    'step'  => 1
                ),
                'description' => __( 'Number of feed crawls per each request. <code>0</code> Zero value means to crawl all at once. (depending on your web hosting server resources, some servers can not read a lot of feeds at the same time).', 'social-board-admin' )
            ),
            array(
                'field_id' => 'timeout',
                'type' => 'number',
                'title' => __( 'API Connection Timeout', 'social-board-admin' ),
                'default' => 15,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Social API request connection timeout (in seconds). (depending on your web hosting server resources, some servers can not wait to process very long time).', 'social-board-admin' )
            ),
            array (
                'field_id' => 'debuglog',
                'type' => 'checkbox',
                'title' => __( 'Debug Log', 'social-board-admin' ),
                'default' => false,
                'label' => __( 'Enable/disable debug log', 'social-board-admin' ),
                'description' => __( 'If checked, all plugin errors will be logged in a file named "sb.log" in plugin folder. The contents of the "sb.log" file will be also shown in <strong>Debug tab</strong>. Make sure the `sb.log` file inside the plugin folder is existed and writable by the server (depending on your web hosting server, permissions set to 644, 655, or 666).<div style="padding-top: 10px; display: block;"><a class="button button-small sb-clearcache" type="button" data-log="log" data-nonce="'.wp_create_nonce( 'clearcache' ).'">Clear Log</a> &nbsp; <label id="sb-clearlog-msg"></label></div>', 'social-board-admin' )
            ),
            // Proxy setting
            array(
                'section_id' => 'proxysetting',
                'field_id' => 'proxy',
                'type' => 'text',
                'title' => __( 'Proxy Address', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'field_id' => 'proxy_port',
                'type' => 'text',
                'title' => __( 'Proxy Port', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'field_id' => 'proxy_userpass',
                'type' => 'text',
                'title' => __( 'Proxy User & Pass', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;",
                    'placeholder' => 'user:pass'
                ),
                'description' => __( 'Format should be <code>user:pass</code> - Not required.', 'social-board-admin' )
            ),
            // Masonry Wall setting
            array(
                'section_id' => 'wallsetting',
                'field_id' => 'transition',
                'type' => 'number',
                'title' => __( 'Transition Duration', 'social-board-admin' ),
                'default' => 400,
                'attributes' => array(
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Duration of the transition when items change position or appearance -  in milliseconds - 0 means no transitions.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'stagger',
                'title' => __( 'Stagger', 'social-board-admin' ),
                'type' => 'number',
                'default' => '',
                'attributes' => array(
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Staggers item transitions, so items transition incrementally after one another - in milliseconds - Leave empty to disable it.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'filter_search',
                'type' => 'checkbox',
                'title' => __( 'Search Filtering', 'social-board-admin' ),
                'label' => __( 'Filter Masonry wall by search', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, a search box will appear above the Masonry wall allowing the user to filter the Social Stream items using a search phrase.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'originLeft',
                'type' => 'select',
                'title' => __( 'Filter Direction', 'social-board-admin' ),
                'label' => array(
                    'true' => __( 'Left To Right', 'social-board-admin' ),
                    'false' => __( 'Right To Left', 'social-board-admin' ),
                ),
                'default' => 'true',
                'attributes' => array(
                    'select' => array(
                        'style' => "width: 150px;",
                    ),
                ),
                'description' => __( 'Let layout to start render from left to right or, right to left.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'wall_width',
                'title' => __( 'Masonry Block Width', 'social-board-admin' ),
                'type' => 'number',
                'default' => '',
                'attributes' => array(
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Width of Masonry block (px) - Leave empty for full width.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'wall_height',
                'title' => __( 'Masonry Block Height', 'social-board-admin' ),
                'type' => 'number',
                'default' => '',
                'attributes' => array(
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Height of Masonry block (px) - Leave empty for infinite height.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'fixWidth',
                'title' => __( 'Item Width Definition', 'social-board-admin' ),
                'description' => __( 'If "Fixed Width" is enabled, the "Item Width" value will be applied to each Masonry item - <strong>Responsive Breakpoints will be ignored</strong>.<br>If "Based on browser width" is enabled, the "Responsive Breakpoints" sets will be applied to Masonry wall items based on <strong>browser width</strong>.<br>If "Based on container width" is enabled, the "Responsive Breakpoints" sets will be applied to Masonry wall items based on <strong>wall container block width</strong>.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'block',
                'label' => array(
                    'true' => 'Fixed Width',
                    'false' => 'Based on browser width',
                    'block' => 'Based on container width'
                )
            ),
            array(
                'field_id' => 'breakpoints',
                'title' => __( 'Responsive Breakpoints', 'social-board-admin' ),
                'type' => 'number',
                'default' => __( '5', 'social-board-admin' ),
                'label' => __( 'More than 1200px', 'social-board-admin' ) . ': ',
                'attributes' => array(
                    'size'  => 20,
                    'min'   => 1,
                    'step'  => 1
                ),
                'capability' => 'manage_options',
                'delimiter' => '<br />',
                array(
                    'default' => '4',
                    'label' => __( '960px to 1200px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => '4',
                    'label' => __( '768px to 960px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '3', 'social-board-admin' ),
                    'label' => __( '600px to 768px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '2', 'social-board-admin' ),
                    'label' => __( '480px to 600px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '2', 'social-board-admin' ),
                    'label' => __( '320px to 480px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '1', 'social-board-admin' ),
                    'label' => __( 'Less than 320px', 'social-board-admin' ) . ': '
                ),
                'description' => __( 'Defines the number of items (columns) shwoing on each row for different viewport/container sizes - <strong>Requires "Fixed Width" to be disabled</strong>.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'itemwidth',
                'title' => __( 'Item Width', 'social-board-admin' ),
                'type' => 'number',
                'default' => 250,
                'attributes' => array(
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Width of Masonry item (px) - Do not leave empty!', 'social-board-admin' )
			),
            array(
                'field_id' => 'showmore',
                'type' => 'checkbox',
                'title' => __( 'Screen Items Limit', 'social-board-admin' ),
                'label' => __( 'Limit items result on small screens', 'social-board-admin' ),
                'default' => false,
                'description' => __( 'If checked, the number of items displaying on the masonry will be automatically limited based on the viewport size. Show More button will appear at the bottom of the masonry and display more social items if clicked.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'gutterX',
                'type' => 'number',
                'title' => __( 'Gutter X', 'social-board-admin' ),
                'default' => 10,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'The horizontal space between item elements - in pixels. This may changes automatically when "Fixed Width" is disabled.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'gutterY',
                'type' => 'number',
                'title' => __( 'Gutter Y', 'social-board-admin' ),
                'default' => 10,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'The vertical space between row elements - in pixels. This may changes automatically when "Fixed Width" is disabled.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'feedsetting',
                'field_id' => 'rotate_speed',
                'type' => 'number',
                'title' => __( 'Animation Speed', 'social-board-admin' ),
                'default' => 100,
                'description' => __( 'Defines the animation speed (in ms) of the rows moving up or down.', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'duration',
                'type' => 'number',
                'title' => __( 'Animation Duration', 'social-board-admin' ),
                'default' => 4000,
                'description' => __( 'Defines the times (in ms) before the rows automatically move.', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'direction',
                'type' => 'select',
                'title' => __( 'Animation Direction', 'social-board-admin' ),
                'label' => array( 
                    'up' => __( 'Up', 'social-board-admin' ),
                    'down' => __( 'Down', 'social-board-admin' ),
                ),
                'default' => 'up',
                'attributes'    => array(
                    'select' => array(
                        'style' => "width: 150px;",
                    ),
                ),
                'description' => __( 'Sets the direction of rotating feed movement to either "up" or "down".', 'social-board-admin' )
            ),
            array(
                'field_id' => 'controls',
                'type' => 'checkbox',
                'title' => __( 'Controls', 'social-board-admin' ),
                'label' => __( 'Stop/start rotating', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, a feed control bar will appear at the bottom of the rotating feed allowing user to stop/start the rotating feed or go to next/previous item.', 'social-board-admin' )
            ),
            array (
                'field_id' => 'autostart',
                'type' => 'checkbox',
                'title' => __( 'Auto Start', 'social-board-admin' ),
                'default' => true,
                'label' => __( 'Enable/disable auto start on load', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'pauseonhover',
                'type' => 'checkbox',
                'title' => __( 'Pause On Mouse Hover', 'social-board-admin' ),
                'default' => true,
                'label' => __( 'Enable/disable pause when mouse hovers the rotating feed element', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'width',
                'title' => __( 'Block Width', 'social-board-admin' ),
                'type' => 'number',
                'default' => 280,
                'description' => __( 'Width of feed block (px) - Leave empty for full width.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'height',
                'title' => __( 'Block Height', 'social-board-admin' ),
                'type' => 'number',
                'default' => 400,
                'description' => __( 'Height of feed block (px) - Do not leave empty.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'carouselsetting',
                'field_id' => 'cs_speed',
                'type' => 'number',
                'title' => __( 'Animation Speed', 'social-board-admin' ),
                'default' => 400,
                'description' => __( 'Defines the animation speed time (in ms) of slides moving left or right.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'cs_rows',
                'title' => __( 'Number of Rows', 'social-board-admin' ),
                'type' => 'number',
                'default' => 2,
                'attributes' => array(
                    'max'   => 10,
                    'min'   => 1,
                    'step'  => 1
                ),
                'description' => __( 'Number of rows in carousel - <strong>Setting this to more than 1, displays the carousel as a grid.</strong>.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'cs_item',
                'title' => __( 'Number of Slides', 'social-board-admin' ),
                'type' => 'number',
                'default' => __( '4', 'social-board-admin' ),
                'label' => __( 'More than 960px', 'social-board-admin' ) . ': ',
                'attributes' => array(
                    'size'  => 20,
                    'min'   => 1,
                    'step'  => 1
                ),
                'capability' => 'manage_options',
                'delimiter' => '<br />',
                array(
                    'default' => '3',
                    'label' => __( '768px to 960px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '2', 'social-board-admin' ),
                    'label' => __( '600px to 768px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '2', 'social-board-admin' ),
                    'label' => __( '480px to 600px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '1', 'social-board-admin' ),
                    'label' => __( 'Less than 480px', 'social-board-admin' ) . ': '
                ),
                'description' => __( 'Defines the number of slides to show in each row in different viewport sizes.', 'social-board-admin' )
            ),
			array(
				'field_id' => 'cs_slide',
				'title' => __( 'Slides to scroll', 'social-board-admin' ),
				'description' => __( '', 'social-board-admin' ),
				'type' => 'radio',
				'default' => 'default',
				'label' => array(
					'default' => 'Scroll displayed slides',
					'one' => 'Scroll one by one'
				)
			),
            array(
                'field_id'          => 'cs_height',
                'title'             => __( 'Slide Height', 'social-board-admin' ),
                'type'              => 'number',
                'capability'        => 'manage_options',
                'label'             => array(
                    'thumb'    => __( 'Thumbnail height', 'social-board-admin' ),
                    'text'     => __( 'Text height', 'social-board-admin' ),
                    'meta'     => __( 'Metadata height', 'social-board-admin' )
                ),
                'after_label'       => array(
                    'thumb'    => '<br />',
                    'text'      => '<br />',
                    'meta'      => '<br />'
                ),
                'default' => array(
                    'thumb'    => '150',
                    'text'     => '75',
                    'meta'     => '50'
                ),
                'description' => __( 'Height of slide item (px) - Do not leave empty!', 'social-board-admin' )
            ),
            array(
                'field_id' => 'cs_controls',
                'type' => 'checkbox',
                'title' => __( 'Controls', 'social-board-admin' ),
                'label' => __( 'Prev/next buttons', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, prev/next buttons will be displayed.', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'cs_rtl',
                'type' => 'select',
                'title' => __( 'Animation Direction', 'social-board-admin' ),
                'label' => array( 
                    'true' => __( 'Right to left', 'social-board-admin' ),
                    'false' => __( 'Left to right', 'social-board-admin' ),
                ),
                'default' => 'false',
                'attributes' => array(
                    'select' => array(
                        'style' => "width: 150px;",
                    ),
                ),
                'description' => __( 'Sets the direction of carousel slides movement to either right or left.', 'social-board-admin' )
            ),
            array (
                'field_id' => 'cs_auto',
                'type' => 'checkbox',
                'title' => __( 'Autoplay', 'social-board-admin' ),
                'default' => false,
                'label' => __( 'If checked, the slider will automatically start to play.', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'cs_autospeed',
                'type' => 'number',
                'title' => __( 'Autoplay Speed', 'social-board-admin' ),
                'default' => 2000,
                'description' => __( 'The time (in ms) between each automatic moving.', 'social-board-admin' )
            ),
            array (
                'field_id' => 'cs_pause',
                'type' => 'checkbox',
                'title' => __( 'Pause on Hover', 'social-board-admin' ),
                'default' => true,
                'label' => __( 'If checked, the Slider will stop playing on hover.', 'social-board-admin' ),
            ),
            array (
                'field_id' => 'cs_loop',
                'type' => 'checkbox',
                'title' => __( 'Loop Sliding', 'social-board-admin' ),
                'default' => true,
                'label' => __( 'Infinite loop sliding', 'social-board-admin' ),
                'description' => __( 'This will enable the ability to loop back to the first slide when reaches to the last slide.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'cs_pager',
                'type' => 'checkbox',
                'title' => __( 'Enable Pager', 'social-board-admin' ),
                'default' => true,
                'label' => __( 'Enable/disable pager/dot indicators.', 'social-board-admin' )
            ),
            // Grid setting
            array(
                'section_id' => 'gridsetting',
                'field_id' => 'grid_height',
                'title' => __( 'Grid Height', 'social-board-admin' ),
                'type' => 'number',
                'default' => 340,
                'attributes' => array(
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'Height of grid block (px) - Required', 'social-board-admin' )
			),
            array(
				'section_id' => 'gridsetting',
                'field_id' => 'filter_search',
                'type' => 'checkbox',
                'title' => __( 'Search Filtering', 'social-board-admin' ),
                'label' => __( 'Filter Grid by search', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, a search box will appear above the Grid allowing the user to filter the Social Stream items using a search phrase.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'fixWidth',
                'title' => __( 'Item Width Definition', 'social-board-admin' ),
                'description' => __( 'If "Based on browser width" is enabled, the "Responsive Breakpoints" sets will be applied to Masonry wall items based on <strong>browser width</strong>.<br>If "Based on container width" is enabled, the "Responsive Breakpoints" sets will be applied to Masonry wall items based on <strong>wall container block width</strong>.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'block',
                'label' => array(
                    'false' => 'Based on browser width',
                    'block' => 'Based on container width'
                )
            ),
            array(
                'field_id' => 'columns_style',
                'type' => 'select',
                'title' => __( 'Columns Style', 'social-board-admin' ),
                'label' => array(
                    '1' => __( 'Classic solo grid', 'social-board-admin' ),
                    '1-2' => __( 'One / twofold grid', 'social-board-admin' ),
                ),
                'default' => '1-2',
                'attributes'    => array(
                    'select' => array(
                        'style' => "width: 150px;"
                    )
                )
            ),
            array(
                'field_id' => 'breakpoints',
                'title' => __( 'Responsive Breakpoints', 'social-board-admin' ),
                'type' => 'number',
                'default' => __( '5', 'social-board-admin' ),
                'label' => __( 'More than 1200px', 'social-board-admin' ) . ': ',
                'attributes' => array(
                    'size' => 20,
                    'min'   => 1,
                    'step'  => 1
                ),
                'capability' => 'manage_options',
                'delimiter' => '<br />',
                array(
                    'default' => '4',
                    'label' => __( '960px to 1200px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => '4',
                    'label' => __( '768px to 960px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '3', 'social-board-admin' ),
                    'label' => __( '600px to 768px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '2', 'social-board-admin' ),
                    'label' => __( '480px to 600px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '2', 'social-board-admin' ),
                    'label' => __( '320px to 480px', 'social-board-admin' ) . ': '
                ),
                array(
                    'default' => __( '1', 'social-board-admin' ),
                    'label' => __( 'Less than 320px', 'social-board-admin' ) . ': '
                ),
                'description' => __( 'Defines the number of items (columns) shwoing on each row for different viewport/container sizes - <strong>The result in other columns styles other than solo, may be different!</strong>.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'gutterX',
                'type' => 'number',
                'title' => __( 'Gutter X', 'social-board-admin' ),
                'default' => 0,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'The horizontal space between item elements - in pixels.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'gutterY',
                'type' => 'number',
                'title' => __( 'Gutter Y', 'social-board-admin' ),
                'default' => 0,
                'attributes' => array(
                    'max'   => 100,
                    'min'   => 0,
                    'step'  => 1
                ),
                'description' => __( 'The vertical space between row elements - in pixels.', 'social-board-admin' )
            ),
            // Timeline setting
            array(
                'section_id' => 'timelinesetting',
                'field_id' => 'onecolumn',
                'title' => __( 'Display Layout', 'social-board-admin' ),
                'description' => __( 'To display timeline in one column or based on browser screen width.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'false',
                'label' => array(
                    'true' => 'One Column',
                    'false' => 'Based on browser screen width'
                )
            )
		);

        // Getting all options
        $setoptions = SB_AdminPageFramework::getOption( 'AXS_Settings_Page' ) ? SB_AdminPageFramework::getOption( 'AXS_Settings_Page' ) : SB_AdminPageFramework::getOption( 'SB_Settings_Page' );

        // Update Instagram accounts
        if ( isset($_REQUEST['api']) && $_REQUEST['api'] == 'instagram' ) {
			if ( isset($setoptions['section_instagram']['instagram_accounts']) )
				$instagram_accounts = $setoptions['section_instagram']['instagram_accounts'];

            // r3.6.9 < compatibility fix
            if ( ! empty($instagram_accounts) && ! is_numeric( key($instagram_accounts) ) ) {
                foreach ($instagram_accounts as $fbakey => $fba) {
                    $instagram_accounts[$fba['id']] = $instagram_accounts[$fbakey];
                    unset($instagram_accounts[$fbakey]);
                }
            }
			// END - r3.6.9 < compatibility fix
			
            if ( ! empty( $_REQUEST['access_token'] ) ) {
                $cache = new AXS_SimpleCache;
                $cache->setoption = $setoptions;

				$access_token = $_REQUEST['access_token'];
				$expires_in = isset($_REQUEST['expires_in']) ? $_REQUEST['expires_in'] : '5184000';
                $feed_url = 'https://graph.instagram.com/me/?fields=account_type,id,media_count,username&access_token=' . $access_token;
                if ( $userDataString = $cache->do_curl($feed_url, true) ) {
					$userData = json_decode($userDataString);
                    if ( ! empty($userData->id) ) {
                        $userAccounts = array(
                            'id' => $userData->id,
                            'username' => $userData->username ?? '',
							'access_token' => $access_token,
							'expires_in' => $expires_in,
							'updated_at' => time()
                        );
                        $newAccount = array($userData->id => $userAccounts);

                        // Append if account exists
                        if ( ! empty($instagram_accounts) && is_array($instagram_accounts) )
                            $instagramAccounts = $newAccount + $instagram_accounts;
                        else
                            $instagramAccounts = $newAccount;

						// Update app info if existing
						if ( ! empty( $_REQUEST['api_key'] ) )
							$setoptions['section_instagram']['instagram_api_key'] = sanitize_text_field( $_REQUEST['api_key'] );
						if ( ! empty( $_REQUEST['api_secret'] ) )
							$setoptions['section_instagram']['instagram_api_secret'] = sanitize_text_field( $_REQUEST['api_secret'] );

                        // Update accounts
                        $setoptions['section_instagram']['instagram_accounts'] = $instagramAccounts;
                        update_option("AXS_Settings_Page", $setoptions);
                    } else {
                        if(isset($userData->meta->error_message) && ! empty($userData->meta->error_message)){
							axs_log( 'Instagram authentication error: ' . $userData->meta->error_message );
						}
                        else{
							axs_log( 'Instagram authentication error.' );
						}
                    }
                }
            } elseif ( ! empty( $_REQUEST['remove_token'] ) ) {
                $remove_token = $_REQUEST['remove_token'];
                $setoptions['section_instagram']['instagram_accounts'] = $instagram_accounts;
                unset($setoptions['section_instagram']['instagram_accounts'][$remove_token]);
                update_option("AXS_Settings_Page", $setoptions);
            }
		}
        // Update Instagram business accounts
        elseif ( isset($_REQUEST['api']) && $_REQUEST['api'] == 'instagram_facebook' ) {
			if ( isset($setoptions['section_instagram']['instagram_bussiness_accounts']) )
				$instagram_accounts = $setoptions['section_instagram']['instagram_bussiness_accounts'];

            if ( ! empty( $_REQUEST['access_token'] ) ) {
                $cache = new AXS_SimpleCache;
                $cache->setoption = $setoptions;

                // Get Facebook user info
                $access_token = $_REQUEST['access_token'];
                $feed_url = 'https://graph.facebook.com/'.self::FACEBOOK_API_VERSION.'/me?fields=id,name,picture&access_token=' . $access_token;
                if ( $userDataString = $cache->do_curl($feed_url, true) ) {
                    $userData = json_decode($userDataString);
                    if ( ! empty($userData->id) ) {
                        $userAccount = array(
                            'id' => $userData->id,
                            'name' => $userData->name ?? '',
                            'email' => $userData->email ?? '',
                            'picture' => $userData->picture->data->url ?? '',
                            'access_token' => $access_token
                        );
                        $newAccount = array($userData->id => $userAccount);

                        // Get Facebook user's managing pages connected to Instagram Business accounts
                        $feed_url = 'https://graph.facebook.com/'.self::FACEBOOK_API_VERSION.'/' . $userData->id . '/accounts?limit=100&fields=access_token,instagram_business_account{id,username,name,profile_picture_url,media_count}&access_token=' . $access_token;
                        if ( $pagesDataString = $cache->do_curl($feed_url, true) ) {
                            $pagesData = json_decode($pagesDataString);
                            if ( ! empty($pagesData->data) ) {
                                foreach ($pagesData->data as $pageData) {
									// Check to see if there is an Instagram page connected
									if ( ! empty($pageData->instagram_business_account) ) {
										$pageAccount = array(
											'id' => $pageData->instagram_business_account->id,
											'name' => $pageData->instagram_business_account->name ?? '',
											'username' => $pageData->instagram_business_account->username ?? '',
											'picture' => $pageData->instagram_business_account->profile_picture_url ?? '',
											'access_token' => $pageData->access_token
										);
										$newAccount[$userData->id]['accounts'][$pageData->instagram_business_account->id] = $pageAccount;
									}
                                }
                            } else {
                            	if (isset($pagesData->error->message) && ! empty($pagesData->error->message)) {
									axs_log( 'Facebook authentication error: ' . $pagesData->error->message );
								}
                            }
                        }
                        
                        // Append if account exists
                        if ( ! empty($instagram_accounts) && is_array($instagram_accounts) ) {
                            $instagramAccounts = $newAccount + $instagram_accounts;
                        } else {
                            $instagramAccounts = $newAccount;
						}
						
						// Update app info if existing
						if ( ! empty( $_REQUEST['api_key'] ) )
							$setoptions['section_instagram']['instagram_facebook_api_key'] = sanitize_text_field( $_REQUEST['api_key'] );
						if ( ! empty( $_REQUEST['api_secret'] ) )
							$setoptions['section_instagram']['instagram_facebook_api_secret'] = sanitize_text_field( $_REQUEST['api_secret'] );

                        // Update accounts
                        $setoptions['section_instagram']['instagram_bussiness_accounts'] = $instagramAccounts;
                        update_option("AXS_Settings_Page", $setoptions);
                    } else {
                    	if (isset($userData->error->message) && ! empty($userData->error->message)){
							axs_log( 'Facebook authentication error: ' . $userData->error->message );
						}
                    }
                } else {
                    axs_log( 'Could not connect to Facebook.' );
                }
            } elseif ( ! empty( $_REQUEST['remove_token'] ) ) {
                $remove_token = $_REQUEST['remove_token'];
                $setoptions['section_instagram']['instagram_bussiness_accounts'] = $instagram_accounts;
                unset($setoptions['section_instagram']['instagram_bussiness_accounts'][$remove_token]);
                update_option("AXS_Settings_Page", $setoptions);
            }
        }
        // Update Facebook accounts
        elseif ( isset($_REQUEST['api']) && $_REQUEST['api'] == 'facebook' ) {
			if ( ! empty($setoptions['section_facebook']['facebook_accounts']) ) {
				$facebook_accounts = $setoptions['section_facebook']['facebook_accounts'];
				// r3.6.9 < compatibility fix
				if ( ! is_numeric( key($facebook_accounts) ) ) {
					foreach ($facebook_accounts as $fbakey => $fba) {
						$facebook_accounts[$fba['id']] = $facebook_accounts[$fbakey];
						unset($facebook_accounts[$fbakey]);
						foreach ($fba['pages'] as $fbpkey => $fbp) {
							$facebook_accounts[$fba['id']]['pages'][$fbp['id']] = $facebook_accounts[$fba['id']]['pages'][$fbpkey];
							unset($facebook_accounts[$fba['id']]['pages'][$fbpkey]);
						}
					}
				}
			}
            // END - r3.6.9 < compatibility fix
            if ( ! empty( $_REQUEST['access_token'] ) ) {
                $cache = new AXS_SimpleCache;
                $cache->setoption = $setoptions;

                // Get Facebook user info
                $access_token = $_REQUEST['access_token'];
                $feed_url = 'https://graph.facebook.com/'.self::FACEBOOK_API_VERSION.'/me?fields=id,name,picture&access_token=' . $access_token;
                if ( $userDataString = $cache->do_curl($feed_url, true) ) {
                    $userData = json_decode($userDataString);
                    if ( ! empty($userData->id) ) {
                        $userAccount = array(
                            'id' => $userData->id,
                            'name' => $userData->name ?? '',
                            'email' => $userData->email ?? '',
                            'picture' => $userData->picture->data->url ?? '',
                            'access_token' => $access_token
                        );
                        $newAccount = array($userData->id => $userAccount);

                        // Get Facebook user's managing pages
                        $feed_url = 'https://graph.facebook.com/'.self::FACEBOOK_API_VERSION.'/' . $userData->id . '/accounts?limit=100&fields=id,name,username,picture,access_token&access_token=' . $access_token;
                        if ( $pagesDataString = $cache->do_curl($feed_url, true) ) {
                            $pagesData = json_decode($pagesDataString);
                            if ( ! empty($pagesData->data) ) {
                                foreach ($pagesData->data as $pageData) {
                                    $pageAccount = array(
                                        'id' => $pageData->id,
                                        'name' => $pageData->name ?? '',
                                        'username' => $pageData->username ?? '',
                                        'picture' => $pageData->picture->data->url ?? '',
                                        'access_token' => $pageData->access_token
                                    );
                                    $newAccount[$userData->id]['pages'][$pageData->id] = $pageAccount;
                                }
                            } else {
                            	if (isset($pagesData->error->message) && ! empty($pagesData->error->message)) {
									axs_log( 'Facebook authentication error: ' . $pagesData->error->message );
								}
                            }
                        }
                        
                        // Get Facebook Groups
						$feed_url = 'https://graph.facebook.com/'.self::FACEBOOK_API_VERSION.'/' . $userData->id . '/groups?limit=100&fields=id,name,username,picture,access_token&access_token=' . $access_token;
						if ( $groupsDataString = $cache->do_curl($feed_url, true) ) {
							$groupsData = json_decode($groupsDataString);
							if ( ! empty($groupsData->data) ) {
								foreach ($groupsData->data as $groupData) {
									$groupAccount = array(
										'id' => $groupData->id,
										'name' => $groupData->name ?? '',
										'username' => $groupData->username ?? '',
										'picture' => $groupData->picture->data->url ?? '',
										'access_token' => $access_token
									);
									$newAccount[$userData->id]['groups'][$groupData->id] = $groupAccount;
								}
							} else {
								if (isset($groupsData->error->message) && ! empty($groupsData->error->message)) {
									axs_log( 'Facebook authentication error: ' . $groupsData->error->message );
								}
							}
						}
                        
                        // Append if account exists
                        if ( isset($facebook_accounts) && ! empty($facebook_accounts) && is_array($facebook_accounts) )
                            $facebookAccounts = $newAccount + $facebook_accounts;
                        else
                            $facebookAccounts = $newAccount;
						
						// Update app info if existing
						if ( ! empty( $_REQUEST['api_key'] ) )
							$setoptions['section_facebook']['facebook_api_key'] = sanitize_text_field( $_REQUEST['api_key'] );
						if ( ! empty( $_REQUEST['api_secret'] ) )
							$setoptions['section_facebook']['facebook_api_secret'] = sanitize_text_field( $_REQUEST['api_secret'] );

                        // Update accounts
                        $setoptions['section_facebook']['facebook_accounts'] = $facebookAccounts;
                        update_option("AXS_Settings_Page", $setoptions);
                    } else {
                    	if (isset($userData->error->message) && ! empty($userData->error->message)) {
							axs_log( 'Facebook authentication error: ' . $userData->error->message );
						}
                    }
                } else {
                    axs_log( 'Could not connect to Facebook.' );
                }
            } elseif ( ! empty( $_REQUEST['remove_token'] ) ) {
                $remove_token = $_REQUEST['remove_token'];
                $setoptions['section_facebook']['facebook_accounts'] = $facebook_accounts ?? array();
                unset($setoptions['section_facebook']['facebook_accounts'][$remove_token]);
                update_option("AXS_Settings_Page", $setoptions);
            }
        }
        // Update twitter API
        if ( isset($_REQUEST['api']) && $_REQUEST['api'] == 'twitter' ) {
			if ( ! empty( $_REQUEST['access_token'] ) ) {

				// Update app info if existing
				if ( ! empty( $_REQUEST['api_key'] ) )
					$setoptions['section_twitter']['twitter_api_key'] = sanitize_text_field( $_REQUEST['api_key'] );
				if ( ! empty( $_REQUEST['api_secret'] ) )
					$setoptions['section_twitter']['twitter_api_secret'] = sanitize_text_field( $_REQUEST['api_secret'] );

				// Update accounts
				$setoptions['section_twitter']['twitter_access_token'] = sanitize_text_field( $_REQUEST['access_token'] );
				$setoptions['section_twitter']['twitter_access_token_secret'] = sanitize_text_field( $_REQUEST['access_token_secret'] );
				update_option("AXS_Settings_Page", $setoptions);
			}
		}
		// Update soundcloud API
		if ( isset($_REQUEST['api']) && $_REQUEST['api'] == 'soundcloud' ) {
			if ( ! empty( $_REQUEST['access_token'] ) && $_REQUEST['access_token'] != $setoptions['section_soundcloud']['soundcloud_access_token'] ) {
				$setoptions['section_soundcloud']['soundcloud_access_token'] = sanitize_text_field( $_REQUEST['access_token'] );
				$setoptions['section_soundcloud']['soundcloud_refresh_token'] = sanitize_text_field( $_REQUEST['refresh_token'] );
				$setoptions['section_soundcloud']['soundcloud_expires_in'] = sanitize_text_field( $_REQUEST['expires_in'] );
				$setoptions['section_soundcloud']['soundcloud_updated_at'] = time();
				update_option("AXS_Settings_Page", $setoptions);
			}
		}

        // Update TikTok accounts
        if ( isset($_REQUEST['api']) && $_REQUEST['api'] == 'tiktok' ) {
			if ( isset($setoptions['section_tiktok']['tiktok_accounts']) ) {
				$tiktok_accounts = $setoptions['section_tiktok']['tiktok_accounts'];
			}
			
            if ( ! empty( $_REQUEST['access_token'] ) ) {
                $cache = new AXS_SimpleCache;
                $cache->setoption = $setoptions;

				$access_token = $_REQUEST['access_token'];
				$expires_in = isset($_REQUEST['expires_in']) ? $_REQUEST['expires_in'] : '86400';
                // Expiration for the access_token in seconds. It is valid for 24 hours after initial issuance.
				
                $refresh_token = $_REQUEST['refresh_token'];
                $refresh_expires_in = $_REQUEST['refresh_expires_in'];
                // Expiration for the refresh_token in seconds. It is valid for 365 days after initial issuance.

				$client_key = (isset($_REQUEST['client_key']) && !empty($_REQUEST['client_key'])) ? $_REQUEST['client_key'] : '';
				$client_secret = (isset($_REQUEST['client_secret']) && !empty($_REQUEST['client_secret'])) ? $_REQUEST['client_secret'] : '';
                
				$feed_url = 'https://open.tiktokapis.com/v2/user/info/?fields=open_id,union_id,display_name,avatar_url,avatar_url_100,avatar_large_url';
				$headers = array('Authorization: Bearer ' . $access_token);
                if ( $userDataString = $cache->do_curl($feed_url, true, $headers) ) {
					$userData = json_decode($userDataString);
                    if ( ! empty($userData->data->user->open_id) ) {
                        $userAccounts = array(
                            'open_id' 		   => $userData->data->user->open_id,
							'union_id'         => $userData->data->user->union_id,
							'avatar_url'       => $userData->data->user->avatar_url,
							'avatar_url_100'   => $userData->data->user->avatar_url_100,
							'avatar_large_url' => $userData->data->user->avatar_large_url,
							'display_name'     => $userData->data->user->display_name,
							'access_token' 	   => $access_token,
							'expires_in'       => $expires_in,
							'refresh_token' 		  => $refresh_token,
							'refresh_expires_in' 	  => $refresh_expires_in,
							'client_key'  			  => $client_key,
							'client_secret' 		  => $client_secret,
                            'updated_at'              => time()
                        );
                        $newAccount = array($userData->data->user->open_id => $userAccounts);

                        // Append if account exists
                        if ( ! empty($tiktok_accounts) && is_array($tiktok_accounts) ) {
                            $tiktokAccounts = $newAccount + $tiktok_accounts;
                        } else {
                            $tiktokAccounts = $newAccount;
						}

						// Update app info if existing
						if ( ! empty( $_REQUEST['api_key'] ) ) {
							$setoptions['section_tiktok']['tiktok_api_key'] = sanitize_text_field( $_REQUEST['api_key'] );
						}
						if ( ! empty( $_REQUEST['api_secret'] ) ) {
							$setoptions['section_tiktok']['tiktok_api_secret'] = sanitize_text_field( $_REQUEST['api_secret'] );
						}

                        // Update accounts
                        $setoptions['section_tiktok']['tiktok_accounts'] = $tiktokAccounts;
                        update_option("AXS_Settings_Page", $setoptions);
                    } else {
                        if (isset($userData->error->message) && ! empty($userData->error->message)) {
							axs_log( 'TikTok authentication error: ' . $userData->error->message );
						} else {
							axs_log( 'TikTok authentication error.' );
						}
                    }
                } else {
					axs_log('Could not connect to Tiktok.');
				}
            } elseif ( ! empty( $_REQUEST['remove_token'] ) ) {
                $remove_token = $_REQUEST['remove_token'];
                $setoptions['section_tiktok']['tiktok_accounts'] = $tiktok_accounts;
                unset($setoptions['section_tiktok']['tiktok_accounts'][$remove_token]);
                update_option("AXS_Settings_Page", $setoptions);
            }
		}

        // Getting Facebook connected accounts
        $facebook_accounts = SB_AdminPageFramework::getOption( 'AXS_Settings_Page', array( 'section_facebook', 'facebook_accounts' ) ) ?? SB_AdminPageFramework::getOption( 'SB_Settings_Page', array( 'section_facebook', 'facebook_accounts' ) );
        
        $this->addSettingFields(
            'section_facebook',
            array(
                'field_id' => 'facebook_app',
                'title' => __( 'How to connect?', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'yes',
                'label' => array(
                    'yes' => 'Use our App',
                    'no' => 'Use your own App',
					'token' => 'Already connected on another website'
                ),
                'description' => __( '', 'social-board-admin' )
            ),
			array(
				'field_id' => 'facebook_save_other_token',
				'type' => 'text',
				'title' => __( 'Facebook Token', 'social-board-admin' ),
				'attributes' => array(
					'style' => "width: 250px;"
				)
			),
            array(
                'field_id' => 'facebook_api_key',
                'type' => 'text',
                'title' => __( 'Facebook App ID', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'field_id' => 'facebook_api_secret',
                'type' => 'text',
                'title' => __( 'Facebook App Secret', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'section_id' => 'section_facebook',
                'field_id' => 'facebook_get_token',
                'type' => 'get_token_html',
                'content' => __( 'Click the button below and log into your Facebook account to obtain your Access Token.<br>
                    <div style="padding-top: 10px; display: block;">
                        <a class="button button-primary" name="sb-facebook-token" id="sb-facebook-token" type="button" href="'.$this->facebook_token_url.'">Connect Facebook Page(s)</a>
                    </div>', 'social-board-admin' ),
                'description' => __( '<label id="sb-facebook-token-msg"></label>', 'social-board-admin' ),
            ),
			array(
                'section_id' => 'section_facebook',
                'field_id' => 'facebook_save_btn_token',
                'type' => 'get_token_html',
                'content' => __( 'Click the button below to connect your Facebook account and pages.
                    <div style="padding-top: 10px; display: block;">
                        <a class="button button-primary" name="sb-facebook-save-token" id="sb-facebook-save-token" type="button" href="'.$this->api_page_url.'&api=facebook&access_token=">Connect Facebook Page(s)</a>
                    </div>', 'social-board-admin' ),
            )
        );

        if ( ! empty($facebook_accounts) ) {
            $faccounts = '';
            foreach ($facebook_accounts as $faccount) {
                $fpages = '';
                if ( ! empty($faccount['pages']) ) {
                    foreach ($faccount['pages'] as $fpage) {
                        $fpages .= '
                        <img src="' . ($fpage['picture'] ?? '') . '" alt="">
                        <p><u>ID:</u> ' . $fpage['id'] . '</p>
                        <p><u>Name:</u> ' . ($fpage['name'] ?? '') . '</p>
                        <p><u>Username:</u> ' . ($fpage['username'] ?? '') . '</p>
                        <p><u>Access token:</u> <input type="text" value="' . ($fpage['access_token'] ?? '') . '" size="50"></p>';
                    }
                }
                
                $fgroups = '';
                if( ! empty($faccount['groups']) ) {
					foreach ($faccount['groups'] as $fgroup) {
						$fgroups .= '
                        <img src="' . ($fgroup['picture'] ?? '') . '" alt="">
                        <p><u>ID:</u> ' . $fgroup['id'] . '</p>
                        <p><u>Name:</u> ' . ($fgroup['name'] ?? '') . '</p>
                        <p><u>Username:</u> ' . ($fgroup['username'] ?? '') . '</p>
                        <p><u>Access token:</u> <input type="text" value="' . ($fgroup['access_token'] ?? '') . '" size="50"></p>';
						
					}
				}
                
                $faccounts .= '
                <div class="accounts-wrapper">
                    <img src="' . ($faccount['picture'] ?? '') . '" alt="">
                    <p><u>ID:</u> ' . $faccount['id'] . '</p>
                    <p><u>Name:</u> ' . ($faccount['name'] ?? '') . '</p>
                    <p><u>Email:</u> ' . ($faccount['email'] ?? '') . '</p>
                    <p><u>Access token:</u> <input type="text" value="' . ($faccount['access_token'] ?? '') . '" size="50"></p>
                    <a href="' . $this->api_page_url . '&api=facebook&remove_token=' . ($faccount['id'] ?? '') . '#sections-section_facebook" align="left">× Delete</a>
                    <div class="pages-wrapper">
                        <p><u><strong>Connected Pages:</strong></u></p>
                        ' . $fpages . '
                    </div>
                    <div class="pages-wrapper">
                        <p><u><strong>Connected Groups:</strong></u></p>
                        ' . $fgroups . '
                    </div>
                </div>';
            }
            $this->addSettingFields(
                'section_facebook',
                array(
                    'field_id'    => 'facebook_accounts_list',
                    'title'       => __( 'Authenticated Accounts', 'social-board-admin' ),
                    'type'        => 'facebook_accounts',
                    'content'     => $faccounts,
					'description' => __( 'The list of Facebook accounts you have authenticated (for which you have an access token).', 'social-board-admin' ),
					'value' 	  => ''
                )
            );
        }

        $this->addSettingFields(
            'section_twitter',
            array(
                'field_id' => 'twitter_app',
                'title' => __( 'How to connect?', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'no',
                'label' => array(
                    // 'yes' => 'Use our App',
                    'no' => 'Use your own App'
                ),
                'description' => __( '', 'social-board-admin' )
            ),
            array(
                'field_id' => 'twitter_api_key',
                'type' => 'text',
                'title' => __( 'API Key', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'field_id' => 'twitter_api_secret',
                'type' => 'text',
                'title' => __( 'API Secret', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'field_id' => 'twitter_get_token',
                'type' => 'get_token_html',
                'content' => __( 'Click the button below and log into your Twitter account to obtain your Access Token.<br>
                    <div style="padding-top: 10px; display: block;">
                        <a class="button button-primary" id="sb-twitter-token" type="button" href="'.$this->twitter_token_url.'">Get my Access Token</a>
                    </div>', 'social-board-admin' ),
                'description' => __( '<label id="sb-twitter-token-msg"></label>', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'twitter_access_token',
                'type' => 'text',
                'title' => __( 'Access Token', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'field_id' => 'twitter_access_token_secret',
                'type' => 'text',
                'title' => __( 'Access Token Secret', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'section_id' => 'section_google',
                'field_id' => 'google_api_key',
                'title' => __( 'Google API KEY', 'social-board-admin' ),
                'type' => 'text',
                'attributes' => array(
                    'style' => "width: 250px;"
                ),
                'description' => __( 'You can obtain it from <a href="https://code.google.com/apis/console/" target="_blank">Google APIs Console</a> - required', 'social-board-admin' )
            ),
            array(
                'section_id' => 'section_tumblr',
                'field_id' => 'tumblr_api_key',
                'title' => __( 'Tumblr API Key', 'social-board-admin' ),
                'type' => 'text',
                'attributes' => array(
                    'style' => "width: 250px;"
                ),
                'description' => __( 'You can obtain your API Key by <a href="https://www.tumblr.com/oauth/register" target="_blank">registering an application</a> on Tumblr website - required', 'social-board-admin' )
            ),
            array(
                'section_id' => 'section_flickr',
                'field_id' => 'flickr_api_key',
                'title' => __( 'Flickr API Key', 'social-board-admin' ),
                'type' => 'text',
                'attributes' => array(
                    'style' => "width: 250px;"
                ),
                'description' => __( 'You can obtain your API Key by <a href="https://www.flickr.com/services/apps/create/noncommercial/" target="_blank">registering an application</a> on Flickr App Garden - required', 'social-board-admin' )
            )
		);
        
        // Instagram Basic
		$this->addSettingFields(
			'section_instagram',
			array(
				'field_id' => 'instagram_basic_info',
				'type' => 'instagram_info_html',
				'title' => __( '<ins>Instagram Login (Professional Account)</ins>', 'social-board-admin' ),
				'content' => __( 'Get feed data from any of your Instagram professional accounts.', 'social-board-admin' ),
				'description' => __( '<a href="https://axentmedia.com/ax-social-stream-docs/#instagram-api" target="_blank">Check this tutorial</a> for more details on how to connect your Instagram accounts to the plugin using Instagram API.', 'social-board-admin' )
			)
		);

        // Getting Instagram connected accounts - Basic
        $instagram_accounts = SB_AdminPageFramework::getOption( 'AXS_Settings_Page', array( 'section_instagram', 'instagram_accounts' ) ) ?? SB_AdminPageFramework::getOption( 'SB_Settings_Page', array( 'section_instagram', 'instagram_accounts' ) );

		$this->addSettingFields(
			'section_instagram',
			array(
				'field_id' => 'instagram_app',
				'title' => __( 'How to connect?', 'social-board-admin' ),
				'type' => 'radio',
				'default' => 'yes',
				'label' => array(
					'yes' => 'Use our App',
					'no' => 'Use your own App'
				),
				'description' => __( '', 'social-board-admin' )
			),
			array(
				'field_id' => 'instagram_api_key',
				'type' => 'text',
				'title' => __( 'Instagram App ID', 'social-board-admin' ),
				'attributes' => array(
					'style' => "width: 250px;"
				)
			),
			array(
				'field_id' => 'instagram_api_secret',
				'type' => 'text',
				'title' => __( 'Instagram App Secret', 'social-board-admin' ),
				'attributes' => array(
					'style' => "width: 250px;"
				)
			),
			array(
				'field_id' => 'instagram_get_token',
				'type' => 'get_token_html',
				'content' => __( 'Click the button below and log into your Instagram account to get your Access Token.<br>
                    <div style="padding-top: 10px; display: block;">
                    	<a class="button button-primary" name="sb-instagram-token" id="sb-instagram-token" type="button" href="'.$this->instagram_token_url.'&instagram_client_id=&instagram_client_secret=">Connect Instagram Account(s)</a>
                    </div>', 'social-board-admin' ),
				'description' => __( '<label id="sb-instagram-token-msg"></label>', 'social-board-admin' )
			)
		);

        if ( ! empty($instagram_accounts) ) {
            $iaccounts = '';
            foreach ($instagram_accounts as $iaccount) {
                $iaccounts .= '
                <div class="accounts-wrapper">
                    <p><u>ID:</u> ' . $iaccount['id'] . '</p>
                    <p><u>Username:</u> ' . ($iaccount['username'] ?? '') . '</p>
                    <p><u>Access token:</u> <input type="text" value="' . ($iaccount['access_token'] ?? '') . '" size="50"></p>
					<a href="' . $this->api_page_url . '&api=instagram&remove_token=' . ($iaccount['id'] ?? '') . '#sections-section_instagram" align="left">× Delete</a>
                </div>';
			}
            $this->addSettingFields(
                'section_instagram',
                array(
                    'field_id'    => 'instagram_accounts_list',
                    'title'       => __( 'Authenticated Accounts', 'social-board-admin' ),
                    'type'        => 'instagram_accounts',
                    'content'     => $iaccounts,
                    'description' => __( 'The list of Instagram accounts you have authenticated (for which you have an access token).', 'social-board-admin' )
                )
            );
		}

		$this->addSettingFields(
			'section_instagram',
			array(
				'field_id' => 'instagram_business_info',
				'type' => 'instagram_info_html',
				'title' => __( '<ins>Instagram with Facebook Login</ins>', 'social-board-admin' ),
				'content' => __( 'Get feed data from any of your Instagram professional accounts and/or get feed data from any <strong>hashtag</strong> limited to posts published within the last 24 hours.' ),
				'description' => __( '<a href="https://axentmedia.com/ax-social-stream-docs/#instagram-business-api" target="_blank">Check this tutorial</a> for more details on how to connect your Instagram accounts to the plugin.', 'social-board-admin' )
			)
		);
		
        // Getting Instagram connected accounts - Business
        $instagram_business_accounts = SB_AdminPageFramework::getOption( 'AXS_Settings_Page', array( 'section_instagram', 'instagram_bussiness_accounts' ) ) ?? SB_AdminPageFramework::getOption( 'SB_Settings_Page', array( 'section_instagram', 'instagram_bussiness_accounts' ) );

		$this->addSettingFields(
			'section_instagram',
			array(
				'field_id' => 'instagram_facebook_app',
				'title' => __( 'How to connect?', 'social-board-admin' ),
				'type' => 'radio',
				'default' => 'yes',
				'label' => array(
					'yes' => 'Use our App',
					'no' => 'Use your own App',
					'token' => 'Already connected on another website'
				)
			),
			array(
				'field_id'   => 'instagram_facebook_save_other_token',
				'type'       => 'text',
				'title'      => __( 'Facebook Token', 'social-board-admin' ),
				'attributes' => array(
					'style' => 'width: 250px;'
				)
			),
			array(
				'field_id' => 'instagram_facebook_api_key',
				'type' => 'text',
				'title' => __( 'Facebook App ID', 'social-board-admin' ),
				'attributes' => array(
					'style' => "width: 250px;"
				)
			),
			array(
				'field_id' => 'instagram_facebook_api_secret',
				'type' => 'text',
				'title' => __( 'Facebook App Secret', 'social-board-admin' ),
				'attributes' => array(
					'style' => "width: 250px;"
				)
			),
			array(
				'field_id' => 'instagram_facebook_get_token',
				'type' => 'get_token_html',
				'content' => __( 'Click the button below and log into your Facebook account to get your Access Token.<br>
                    <div style="padding-top: 10px; display: block;">
                    	<a class="button button-primary" name="sb-instagram_facebook-token" id="sb-instagram_facebook-token" type="button" href="'.$this->instagram_facebook_token_url.'">Connect Instagram Account(s)</a>
                    </div>', 'social-board-admin' ),
				'description' => __( '<label id="sb-instagram_facebook-token-msg"></label>', 'social-board-admin' )
			),
			array(
				'section_id' => 'section_instagram',
				'field_id' => 'instagram_facebook_save_btn_token',
				'type' => 'get_token_html',
				'content' => __( 'Click the button below to connect your Instagram professional account.
                    <div style="padding-top: 10px; display: block;">
                        <a class="button button-primary" name="sb-instagram-facebook-save-token" id="sb-instagram-facebook-save-token" type="button" href="'.$this->api_page_url.'&api=instagram_facebook&access_token=">Connect Instagram Account(s)</a>
                    </div>', 'social-board-admin' ),
			)
		);

        if ( ! empty($instagram_business_accounts) ) {
            $iaccounts = '';
            foreach ($instagram_business_accounts as $iaccount) {
                $fpages = '';
                if ( ! empty($iaccount['accounts']) ) {
                    foreach ($iaccount['accounts'] as $fpage) {
						$fpages .= '
						<div class="page-wrapper">
							<img src="' . ($fpage['picture'] ?? '') . '" alt="">
							<p><u>ID:</u> ' . $fpage['id'] . '</p>
							<p><u>Name:</u> ' . ($fpage['name'] ?? '') . '</p>
							<p><u>Username:</u> ' . ($fpage['username'] ?? '') . '</p>
							<p><u>Access token:</u> <input type="text" value="' . ($fpage['access_token'] ?? '') . '" size="50"></p>
						</div>';
                    }
                }
                
                $iaccounts .= '
                <div class="accounts-wrapper">
                    <img src="' . ($iaccount['picture'] ?? '') . '" alt="">
                    <p><u>ID:</u> ' . $iaccount['id'] . '</p>
					<p><u>Name:</u> ' . ($iaccount['name'] ?? '') . '</p>
                    <p><u>Email:</u> ' . ($iaccount['email'] ?? '') . '</p>
                    <p><u>Access token:</u> <input type="text" value="' . ($iaccount['access_token'] ?? '') . '" size="50"></p>
                    <a href="' . $this->api_page_url . '&api=instagram_facebook&remove_token=' . ($iaccount['id'] ?? '') . '#sections-section_instagram_facebook" align="left">× Delete</a>
                    <div class="pages-wrapper">
                        <h4><u>Connected Instagram Professional Accounts:</u></h4>
                        ' . $fpages . '
                    </div>
                </div>';
            }
            $this->addSettingFields(
                'section_instagram',
                array(
                    'field_id'    => 'instagram_facebook_accounts_list',
                    'title'       => __( 'Authenticated Accounts', 'social-board-admin' ),
                    'type'        => 'instagram_facebook_accounts',
                    'content'     => $iaccounts,
                    'description' => __( 'The list of Instagram accounts you have authenticated (for which you have an access token).', 'social-board-admin' )
                )
            );
        }

        // Getting TikTok connected accounts
        $tiktok_accounts = SB_AdminPageFramework::getOption( 'AXS_Settings_Page', array( 'section_tiktok', 'tiktok_accounts' ) ) ?? SB_AdminPageFramework::getOption( 'SB_Settings_Page', array( 'section_tiktok', 'tiktok_accounts' ) );

		$this->addSettingFields(
			'section_tiktok',
			array(
				'field_id' => 'tiktok_app',
				'title' => __( 'How to connect?', 'social-board-admin' ),
				'type' => 'radio',
				'default' => 'yes',
				'label' => array(
					'yes' => 'Use our App',
					'no' => 'Use your own App'
				)
			),
			array(
				'field_id' => 'tiktok_api_key',
				'type' => 'text',
				'title' => __( 'TikTok Client key', 'social-board-admin' ),
				'attributes' => array(
					'style' => "width: 250px;"
				)
			),
			array(
				'field_id' => 'tiktok_api_secret',
				'type' => 'text',
				'title' => __( 'TikTok Client secret', 'social-board-admin' ),
				'attributes' => array(
					'style' => "width: 250px;"
				)
			),
			array(
				'field_id' => 'tiktok_get_token',
				'type' => 'get_token_html',
				'content' => __( 'Click the button below and log into your TikTok account to get your Access Token.<br>
                    <div style="padding-top: 10px; display: block;">
                    	<a class="button button-primary" name="sb-tiktok-token" id="sb-tiktok-token" type="button" href="'.$this->tiktok_token_url.'">Connect TikTok Account(s)</a>
                    </div>', 'social-board-admin' ),
				'description' => __( '<label id="sb-tiktok-token-msg"></label>', 'social-board-admin' )
			)
		);

        if ( ! empty($tiktok_accounts) ) {
            $tikaccounts = '';
            foreach ($tiktok_accounts as $tikaccount) {
                $tikaccounts .= '
                <div class="accounts-wrapper">
					<img src="' . $tikaccount['avatar_url'] . '" alt="">
                    <p><u>ID:</u> ' . $tikaccount['open_id'] . '</p>
                    <p><u>Name:</u> ' . ($tikaccount['display_name'] ?? '') . '</p>
                    <p><u>Access token:</u> <input type="text" value="' . ($tikaccount['access_token'] ?? '') . '" size="50"></p>
					<a href="' . $this->api_page_url . '&api=tiktok&remove_token=' . ($tikaccount['open_id'] ?? '') . '#sections-section_tiktok" align="left">× Delete</a>
                </div>';
			}
            $this->addSettingFields(
                'section_tiktok',
                array(
                    'field_id'    => 'tiktok_accounts_list',
                    'title'       => __( 'Authenticated Accounts', 'social-board-admin' ),
                    'type'        => 'tiktok_accounts',
                    'content'     => $tikaccounts,
                    'description' => __( 'The list of TikTok accounts you have authenticated (for which you have an access token).', 'social-board-admin' )
                )
            );
		}

        $this->addSettingFields(
            array(
                'section_id' => 'section_vimeo',
                'field_id' => 'vimeo_access_token',
                'type' => 'text',
                'title' => __( 'Vimeo Access Token', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            ),
            array(
                'section_id' => 'section_vk',
                'field_id' => 'vk_service_token',
                'title' => __( 'VK Service Token', 'social-board-admin' ),
                'type' => 'text',
                'attributes' => array(
                    'style' => "width: 250px;"
                ),
                'description' => __( 'You can obtain your Service Token by <a href="https://vk.com/editapp?act=create" target="_blank">registering an application</a> on VK Developers website - required', 'social-board-admin' )
            )
        );

		$this->addSettingFields( 'section_soundcloud', array(
				'field_id' => 'soundcloud_app',
				'title'    => __( 'How to connect?', 'social-board-admin' ),
				'type'     => 'radio',
				'default'  => 'yes',
				'label'    => array(
					'yes' => 'Use our App',
					'no'    => 'Use your own App'
				)
			),
			array(
				'field_id'   => 'soundcloud_api_key',
				'type'       => 'text',
				'title'      => __( 'SoundCloud Client ID', 'social-board-admin' ),
				'attributes' => array(
					'style' => 'width: 250px;'
				)
			),
			array(
				'field_id'   => 'soundcloud_api_secret',
				'type'       => 'text',
				'title'      => __( 'SoundCloud Client Secret', 'social-board-admin' ),
				'attributes' => array(
					'style' => 'width: 250px;'
				)
			),
			array(
				'field_id'    => 'soundcloud_get_token',
				'type'        => 'get_token_html',
				'content'     => __( 'Click the button below and log into your SoundCloud account to get your Access Token.<br>
                    <div style="padding-top: 10px; display: block;">
                    	<a class="button button-primary" name="sb-soundcloud-token" id="sb-soundcloud-token" type="button" href="' . $this->soundcloud_token_url . '">Get my Access Token</a>
                    </div>', 'social-board-admin' ),
				'description' => __( '<label id="sb-soundcloud-token-msg"></label>', 'social-board-admin' )
			),
            array(
                'field_id' => 'soundcloud_access_token',
                'type' => 'text',
                'title' => __( 'Access Token', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                )
            )
		);
        
		// Reset Submit button
        $this->addSettingFields(
            array(
                'section_id' => 'section_reset',
                'field_id' => 'reset_default',
                'title' => __( 'Reset Default', 'social-board-admin' ),
                'type' => 'submit',
                'label' => __( 'Reset', 'social-board-admin' ),
                'reset' => true,
                'attributes' => array(
                    'class' => 'button button-secondary',
                ),
                'description' => __( 'If you press this button, a confirmation message will appear and then if you press it again, it resets all the options to the default settings.', 'social-board-admin' ),
            )
        );
        
        // Add license message
        $license_desc = 'Enter your CodeCanyon purchase key to enable and receive automatic updates.
        <p><strong>Each website using this plugin needs a legal license (1 license = 1 website).</strong><br>
        You can find more information on envato licenses <a href="https://codecanyon.net/licenses/standard" target="_blank">clicking here</a>.<br>
        If you need to buy a new license of this plugin, <a href="https://axentmedia.com/ax-social-stream/" target="_blank">click here</a>.</p>
        <p><a href="https://axentmedia.com/ax-social-stream-docs/#licensing" target="_blank">Where I can find my purchase code?</a></p>';
        
        // All layouts are enabled for release under 3.4.9
        $version = get_option("sb_version");
        $layout_active = (version_compare($version, '3.4.9', '<') ) ? true : false;

        $this->addSettingFields(
            array(
                'section_id' => 'section_licensing',
                'field_id' => 'license_key',
                'type' => 'text',
                'title' => __( 'License/Purchase Key', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "width: 250px;"
                ),
                'description' => __( $license_desc, 'social-board-admin' )
            ),
            array(
                'section_id' => 'section_layouts',
                'field_id'      => 'enabled_layouts',
                'title'         => __( 'Enabled Layouts', 'social-board-admin' ),
                'type'          => 'checkbox',
                'label'         => array(
                    'wall' => __( 'Masonry', 'social-board-admin' ),
                    'grid' => __( 'Grid', 'social-board-admin' ),
                    'timeline' => __( 'Timeline', 'social-board-admin' ),
                    'feed' => __( 'Rotating Feed - <small>This will also enable the social stream widget in Appearance > Widgets page</small>', 'social-board-admin' ),
                    'carousel' => __( 'Carousel', 'social-board-admin' )
                ),
                'default' => array(
                    'wall' => true,
                    'timeline' => $layout_active,
                    'feed' => $layout_active,
                    'carousel' => $layout_active
                ),
                'description'   => __( 'If any of these items are checked, their related options and assets will be added to the plugin so, only enable the layout(s) you want to use it.', 'social-board-admin' ),
                'after_label'   => '<br />',
            ),
            array(
                'section_id'    => 'section_layouts',
                'field_id'      => 'js_assets_position',
                'type'          => 'inline_mixed',
                'title' => __( 'JS Assets Position', 'social-board-admin' ),
                'content'       => array(
                    array(
                        'field_id'        => 'footer',
                        'type'            => 'select',
                        'label'           => array(
                            false => __( 'Header', 'social-board-admin' ),
                            true => __( 'Footer', 'social-board-admin' )
                        ),
                        'default'         => true,
                        'attributes' => array(
                            'select' => array(
                                'style' => "width: 150px;",
                            ),
                        )
                    ),
                    array(
                        'field_id'        => 'order',
                        'type'            => 'number',
                        'default'         => 10,
                        'attributes'      => array(
                            'style'     => 'width: 150px',
                        )
                    )
                ),
                'description' => __( 'Specify the position and order in which the JS files associated with the plugin will be added into your website.', 'social-board-admin' ),
            )
        );
    }

    private function ___getRowCheckboxes( $rowid, array $fields ) {
        $_aSavedCheckboxes = $this->oUtil->getElement( 
            $this->oProp->aOptions, 
            array( 'setting', 'filters_order', $rowid ),
            $fields
        );
        return $this->___getCheckboxLabels( $_aSavedCheckboxes );
    }
    
    // Get Social Checkboxes
    private function ___getCheckboxLabels($aSavedCheckboxes) {
        if ( ! is_array($aSavedCheckboxes) )
        	$aSavedCheckboxes = array($aSavedCheckboxes => 1);

        $_aCheckboxes = array();
        foreach($aSavedCheckboxes as $_sKey => $_iValue) {
            $_aCheckboxes[] = array(
                'field_id'  => $_sKey,
                'type'      => 'checkbox',
                'label'     => $this->___getCheckboxLabelByKey( $_sKey ),
                'value'     => $_iValue,
            );
        }
        return $_aCheckboxes;
    }
    
    // Get Social Label
    private function ___getCheckboxLabelByKey($sKey) {
        $_aLabels = array(
            'facebook' => __( 'Facebook', 'social-board-admin' ),
            'twitter' => __( 'Twitter', 'social-board-admin' ),
            'tumblr' => __( 'Tumblr', 'social-board-admin' ),
            'delicious' => __( 'Delicious', 'social-board-admin' ),
            'pinterest' => __( 'Pinterest', 'social-board-admin' ),
            'flickr' => __( 'Flickr', 'social-board-admin' ),
            'instagram' => __( 'Instagram', 'social-board-admin' ),
            'youtube' => __( 'YouTube', 'social-board-admin' ),
            'vimeo' => __( 'Vimeo', 'social-board-admin' ),
            'stumbleupon' => __( 'Stumbleupon', 'social-board-admin' ),
            'deviantart' => __( 'Deviantart', 'social-board-admin' ),
            'rss' => __( 'RSS', 'social-board-admin' ),
            'soundcloud' => __( 'SoundCloud', 'social-board-admin' ),
            'vk' => __( 'VK', 'social-board-admin' ),
            'linkedin' => __( 'LinkedIn', 'social-board-admin' ),
			'wordpress' => __( 'WordPress', 'social-board-admin' ),
			'tiktok' => __( 'TikTok', 'social-board-admin' )
        );
        return isset( $_aLabels[ $sKey ] ) ? $_aLabels[ $sKey ] : '';
    }

    // Built-in Field Types Page
    public function do_sb_settings() { // do_{page slug}
        if (isset($_GET['tab']) && $_GET['tab'] != 'debug' && $_GET['tab'] != 'reset') {
            submit_button();
		}
    }
    
    // Filter the page contents.
    public function content_sb_settings( $sContent ) { // content_ + {page slug}
        if (isset($_GET['tab']) && $_GET['tab'] == 'api')
            $msg = __( 'Some networks require <code>authentication</code> to provide feed data. <a href="'. AXS_DOCS . '#api-credentials" target="_blank">Check the documentation</a> for more details.</code>', 'social-board-admin' );
        elseif (isset($_GET['tab']) && $_GET['tab'] == 'setting')
            $msg = __( 'All changes here will only effect the plugin <code>default settings</code>. You can use inline attributes in shortcodes to override these default options.', 'social-board-admin' );
        else
            $msg = '';
        return '<p>' . $msg . '</p>' . $sContent;
    }
    
    public function do_sb_settings_debug() { // do_ + page slug + _ + tab slug
        $file = AXS_DIRNAME . '/sb.log';
        if ( file_exists($file) ) {
            $_aSBLog = file_get_contents( $file );
            echo '<div style="overflow: scroll;min-height: 800px">' . nl2br($_aSBLog) . '</div>';
        }
    }

	function axs_settings_inline_script() {
		if ( wp_script_is( 'jquery', 'done' ) ) {
			?>
			<script type="text/javascript">
				jQuery(document).ready(function($) {

					// Masonry Wall item width
					function sb_set_fixWidth(fixed_width) {
						if (fixed_width == 'true') {
							$("#fieldrow-wallsetting_breakpoints").fadeOut('fast');
							$("#fieldrow-wallsetting_itemwidth").fadeIn('fast');
						} else {
							$("#fieldrow-wallsetting_itemwidth").fadeOut('fast');
							$("#fieldrow-wallsetting_breakpoints").fadeIn('fast');
						}
					}
					$('[name="AXS_Settings_Page[wallsetting][fixWidth]"]').on("change", function() {
						var fixed_width = $(this).val();
						sb_set_fixWidth(fixed_width);
					});
					var fixed_width = $('[name="AXS_Settings_Page[wallsetting][fixWidth]"]:checked').val();
					sb_set_fixWidth(fixed_width);

					// Lightbox Type setting
					function sb_set_slideshow(lightboxtype) {
						if (lightboxtype == 'slideshow') {
							$("#fieldrow-setting_slicepoint").fadeIn('fast');
						} else {
							$("#fieldrow-setting_slicepoint").fadeOut('fast');
						}
					}
					$('[name="AXS_Settings_Page[setting][lightboxtype]"]').on("change", function() {
						var lightboxtype = $(this).val();
						sb_set_slideshow(lightboxtype);
					});
					var lightboxtype = $('[name="AXS_Settings_Page[setting][lightboxtype]"]:checked').val();
					sb_set_slideshow(lightboxtype);

					// App selection
					var token_url = {
						twitter: '<?php echo $this->twitter_token_url ?>',
						linkedin: '<?php echo $this->linkedin_token_url ?>',
						facebook: '<?php echo $this->facebook_token_url ?>',
						instagram: '<?php echo $this->instagram_token_url ?>',
						instagram_facebook: '<?php echo $this->instagram_facebook_token_url ?>',
						soundcloud: '<?php echo $this->soundcloud_token_url ?>',
						tiktok: '<?php echo $this->tiktok_token_url ?>'
					};

					function sb_set_app(app, network, section) {
						if ( ! section)
							var section = network;
						var fieldrow = "#fieldrow-section_"+section+"_"+network+"_";
						if (app == 'yes') {
							$(fieldrow+"api_key").fadeOut('fast');
							$(fieldrow+"api_secret").fadeOut('fast');
							$(fieldrow+"save_other_token").fadeOut('fast');
							$(fieldrow+"save_btn_token").fadeOut('fast');
							$(fieldrow+"get_token").fadeIn('fast');
						} else if(app == 'token') {
							$(fieldrow+"api_key").fadeOut('fast');
							$(fieldrow+"api_secret").fadeOut('fast');
							$(fieldrow+"get_token").fadeOut('fast');
							$(fieldrow+"save_other_token").fadeIn('fast');
							$(fieldrow+"save_btn_token").fadeIn('fast');
							sb_set_tokenurl(network, "<?= $this->api_page_url ?>&api="+network+"&access_token=", network + "_save_token");
						} else {
							$(fieldrow+"save_other_token").fadeOut('fast');
							$(fieldrow+"save_btn_token").fadeOut('fast');
							$(fieldrow+"api_key").fadeIn('fast');
							$(fieldrow+"api_secret").fadeIn('fast');
							$(fieldrow+"get_token").fadeIn('fast');
							sb_set_tokenurl(network, token_url[network], section);
						}
					}

					function sb_set_tokenurl(network, token_url, section) {
						if(section == "facebook_save_token") {
							let token = $('[name="AXS_Settings_Page[section_'+network+']['+network+'_save_other_token]"]').val();
							$("#sb-facebook-save-token").attr('href', token_url+(token ? token : ""));
						}
						if (section == 'instagram_facebook_save_token') {
							let token = $('[name="AXS_Settings_Page[section_instagram][' + network + '_save_other_token]"]').val();
							$('#sb-instagram-facebook-save-token').attr('href', token_url + (token ? token : ''));
						}
						else {
							var api_key = $('[name="AXS_Settings_Page[section_'+section+']['+network+'_api_key]"]').val();
							var api_secret = $('[name="AXS_Settings_Page[section_'+section+']['+network+'_api_secret]"]').val();
							$("#sb-"+network+"-token").attr('href', token_url+'&api_key='+api_key+'&api_secret='+api_secret);
						}
					}

					function sb_set_api(network, section) {
						if ( ! section)
							var section = network;
						$('[name="AXS_Settings_Page[section_'+section+']['+network+'_app]"]').on("change", function() {
							sb_set_app($(this).val(), network, section);
							if ( $(this).val() == 'yes' )
								$("#sb-"+network+"-token").attr('href', token_url[network]);
						});
						var the_app = $('[name="AXS_Settings_Page[section_'+section+']['+network+'_app]"]:checked').val();
						sb_set_app(the_app, network, section);

						$('[name="AXS_Settings_Page[section_'+section+']['+network+'_api_key]"],[name="AXS_Settings_Page[section_'+section+']['+network+'_api_secret]"]').on("keyup keypress blur change click", function() {
							sb_set_tokenurl(network, token_url[network], section);
						});
						$('[name="AXS_Settings_Page[section_'+section+']['+network+'_save_other_token]"]').on("keyup keypress blur change click", function() {
							sb_set_tokenurl(network, "<?= $this->api_page_url ?>&api="+network+"&access_token=", network+"_save_token");
						});
					}

					sb_set_api('twitter');
					sb_set_api('facebook');
					sb_set_api('instagram');
					sb_set_api('instagram_facebook', 'instagram');
					sb_set_api('soundcloud');
					sb_set_api('tiktok');
					// End - App selection

					// Access token set
					var query = window.location.search;
					if (query.length && query.indexOf("access_token") > -1) {
						var apis = ["facebook", "twitter", "linkedin", "instagram", "instagram_facebook", "soundcloud", "tiktok"];
						var api = getUrlVars()["api"];
						if (apis.indexOf(api) > -1) {
							var access_token = getUrlVars()["access_token"];
							var api_key = getUrlVars()["api_key"];
							var api_secret = getUrlVars()["api_secret"];

							var section = api;
							if (api == 'facebook') {
								var tokenmsg = 'You successfully connected your Facebook account.';
							} else if (api == 'twitter') {
								var access_token_secret = getUrlVars()["access_token_secret"];
								$('[name="AXS_Settings_Page[section_twitter][twitter_access_token]"]').val(access_token);
								$('[name="AXS_Settings_Page[section_twitter][twitter_access_token_secret]"]').val(access_token_secret);
								var tokenmsg = 'Access Token is set. Do not forget to click <strong>Save Changes</strong> button at the end of this page.';
							} else if (api == 'linkedin') {
								$('[name="AXS_Settings_Page[section_linkedin][linkedin_access_token]"]').val(access_token);
								var tokenmsg = 'Access Token is set. Do not forget to click <strong>Save Changes</strong> button at the end of this page.';
							} else if (api == 'instagram') {
								var tokenmsg = 'You successfully connected your Instagram account.';
							} else if (api == 'instagram_facebook') {
								section = 'instagram';
								var tokenmsg = 'You successfully connected your Instagram account.';
							} else if (api == 'soundcloud') {
								$('[name="AXS_Settings_Page[section_soundcloud][soundcloud_access_token]"]').val(access_token);
								var tokenmsg = 'Access Token is set.';
							} else if (api == 'tiktok') {
								$('[name="AXS_Settings_Page[section_tiktok][tiktok_access_token]"]').val(access_token);
								var tokenmsg = 'Access Token is set.';
							}

							if (api_key && api_secret) {
								$('[name="AXS_Settings_Page[section_'+section+']['+api+'_app]"][value=no]').prop("checked", true);
								sb_set_app('no', api, section);
								$('[name="AXS_Settings_Page[section_'+section+']['+api+'_api_key]"]').val(api_key);
								$('[name="AXS_Settings_Page[section_'+section+']['+api+'_api_secret]"]').val(api_secret);
							}

							// scroll page to api section
							var target = $('#sections-section_' + section);
							if (target.length) {
								$('html,body').animate({
									scrollTop: target.offset().top
								}, 0);
							}

							// Display success message
							$("#sb-" + api + "-token-msg").html('<span style="color:green;">'+tokenmsg+'</span>');
						}
					}
					function InstagramSetUrl() {
						var client_id = $('[name="AXS_Settings_Page[section_instagram][instagram_client_id]"]').val();
						var client_secret = $('[name="AXS_Settings_Page[section_instagram][instagram_client_secret]"]').val();

						var get_token_uri = '<?php echo $this->instagram_token_url ?>';
						$("#sb-instagram-token").attr('href', get_token_uri+'&instagram_client_id='+client_id+'&instagram_client_secret='+client_secret);
					}

					function InstagramChangeApp() {
						if ($('[name="AXS_Settings_Page[section_instagram][instagram_app]"]:checked').val() == "yes") {
							$("#fieldrow-section_instagram_instagram_client_id,#fieldrow-section_instagram_instagram_client_secret").fadeOut('fast');
							$('[name="AXS_Settings_Page[section_instagram][instagram_client_id]"],[name="AXS_Settings_Page[section_instagram][instagram_client_secret]"]').val("");
						} else {
							$("#fieldrow-section_instagram_instagram_client_id,#fieldrow-section_instagram_instagram_client_secret").fadeIn('fast');;
						}
						InstagramSetUrl();
					}

					function getUrlVars() {
						var vars = {};
						var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m, key, value) {
							vars[key] = value;
						});
						return vars;
					}
				});
			</script>
			<?php
		}
	}
}

/* End of file ./admin/SB_Settings_Page.php */