<?php

/**
 * AX Social Stream
 * Copyright © 2014 Axent Media LLC, All Rights Reserved.
 * https://axentmedia.com/support/
 */

// create manage themes page in admin
class AXS_MetaBox_Themes extends SB_AdminPageFramework_MetaBox {

    public function start_AXS_MetaBox_Themes() {

        if ( ! class_exists('SB_AceCustomFieldType') )
            include_once( AXS_DIRNAME . '/library/admin-page-framework/custom-field-types/ace-custom-field-type/AceCustomFieldType.php');
        $sClassName = get_class( $this );
        new SB_AceCustomFieldType( $sClassName );

        add_filter('admin_footer', 'axs_themes_inline_script');
    }
    
    /*
     * ( optional ) Use the setUp() method to define settings of this meta box.
     */
    public function setUp() {
        $this->oProp->bShowDebugInfo = false;
        
        /*
         * ( optional ) Adds setting fields into the meta box.
         */
        $this->addSettingFields(
            array(
                'field_id'      => 'classname',
                'type'          => 'text',
                'title'         => __( 'CSS Class Name', 'social-board-admin' ),
                'description'   => __( 'Select a name for the theme CSS <code>class</code> selector (without dot). You will also use this name in your shortcodes e.g.<br />[social_board id="123" type="masonry" theme="class-name"]', 'social-board-admin' )
            ),
            array(
                'field_id' => 'layout',
                'type' => 'select',
                'title' => __( 'Stream Layout', 'social-board-admin' ),
                'label' => axs_getFileTitles(),
                'attributes' => array(
                    'select' => array(
                        'style' => "width: 150px;",
                    ),
                ),
                'description' => __( 'Use a predefined layout or create your own layout and put in the <code>./wp-content/uploads/ax-social-stream/themes/</code> folder to use here. <a href="'. AXS_DOCS . '#themes" target="_blank">Read the documentation</a> for more details.', 'social-board-admin' ),
            ),
            array( // Text Area
                'field_id'      => 'custom_css',
                'type'          => 'ace',
                'title'         => __( 'Custom CSS', 'social-board-admin' ),
                'description'   => __( 'Custom CSS for styling the Social Stream can be entered into this text field. Any CSS rules included in this text area will automatically be inserted into the page.', 'social-board-admin' ),
                'attributes'    => array(
                    'rows' => 8,
                    'cols' => 75
                ),
                'options'   => array(
                    'language'              => 'css',
                    'theme'                 => 'chrome',
                    'gutter'                => false,
                    'readonly'              => false,
                    'fontsize'              => 12
                )
            )
        );
    }
    
    /*
     * Built-in Field Types Page
     * */
    public function do_AXS_MetaBox_Themes() { // do_{instantiated class name}
        ?>
            <p><?php _e( 'Do not forget to select a <code>.class</code> name for your theme. Use the selected name in the Custom CSS section.', 'social-board-admin' ) ?></p>
        <?php
    }
    
    /*
     * ( optional ) Use this method to validate submitted option values.
     */
    public function validation_AXS_MetaBox_Themes( $aInput, $aOldInput, $oAdmin ) { // validation_{instantiated class name}
    
        $_bIsValid  = true;
        $_aErrors   = array();
        
        // Validate the submitted data.
        if ( strlen( trim( $aInput['classname'] ) ) < 3 ) {
            $_aErrors['classname'] = __( 'The field is missing or the entered text is too short! Type more than 2 characters.', 'social-board-admin' );
            $_bIsValid = false;
        }
        
        if ( ! $_bIsValid ) {
            $this->setFieldErrors( $_aErrors );
            $this->setSettingNotice( __( 'There was an error in your input data in the form fields.', 'social-board-admin' ) );    
            return $aOldInput;
        }

        return $aInput;
    }
}

function axs_themes_inline_script() {
    if ( wp_script_is( 'jquery', 'done' ) ) {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        // show/hide layout options
        $( 'select[name="layout"]' ).on('change', function() {
            sb_layout_update( $(this).val() );
        });

        // set default
        var defLayout = $( 'select[name="layout"]' ).val();
        if (defLayout)
            sb_layout_update( defLayout );
    });
    
    // show/hide layout options function
    function sb_layout_update(layout) {
        jQuery( 'div[id^="axs_metabox_"]' ).hide();
        jQuery( '#axs_metabox_' + layout ).show();
    }
    </script>
    <?php
    }
}
