<?php

/**
 * AX Social Stream 3.6.0
 * Copyright 2014 Axent Media (axentmedia@gmail.com)
 */

// create an admin help sidebar
class AXS_MetaBox_Social_Boards_Side extends SB_AdminPageFramework_MetaBox {
    public function setUp() {}
    
    public function do_AXS_MetaBox_Social_Boards_Side() { // do_{instantiated class name}
        $postid = get_the_ID();
        ?>
        <h4>Add your Social Stream to a post or page</h4>
        <p>Add or edit the post or page that you want your Social Stream display on. Then, copy and paste the shortcode below into your post or page content.</p>
        <p><strong>Masonry Shortcode:</strong><br />
        [social_board id="<?php echo $postid; ?>" type="masonry"]<br />
        <strong>Carousel Shortcode:</strong><br />
        [social_board id="<?php echo $postid; ?>" type="carousel"]<br />
        <strong>Grid Shortcode:</strong><br />
        [social_board id="<?php echo $postid; ?>" type="grid"]<br />
        <strong>Timeline Shortcode:</strong><br />
        [social_board id="<?php echo $postid; ?>" type="timeline"]<br />
        <strong>Rotating Feed Shortcode:</strong><br />
        [social_board id="<?php echo $postid; ?>" type="feed"]</p>
        
        <h4>Add your Social Stream as a widget</h4>
        <p>To add the Social Stream as a widget into a widget enabled area, go to: <code>Appearance → Widgets</code> in the WordPress navigation.
        Find the widget with the title <strong>"Social Stream"</strong> and simply drag it to your widget enabled area.
        Select one of the Social Streams from the dropdown box, set the other options and click Save.</p>

        <h4>Add your Social Stream to a theme file</h4>
        <p>To add this Social Stream to one of your theme PHP files, use the PHP snippet below.</p>
        <p style="font-family:Courier New;">&lt;?php if (function_exists('social_board')) echo social_board( array( 'id' =&gt; <?php echo $postid; ?>, 'type' =&gt; '<strong>&lt;Stream Type&gt;</strong>' ) ); ?&gt;</p>
        <p>According to your desired Stream, the <strong>&lt;Stream Type&gt;</strong> could be on of the following displaying modes:<br />
        <code>feed</code> - <strong>Rotating Feed layout</strong><br />
        <code>masonry</code> - <strong>Masonry layout</strong><br />
        <code>timeline</code> - <strong>Timeline layout</strong><br />
        <code>carousel</code> - <strong>Carousel layout</strong><br />
        <code>grid</code> - <strong>Grid layout</strong>
        </p>
        <?php
    }
}
