<?php

/**
 * AX Social Stream
 * Copyright 2014 Axent Media (support@axentmedia.com)
 */

// create a custom post type for Social Streams
class AXS_MetaBox_Social_Boards extends SB_AdminPageFramework_MetaBox {

    /**
     * The start() method is called at the end of the constructor.
     */
    public function start() {
        if ( ! class_exists('DateTimeRangeCustomFieldType'))
            include( AXS_DIRNAME . '/library/admin-page-framework/custom-field-types/date-time-custom-field-type/DateTimeRangeCustomFieldType.php' );
        $_sClassName = get_class( $this );
        new DateTimeRangeCustomFieldType( $_sClassName );
    }
    
    /*
     * ( optional ) Use the setUp() method to define settings of this meta box.
     */
    public function setUp() {
		$sbwordpress = new \AXS_AX_SOCIAL\WP\AXS_Wordpress();

        $this->oProp->bShowDebugInfo = false;
        
        $tabDesc = 'You can enter multiple IDs by clicking <code>+</code> sign.';
        $this->addSettingSections(
            array(
                'section_id' => 'section_facebook',
                'section_tab_slug' => 'tabbed_sections',
                'title' => __( '<i class="sb-icon sb-facebook" title="Facebook"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br /><a href="'. AXS_DOCS . '#facebook-api" target="_blank">Check this tutorial</a> for more details on how to connect your Facebook accounts/pages to the plugin.' , 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_twitter',
                'title' => __( '<i class="sb-icon sb-twitter" title="Twitter"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br /><a href="'. AXS_DOCS . '#twitter-api" target="_blank">Check this tutorial</a> for more details on how to connect your Twitter accounts to the plugin.', 'social-board-admin' ),
                // <br><strong>Twitter:</strong> You are limited to 10 feed requests / 24 hours per license key.
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_tumblr',
                'title' => __( '<i class="sb-icon sb-tumblr" title="Tumblr"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br />Tumblr requires an API Key to provide the feed\'s data. <a href="'. AXS_DOCS . '#tumblr-api" target="_blank">Check this tutorial</a> for more details.', 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_pinterest',
                'title' => __( '<i class="sb-icon sb-pinterest" title="Pinterest"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc, 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_flickr',
                'title' => __( '<i class="sb-icon sb-flickr" title="Flickr"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br />Flickr requires an API Key to provide the feed\'s data. <a href="'. AXS_DOCS . '#flickr-api" target="_blank">Check this tutorial</a> for more details.', 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_instagram',
                'title' => __( '<i class="sb-icon sb-instagram" title="Instagram"></i>', 'social-board-admin' ),
				'description' => __( $tabDesc . '<br /><a href="https://axentmedia.com/ax-social-stream-docs/#instagram-api" target="_blank">Check this tutorial</a> for more details on how to connect your Instagram accounts to the plugin.' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_youtube',
                'title' => __( '<i class="sb-icon sb-youtube" title="YouTube"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br />YouTube requires a Google API Key to display the feed\'s data. <a href="'. AXS_DOCS . '#google-api" target="_blank">Check this tutorial</a> for more details.', 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_vimeo',
                'title' => __( '<i class="sb-icon sb-vimeo" title="Vimeo"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br />Vimeo requires an Access Token to display the feed\'s data. <a href="'. AXS_DOCS . '#vimeo-api" target="_blank">Check this tutorial</a> for more details.', 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_deviantart',
                'title' => __( '<i class="sb-icon sb-deviantart" title="Deviantart"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc, 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_rss',
                'title' => __( '<i class="sb-icon sb-rss" title="RSS"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc, 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_soundcloud',
                'title' => __( '<i class="sb-icon sb-soundcloud" title="SoundCloud"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br />SoundCloud requires an Access Token to provide the feed\'s data. <a href="'. AXS_DOCS . '#soundcloud-api" target="_blank">Check this tutorial</a> for more details.', 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_id' => 'section_vk',
                'title' => __( '<i class="sb-icon sb-vk" title="VK"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br />VK requires a Service Token to display the feed\'s data. <a href="'. AXS_DOCS . '#vk-api" target="_blank">Check this tutorial</a> for more details.', 'social-board-admin' ),
                'show_debug_info' => false
            ),
			array(
				'section_id' => 'section_wordpress',
				'title' => __( '<i class="sb-icon sb-wordpress" title="Wordpress"></i>', 'social-board-admin' ),
				'description' => __( $tabDesc, 'social-board-admin' ),
				'show_debug_info' => false
			),
            array(
                'section_id' => 'section_tiktok',
                'title' => __( '<i class="sb-icon sb-tiktok" title="TikTok"></i>', 'social-board-admin' ),
                'description' => __( $tabDesc . '<br /><a href="'. AXS_DOCS . '#tiktok-api" target="_blank">Check this tutorial</a> for more details on how to connect your TikTok accounts to the plugin.', 'social-board-admin' ),
                'show_debug_info' => false
            ),
            array(
                'section_tab_slug' => '' // reset the target tab slug for the next use.
            )
        );

        $this->addSettingFields(
            // Facebook
            array(
                'section_id'    => 'section_facebook',
                'field_id'      => 'facebook_id_1',
                'type'          => 'inline_mixed',
                'title'         => __( '1. Facebook Page Feed', 'social-board-admin' ),
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
                            'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
                            'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'The feed of posts (including status updates), photos and links on this page.<br />Enter the page Username or ID - e.g. <code>envato</code> or, <code>80655071208</code>.', 'social-board-admin' )
                // You can find your Facebook page ID in your Facebook page setting tab or obtain it from <a href="https://findmyfbid.com" target="_blank">this website</a>
            ),
            array(
                'field_id'      => 'facebook_pagefeed',
                'title'         => __( 'Specific sets of posts', 'social-board-admin' ),
                'description'   => __( 'Get specific sets of posts for Facebook page feed. You will not have an exact number of results if you use filtering posts.', 'social-board-admin' ),
                'type'          => 'radio',
                'default'       => 'posts',
                'label'         => array(
                    'posts' => "Shows only the posts that were published by this page (Filters the others' posts from the total result)",
                    'tagged' => 'Shows all public posts by others in which the page has been tagged (Filters the posts published by this page from the total result)',
                    'feed' => 'Show both (Do not filter)'
                )
			),
			// Facebook Group
            array(
                'section_id' => 'section_facebook',
                'field_id' => 'facebook_id_2',
                'title' => __( '2. Facebook Group Feed', 'social-board-admin' ),
                'type' => 'inline_mixed',
                'repeatable' => true,
				'content'       => array(
					array(
						'field_id'        => 'feed',
						'type'            => 'text',
						'attributes'      => array(
							'fieldset'    => array(
								'style'   => 'min-width: 200px;'
							),
							'placeholder' => __( 'Feed', 'social-board-admin' )
						)
					),
					array(
						'field_id'        => 'limit',
						'type'            => 'number',
						'default'         => 5,
						'attributes'      => array(
							'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
						)
					)
				),
                'description' => __( 'The feed of posts (including status updates), photos and links on this group.<br />Enter the group ID - e.g. <code>7091225894</code>. You can find it in your Facebook group setting tab or obtain it from <a href="https://lookup-id.com/" target="_blank">this website</a>', 'social-board-admin' )
            ),
            array(
                'section_id'     => 'section_facebook',
                'field_id'      => 'facebook_id_3',
                'title'         => __( '3. Facebook Album/Page Photos', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'Shows all photos this page is tagged in.<br />Enter the page Username or ID - e.g. <code>182472465104731</code> to get all the albums photos or, the page Username or ID then "/" followed by the album ID - e.g. <code>182472465104731/947092091976094</code> to get a specific album of a page. <a href="'. AXS_DOCS . '#facebook-id" target="_blank">Check this tutorial</a> on how to find a Facebook album ID.', 'social-board-admin' )
            ),
            array(
                'section_id'    => 'section_facebook',
                'field_id'      => 'facebook_id_4',
                'title'         => __( '4. Facebook Page Videos', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'Shows all videos this page is tagged in.<br />Enter the page Username or ID - e.g. <code>envato</code> or, <code>80655071208</code>. <a href="'. AXS_DOCS . '#facebook-id" target="_blank">Check this tutorial</a> on how to find a Facebook page ID.', 'social-board-admin' )
            ),
            // User posts feed
            array(
                'section_id'    => 'section_facebook',
                'field_id'      => 'facebook_id_6',
                'type'          => 'inline_mixed',
                'title'         => __( '6. Facebook User Feed', 'social-board-admin' ),
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
                            'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
                            'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'The feed of posts (including status updates), photos and links on this user timeline.<br />Enter the Username or User ID - e.g. <code>zuck</code> or, <code>100001533612613</code>.', 'social-board-admin' )
            ),
            array( // Single date/time range picker
                'field_id' => 'facebook_datetime_range',
                'title' => __( 'Date Time Range', 'social-board-admin' ),
                'type' => 'date_time_range',
                'description' => __( 'Get posts in a certain date/time from Facebook feed.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'facebook_comments',
                'title' => __( 'Comments Count', 'social-board-admin' ),
                'type' => 'number',
                'default' => 3,
                'description' => __( 'Enter the number of comments to display for facebook album photos<br />Set to 0 to disable comments.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'facebook_likes',
                'title' => __( 'Likes', 'social-board-admin' ),
                'type' => 'number',
                'default' => 5,
                'description' => __( 'Number of likes to display - set to 0 to disable likes.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'facebook_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all images/videos will be open in a lightbox window - (Iframe/Direct Link To Facebook)<br />* This feature will not work on all video services.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'facebook_embed',
                'type' => 'checkbox',
                'title' => __( 'Embed links', 'social-board-admin' ),
                'label' => __( 'Show shared links as Embed iframe', 'social-board-admin' ),
                'default' => false,
                'description' => __( 'If checked, all shared links within your posts will be converted to Embed iframes.', 'social-board-admin' )
            ),
            array(
                'field_id'      => 'facebook_image_width',
                'type'          => 'select',
                'title'         => __( 'Image width', 'social-board-admin' ),
                'description'   => __( 'Select the image width for Facebook gallery album posts. If the selected size was not available, a smaller size will be selected', 'social-board-admin' ),
                'default'       => '300',
                'label' => array(
                    '180'   => __( 'Thumb - 180px', 'social-board-admin' ),
                    '300'   => __( 'Tiny - 300px', 'social-board-admin' ),
                    '480'   => __( 'Very Small - 480px', 'social-board-admin' ),
                    '640'   => __( 'Small - 640px', 'social-board-admin' ),
                    '720'   => __( 'Medium - 720px', 'social-board-admin' ),
                    '800'   => __( 'Large - 800px', 'social-board-admin' ),
                    '960'   => __( 'Larger - 960px', 'social-board-admin' ),
                    '1280'  => __( 'X-Large - 1280px', 'social-board-admin' ),
                    '1600'  => __( 'XX-Large - 1600px', 'social-board-admin' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;",
                    )
                )
            ),
            array(
                'field_id'      => 'facebook_video_width',
                'type'          => 'select',
                'title'         => __( 'Video width', 'social-board-admin' ),
                'description'   => __( 'Select the video width for Facebook page video posts. If the selected size was not available, a smaller size will be selected by default.', 'social-board-admin' ),
                'default'       => '720',
                'label' => array(
                    '130'   => __( 'Thumb - 130px', 'social-board-admin' ),
                    '480'   => __( 'Small - 480px', 'social-board-admin' ),
                    '720'   => __( 'Medium - 720px', 'social-board-admin' ),
                    '1080'   => __( 'Large - 1080px', 'social-board-admin' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;",
                    )
                )
            ),
            // Twitter
            array(
                'section_id'    => 'section_twitter',
                'field_id'      => 'twitter_id_1',
                'type'          => 'inline_mixed',
                'title'         => __( '1. Twitter Username', 'social-board-admin' ),
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
                            'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
                            'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'Enter a Twitter Username without "@" - e.g. <code>500px</code> or User ID - e.g. <code>20431922</code>', 'social-board-admin' )
            ),
            array(
                'section_id'    => 'section_twitter',
                'field_id'      => 'twitter_id_2',
                'type'          => 'inline_mixed',
                'title'         => __( '2. Twitter List', 'social-board-admin' ),
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
                            'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
                            'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'To show a Twitter list feed enter the List ID - e.g. <code>84839422</code>', 'social-board-admin' )
            ),
            array(
                'section_id'    => 'section_twitter',
                'field_id'      => 'twitter_id_3',
                'type'          => 'inline_mixed',
                'title'         => __( '3. Hashtag', 'social-board-admin' ),
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
                            'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
                            'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'To search enter the hashtag - e.g. <code>#socialmedia</code>', 'social-board-admin' )
            ),
            /*
            array(
                'section_id'    => 'section_twitter',
                'field_id'      => 'twitter_id_4',
                'type'          => 'inline_mixed',
                'title'         => __( '4. Search Term', 'social-board-admin' ),
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
                            'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
                            'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'To search enter the search term - e.g. <code>socialmedia</code>', 'social-board-admin' )
            ),
            */
            array( // Multiple text fields
                'field_id'          => 'twitter_id_range',
                'title'             => __( 'ID Range', 'social-board-admin' ),
                'type'              => 'text',
                'label'             => __( 'Since ID', 'social-board-admin' ) . ': ',
                'attributes'        => array(
                    'size' => 20,
                ),
                'capability'        => 'manage_options',
                'delimiter'         => '<br />',
                array(
                    'label'         => __( 'Max ID', 'social-board-admin' ) . ': ',
                    'attributes'    => array(
                        'size' => 20
                    )
                ),     
                'description'       => __( 'Get posts in a certain ID range from Twitter feed. <a href="'. AXS_DOCS . '#tweet-id" target="_blank">Check this tutorial</a> on how to find a Tweet ID.<br /><strong>Since ID: </strong>Returns results with an ID greater than (that is, more recent than) the specified ID.<br /><strong>Max ID: </strong>Returns results with an ID less than (that is, older than) or equal to the specified ID.', 'social-board-admin' )
            ),
            array(
                'field_id'      => 'twitter_images',
                'type'          => 'select',
                'title'         => __( 'Image width', 'social-board-admin' ),
                'description'   => __( 'Select the image width for Twitter images.', 'social-board-admin' ),
                'default'       => 'small',
                'label' => array( 
                    'thumb'   => __( 'Thumb - 150px', 'social-board-admin' ),
                    'small'   => __( 'Small - 340px', 'social-board-admin' ),
                    'medium' => __( 'Medium - 600px', 'social-board-admin' ),
                    'large' => __( 'Large - 1024px', 'social-board-admin' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;"
                    )
                )
            ),
            array(
                'field_id' => 'twitter_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all media will be open in a lightbox window - (Iframe/Direct Link To Twitter).', 'social-board-admin' )
            ),
            array(
                'field_id' => 'twitter_embed',
                'type' => 'checkbox',
                'title' => __( 'Embed links', 'social-board-admin' ),
                'label' => __( 'Show shared links as Embed iframe', 'social-board-admin' ),
                'default' => false,
                'description' => __( 'If checked, all shared links within your tweets will be converted to Embed iframes.', 'social-board-admin' )
            ),
            array(
                'field_id'      => 'twitter_feeds',
                'title'         => __( 'Feed Data', 'social-board-admin' ),
                'type'          => 'checkbox',
                'label'         => array(
                    'retweets' => __( 'Retweets', 'social-board-admin' ) . ' (' . __( 'Include feed item retweets', 'social-board-admin' ) . ')',
                    'replies' => __( 'Replies', 'social-board-admin' ) . ' (' . __( 'Include replies', 'social-board-admin' ) . ')'
                ),
                'default' => array(
                    'retweets' => true,
                    'replies' => true
                ),
                'description'   => __( 'Feed data to be gathered and displayed.', 'social-board-admin' ),
                'after_label'   => '<br />'
            ),
            array(
                'section_id'    => 'section_tumblr',
                'field_id'      => 'tumblr_id_1',
                'title'         => __( 'Tumblr Username', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'description' => __( 'Enter a Tumblr username - e.g. <code>username</code>', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'tumblr_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open images in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all images will be open in a lightbox window - (Iframe/Direct Link To Tumblr).', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'tumblr_embed',
                'type' => 'checkbox',
                'title' => __( 'Embed video', 'social-board-admin' ),
                'label' => __( 'Show videos embedded', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all videos will be displayed inline - (Embed/Direct Link To Tumblr).', 'social-board-admin' ),
            ),
            array(
                'field_id'      => 'tumblr_thumb',
                'type'          => 'select',
                'title'         => __( 'Thumbnail Width', 'social-board-admin' ),
                'description'   => __( 'Select the width of the thumbnail image.', 'social-board-admin' ),
                'default'       => '250',
                'label' => array( 
                    '75'   => __( 'Width: 75px', 'social-board-admin' ),
                    '100'   => __( 'Width: 100px', 'social-board-admin' ),
                    '250' => __( 'Width: 250px', 'social-board-admin' ),
                    '400' => __( 'Width: 400px', 'social-board-admin' ),
                    '500' => __( 'Width: 500px', 'social-board-admin' ),
                    '1280' => __( 'Width: 1280px', 'social-board-admin' ),
                ),
                'attributes'    => array(
                    'select' => array(
                        'style' => "width: 200px;",
                    ),
                ),
            ),
            array(
                'field_id'      => 'tumblr_video',
                'type'          => 'select',
                'title'         => __( 'Video Width', 'social-board-admin' ),
                'description'   => __( 'Width of inline video player.', 'social-board-admin' ),
                'default'       => '500',
                'label' => array( 
                    '250'   => __( 'Width: 250px', 'social-board-admin' ),
                    '400'   => __( 'Width: 400px', 'social-board-admin' ),
                    '500' => __( 'Width: 500px', 'social-board-admin' ),
                ),
                'attributes'    => array(
                    'select' => array(
                        'style' => "width: 200px;"
                    )
                )
            ),
            array(
                'section_id' => 'section_delicious',
                'field_id' => 'delicious_id_1',
                'title' => __( 'Delicious username', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Enter a Delicious username - e.g. <code>username</code>', 'social-board-admin' )
            ),
            array(
                'section_id' => 'section_pinterest',
                'field_id' => 'pinterest_id_1',
                'title' => __( '1. Pinterest username', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Enter a Pinterest username - e.g. <code>username</code>', 'social-board-admin' )
            ),
            array(
                'field_id' => 'pinterest_id_2',
                'title' => __( '2. Pinterest board', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'To show a Pinterest board enter the username, then "/" followed by the board name - e.g. <code>username/board_name</code>', 'social-board-admin' )
            ),
            array(
                'field_id'      => 'pinterest_image_width',
                'type'          => 'select',
                'title'         => __( 'Image width', 'social-board-admin' ),
                'description'   => __( 'Select the image width for Pinterest images.', 'social-board-admin' ),
                'default'       => '237',
                'label' => array(
                    '237'   => __( 'Thumb - 237px', 'social-board-admin' ),
                    '736'   => __( 'Large - 736px', 'social-board-admin' )
                ),
                'attributes' => array(
                    'select' => array(
                        'style' => "width: 200px;"
                    )
                )
            ),
            array(
                'field_id' => 'pinterest_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all images/videos will be open in a lightbox window - (Iframe/Direct Link To Pinterest)', 'social-board-admin' )
            ),
            array(
                'section_id' => 'section_flickr',
                'field_id' => 'flickr_id_1',
                'title' => __( '1. Flickr User ID', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Enter a Flickr User ID - e.g. <code>46221135@N04</code> - You can obtain it from <a href="http://idgettr.com/" target="_blank">this website</a>', 'social-board-admin' )
            ),
            array(
                'section_id' => 'section_flickr',
                'field_id' => 'flickr_id_2',
                'title' => __( '2. Flickr Group ID', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'To use a flickr group enter the group ID - e.g. <code>34427465497@N01</code> - Use the same website mentioned above.', 'social-board-admin' )
            ),
            array(
                'section_id' => 'section_flickr',
                'field_id' => 'flickr_id_3',
                'title' => __( '3. Flickr Photoset/Album ID', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'To get the list of photos in a set, enter the Photoset/Album ID - e.g. <code>72157633763860095</code> - To obtain it, browse to the list of your albums in your Flickr account, click on an album and the Album ID would be the last number in your address bar url.', 'social-board-admin' )
            ),
            array(
                'field_id'      => 'flickr_thumb',
                'type'          => 'select',
                'title'         => __( 'Thumbnail Size', 'social-board-admin' ),
                'description'   => __( 'Size of thumbnail image.', 'social-board-admin' ),
                'default'       => 'm',
                'label' => array(
                    's' => __( 'small square 75x75', 'social-board-admin' ),
                    'q' => __( 'large square 150x150', 'social-board-admin' ),
                    't' => __( 'thumbnail, 100 on longest side', 'social-board-admin' ),
                    'm' => __( 'small, 240 on longest side' ),
                    'n'	=> __( 'small, 320 on longest side' ),
                    ''	=> __( 'medium, 500 on longest side' ),
                    'z'	=> __( 'medium 640, 640 on longest side' ),
                    'c'	=> __( 'medium 800, 800 on longest side' ),
                    'b'	=> __( 'large, 1024 on longest side' ),
                    'h'	=> __( 'large 1600, 1600 on longest side' ),
                    'k'	=> __( 'large 2048, 2048 on longest side' ),
                    'o'	=> __( 'original image, either a jpg, gif or png, depending on source format' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;",
                    ),
                ),
            ),
            array(
                'field_id' => 'flickr_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all images will be open in a lightbox window - (Iframe/Direct Link To Flickr).', 'social-board-admin' ),
            ),
            array(
                'section_id' => 'section_instagram',
                'field_id'      => 'instagram_id_1',
                'type'          => 'inline_mixed',
                'title'         => __( '1. Instagram User Feed', 'social-board-admin' ),
                'repeatable'    => true,
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
                            'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
                            'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
				'description' => __( 'Enter the account Username or ID - e.g. <code>500px</code> or, <code>80655071208</code>.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'instagram_id_2',
                'title' => __( '2. Instagram search tag', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'To search by tag enter the tag name (contiguous), e.g. <code>paris</code>', 'social-board-admin' ),
			),
            /*
			array(
                'field_id' => 'instagram_id_3',
                'title' => __( '3. Instagram location ID', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
				'description' => __( 'To show the latest posts by a location, enter the location ID, e.g. 2593354 - <a href="https://axentmedia.com/how-to-find-an-instagram-location-id/" target="_blank">Read the article</a> on How to Find an Instagram Location ID?
				<p style="color:red">DOES NOT WORK WITH INSTAGRAM OFFICIAL API!</p>', 'social-board-admin' ),
            ),*/
            array(
                'field_id' => 'instagram_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all images/videos will be open in a lightbox window - (Iframe/Direct Link To Instagram).', 'social-board-admin' ),
			),
			/*
            array(
                'field_id' => 'instagram_full_media',
                'type' => 'checkbox',
                'title' => __( 'Get full media', 'social-board-admin' ),
                'label' => __( 'Get full media information for hashtag and location feeds', 'social-board-admin' ),
                'default' => false,
                'description' => __( '<p style="color:red">DOES NOT WORK WITH INSTAGRAM OFFICIAL API!<br><strong style="text-transform: uppercase;">Attention:</strong> Activating this feature may results getting banned on Instagram network when you are getting feed from multiple hashtags or locations.</p>', 'social-board-admin' )
            ),*/
            array(
                'field_id'      => 'instagram_images',
                'type'          => 'select',
                'title'         => __( 'Image width', 'social-board-admin' ),
                'description'   => __( 'Select the image width for Instagram images.', 'social-board-admin' ),
                'default'       => 'low_resolution',
                'label' => array( 
                    'thumbnail' => __( 'Thumbnail - 150px', 'social-board-admin' ),
                    'low_resolution' => __( 'Low Resolution - 306px', 'social-board-admin' ),
                    'standard_resolution' => __( 'Standard Resolution - 640px', 'social-board-admin' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;",
                    ),
                ),
            ),
            array(
                'field_id' => 'instagram_videos',
                'type' => 'select',
                'title' => __( 'Video width', 'social-board-admin' ),
                'description' => __( 'Select the video width for Instagram videos.', 'social-board-admin' ),
                'default' => 'standard_resolution',
                'label' => array(
                    'low_resolution' => __( 'Low Resolution - 480px', 'social-board-admin' ),
                    'standard_resolution' => __( 'Standard Resolution - 640px', 'social-board-admin' )
                ),
                'attributes' => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;",
                    ),
                ),
            ),
            array(
                'field_id' => 'instagram_comments',
                'title' => __( 'Comments', 'social-board-admin' ),
                'type' => 'number',
                'default' => 3,
                'description' => __( 'Number of comments to display - set to 0 to disable likes.', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'instagram_likes',
                'title' => __( 'Likes', 'social-board-admin' ),
                'type' => 'number',
                'default' => 5,
                'description' => __( 'Number of likes to display - set to 0 to disable likes.', 'social-board-admin' ),
            ),
            array(
                'section_id' => 'section_youtube',
                'field_id' => 'youtube_id_1',
                'title' => __( '1. YouTube username', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Returns a list of videos uploaded by this user - Enter a YouTube username - e.g. <code>username</code>', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'youtube_id_2',
                'title' => __( '2. YouTube playlist', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Returns a collection of playlist videos items - Enter the unique ID of the playlist for which you want to retrieve playlist videos items - e.g. <code>PLsBcifUwsKVXunQPoySupBM6QCcWliTKi</code>', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'youtube_id_3',
                'title' => __( '3. YouTube search term', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Returns a collection of search results that match the search term query you specified - e.g. <code>music</code>', 'social-board-admin' ),
            ),
            array(
                'section_id' => 'section_youtube',
                'field_id' => 'youtube_id_4',
                'title' => __( '4. YouTube channel ID', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Returns a list of videos uploaded by this channel - Enter a YouTube channel ID - e.g. <code>UC1yP5nx6JNEBQI3ps2XFMpz</code>', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'youtube_comments',
                'title' => __( 'Comments Count', 'social-board-admin' ),
                'type' => 'number',
                'default' => 3,
                'description' => __( 'Enter the number of comments to display for YouTube videos<br />Set to 0 to disable comments.', 'social-board-admin' )
            ),
            array(
                'field_id' => 'youtube_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open video in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all videos will be open in a lightbox window - (Iframe/Direct Link To YouTube).', 'social-board-admin' ),
            ),
            array(
                'field_id'      => 'youtube_thumb',
                'type'          => 'select',
                'title'         => __( 'Thumbnail Size', 'social-board-admin' ),
                'description'   => __( 'Select YouTube image size.', 'social-board-admin' ),
                'default'       => 'medium',
                'label' => array(
                    'default' => __( 'Default - 120px × 90px', 'social-board-admin' ),
                    'medium' => __( 'Medium - 320px × 180px', 'social-board-admin' ),
                    'high' => __( 'High - 480px × 360px', 'social-board-admin' ),
                    'standard' => __( 'Standard - 640px × 480px', 'social-board-admin' ),
                    'maxres' => __( 'Max - 1280px × 720px', 'social-board-admin' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;"
                    )
                )
            ),
            array(
                'field_id'      => 'youtube_video',
                'type'          => 'select',
                'title'         => __( 'Video light-box Size', 'social-board-admin' ),
                'description'   => __( 'Select a custom light-box size for YouTube videos. Social Stream will add extra 100px to the light-box height for better view.', 'social-board-admin' ),
                'default'       => '640-240',
                'label' => array( 
                    '1280-720' => __( 'Medium - 1280px × 720px', 'social-board-admin' ),
                    '854-480' => __( 'High - 854px × 480px', 'social-board-admin' ),
                    '640-360' => __( 'Default - 640px × 360px', 'social-board-admin' ),
                    '426-240' => __( 'Standard - 426px × 240px', 'social-board-admin' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;"
                    )
                )
            ),
            array(
                'section_id' => 'section_vimeo',
                'field_id' => 'vimeo_id_1',
                'title' => __( 'Vimeo username', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Enter a Vimeo username - e.g. <code>jobjorisenmarieke</code>', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'vimeo_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open video in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all videos will be open in a lightbox window - (Iframe/Direct Link To Vimeo).', 'social-board-admin' ),
            ),
            array(
                'field_id'      => 'vimeo_thumb',
                'type'          => 'select',
                'title'         => __( 'Thumbnail Size', 'social-board-admin' ),
                'description'   => __( 'Size of thumbnail image.', 'social-board-admin' ),
                'default'       => '295',
                'label' => array( 
                    '100'   => __( 'Thumb - 100x75', 'social-board-admin' ),
                    '200'   => __( 'Tiny - 200x150', 'social-board-admin' ),
                    '295'   => __( 'Small - 295x166', 'social-board-admin' ),
                    '640'   => __( 'Medium - 640x360', 'social-board-admin' ),
                    '960'   => __( 'Large - 960x540', 'social-board-admin' ),
                    '1280'  => __( 'Larger - 1280x720', 'social-board-admin' ),
                    '1920'  => __( 'X-Large - 1920x1080', 'social-board-admin' )
                ),
                'attributes' => array(
                    'select' => array(
                        'style' => "width: 200px;"
                    )
                )
            ),
            array(
                'section_id' => 'section_deviantart',
                'field_id' => 'deviantart_id_1',
                'title' => __( 'Deviantart username', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Enter a Deviantart username - e.g. <code>abcd</code>', 'social-board-admin' ),
            ),
            array(
                'section_id' => 'section_soundcloud',
                'field_id' => 'soundcloud_id_1',
                'title' => __( '1. SoundCloud User Tracks', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'The list of user\'s tracks.<br />Enter the SoundCloud Username - e.g. <code>matas</code>', 'social-board-admin' ),
            ),
            array(
                'section_id' => 'section_soundcloud',
                'field_id' => 'soundcloud_id_2',
                'title' => __( '2. SoundCloud Playlist Tracks', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'The list of tracks under a playlist.<br />Enter the SoundCloud Username then "/" followed by the Playlist Slug - e.g. <code>matas/matas-live-dj</code>', 'social-board-admin' ),
            ),
            array(
                'section_id' => 'section_soundcloud',
                'field_id' => 'soundcloud_id_3',
                'title' => __( '3. SoundCloud Tracks Search', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Performs a track search based on a query.<br />Enter a search term - e.g. <code>paris</code>', 'social-board-admin' ),
            ),
            // RSS
            array(
                'section_id' => 'section_rss',
                'field_id' => 'rss_id_1',
                'title' => __( 'RSS feed URL', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Enter the RSS feed URL - e.g. <code>https://feeds.bbci.co.uk/news/world/europe/rss.xml</code>', 'social-board-admin' ),
            ),
            array(
                'field_id'      => 'rss_text',
                'title'         => __( 'Text Info', 'social-board-admin' ),
                'description'   => __( 'Select Snippet for displaying a summary of the post or select Full Text to include any links or images in the feed - if available.', 'social-board-admin' ),
                'type'          => 'radio',
                'default'       => 0,
                'label'         => array(
                    0 => 'Full Text',
                    1 => 'Snippet'
                )
            ),
            array(
                'field_id' => 'rss_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all images/videos will be open in a lightbox window - (Iframe/Direct Link To RSS Post)<br />* This feature will not work on all video services.', 'social-board-admin' ),
            ),
            array(
                'field_id'      => 'rss_image_width',
                'type'          => 'select',
                'title'         => __( 'Thumbnails width', 'social-board-admin' ),
                'description'   => __( 'Select the image width for RSS feed images. If you select any size different than original size, it will enable the Social Stream image proxy that <strong>may slow up the process</strong>.', 'social-board-admin' ),
                'default'       => '',
                'label' => array(
                    ''  => __( 'Original width', 'social-board-admin' ),
                    '180'   => __( 'Thumb - 180px', 'social-board-admin' ),
                    '300'   => __( 'Tiny - 300px', 'social-board-admin' ),
                    '480'   => __( 'Very Small - 480px', 'social-board-admin' ),
                    '640'   => __( 'Small - 640px', 'social-board-admin' ),
                    '720'   => __( 'Medium - 720px', 'social-board-admin' ),
                    '800'   => __( 'Large - 800px', 'social-board-admin' ),
                    '960'   => __( 'Larger - 960px', 'social-board-admin' ),
                    '1200'  => __( 'X-Large - 1200px', 'social-board-admin' )
                ),
                'attributes'    => array( // the 'attributes' element of the select field type has three keys: select, 'option', and 'optgroup'.
                    'select' => array(
                        'style' => "width: 200px;",
                    ),
                ),
            ),
            // VK
            array(
                'section_id' => 'section_vk',
                'field_id' => 'vk_id_1',
                'title' => __( '1. VK Wall Domain', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Returns a list of posts on a user wall or community wall.<br />Enter the user or community short address - e.g. <code>wphelpme</code> or, ID of the user or community that owns the wall - e.g. <code>id99999999</code>.', 'social-board-admin' ),
            ),
            array(
                'section_id' => 'section_vk',
                'field_id' => 'vk_id_2',
                'title' => __( '2. VK Wall Owner ID', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Returns a list of posts on a user wall or community wall.<br />Enter the ID of the user or community that owns the wall. By default, current user ID - e.g. <code>99999999</code>. Use a negative value <code>-</code> to designate a community ID - e.g. <code>-99999999</code>.', 'social-board-admin' ),
            ),
			array(
				'section_id'    => 'section_vk',
				'field_id'      => 'vk_id_3',
				'type'          => 'inline_mixed',
				'title'         => __( '3. Search Term/Hashtag', 'social-board-admin' ),
				'repeatable'    => true,
				'content'       => array(
					array(
						'field_id'        => 'feed',
						'type'            => 'text',
						'attributes'      => array(
							'fieldset'    => array(
								'style'   => 'min-width: 200px;'
							),
							'placeholder' => __( 'Feed', 'social-board-admin' )
						)
					),
					array(
						'field_id'        => 'limit',
						'type'            => 'number',
						'default'         => 5,
						'attributes'      => array(
							'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
						)
					)
				),
				'description' => __( 'To search enter the search term - e.g. <code>socialmedia</code> or hashtag - e.g. <code>#socialmedia</code>', 'social-board-admin' )
			),
            array(
                'field_id'      => 'vk_pagefeed',
                'title'         => __( 'Filter to apply', 'social-board-admin' ),
                'description'   => __( 'Apply filter and get specific sets of posts from VK wall feed.', 'social-board-admin' ),
                'type'          => 'radio',
                'default'       => 'all',
                'label'         => array(
                    'owner' => 'Show only the posts by the wall owner',
                    'tagged' => 'Show the posts by someone else',
                    'all' => 'Show both posts by the wall owner and others'
                )
            ),
            array(
                'field_id'      => 'vk_image_width',
                'type'          => 'select',
                'title'         => __( 'Image width', 'social-board-admin' ),
                'description'   => __( 'Select the image width for VK gallery album posts. If the selected size was not available, a smaller size will be selected', 'social-board-admin' ),
                'default'       => 'x',
                'label' => array(
                    's'   => __( 'Thumb - 75px', 'social-board-admin' ),
                    'm'  => __( 'Small - 130px', 'social-board-admin' ),
                    'x'  => __( 'Medium - 604px', 'social-board-admin' ),
                    'y'  => __( 'Large - 807px', 'social-board-admin' ),
                    'z' => __( 'Larger - 1280px', 'social-board-admin' ),
                    'w' => __( 'X-Large - 2560px', 'social-board-admin' )
                ),
                'attributes' => array(
                    'select' => array(
                        'style' => "width: 200px;",
                    ),
                ),
            ),
            array(
                'field_id' => 'vk_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all images/videos will be open in a lightbox window - (Iframe/Direct Link To VK)<br />* This feature will not work on all video services.', 'social-board-admin' ),
            ),
			// WordPress
			array(
				'section_id' => 'section_wordpress',
				'field_id' => 'wordpress_id_1',
				'title' => __( '1. WordPress Posts by Category', 'social-board-admin' ),
				'type'          => 'inline_mixed',
				'content'       => array(
					array(
						'field_id'   => 'feed',
						'type'       => 'select',
						'default'    => '',
						'label' 	 => $sbwordpress->GetCategoriesSelectList(),
						'attributes' => array(
							'select' => array(
								'style' => "width: 200px;",
							)
						)
					),
					array(
						'field_id'        => 'limit',
						'type'            => 'number',
						'default'         => 5,
						'attributes'      => array(
							'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
						)
					)
				),
				'repeatable' => true
			),
			array(
				'section_id' => 'section_wordpress',
				'field_id' => 'wordpress_id_2',
				'title' => __( '2. WordPress Posts by Tag', 'social-board-admin' ),
				'type'          => 'inline_mixed',
				'content'       => array(
					array(
						'field_id'        => 'feed',
						'type'            => 'text',
						'attributes'      => array(
							'style'       => 'width: 200px',
							'placeholder' => __( 'tag', 'social-board-admin' )
						)
					),
					array(
						'field_id'        => 'limit',
						'type'            => 'number',
						'default'         => 5,
						'attributes'      => array(
							'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
						)
					)
				),
				'repeatable' => true
			),
			array(
				'field_id'      => 'wordpress_text',
				'title'         => __( 'Text Info', 'social-board-admin' ),
				'description'   => __( 'Select Snippet for displaying a summary of the post or select Full Text to include any links or images in the feed - if available.', 'social-board-admin' ),
				'type'          => 'radio',
				'default'       => 0,
				'label'         => array(
					0 => 'Full Text',
					1 => 'Snippet'
				)
			),
			array(
				'field_id' => 'wordpress_iframe',
				'type' => 'checkbox',
				'title' => __( 'Open in Lightbox', 'social-board-admin' ),
				'label' => __( 'Open media in a lightbox window', 'social-board-admin' ),
				'default' => true,
				'description' => __( 'If checked, all images/videos will be open in a lightbox window', 'social-board-admin' )
			),
			array(
				'field_id'      => 'wordpress_image_width',
				'type'          => 'select',
				'title'         => __( 'Thumbnails width', 'social-board-admin' ),
				'default'       => '',
				'label' 		=> $sbwordpress->GetIntermediateImageSizes(),
				'attributes'    => array(
					'select' => array(
						'style' => "width: 200px;"
					)
				)
			),
            array(
                'section_id' => 'section_tiktok',
                'field_id' => 'tiktok_id_1',
                'title' => __( 'TikTok ID', 'social-board-admin' ),
                'type'          => 'inline_mixed',
                'content'       => array(
                    array(
                        'field_id'        => 'feed',
                        'type'            => 'text',
                        'attributes'      => array(
                            'fieldset'    => array(
                                'style'   => 'min-width: 200px;'
                            ),
							'placeholder' => __( 'Feed', 'social-board-admin' )
                        )
                    ),
                    array(
                        'field_id'        => 'limit',
                        'type'            => 'number',
                        'default'         => 5,
                        'attributes'      => array(
                            'style'       => 'width: 40px',
							'placeholder' => __( 'Result', 'social-board-admin' )
                        )
                    )
                ),
                'repeatable' => true,
                'description' => __( 'Enter a tiktok ID - e.g. <code>3d81ebaa-5e7b-5192-a65d-a98c1aca4a40</code>', 'social-board-admin' ),
            ),
            array(
                'field_id' => 'tiktok_iframe',
                'type' => 'checkbox',
                'title' => __( 'Open in Lightbox', 'social-board-admin' ),
                'label' => __( 'Open video in a lightbox window', 'social-board-admin' ),
                'default' => true,
                'description' => __( 'If checked, all videos will be open in a lightbox window - (Iframe/Direct Link To TikTok).', 'social-board-admin' ),
            ),
            array()
        );
    }
    
    public function do_AXS_MetaBox_Social_Boards() {
        echo __( '<div class="admin-page-framework-section-title"><h3>Social Networks</h3></div>', 'social-board-admin' );
    }

    /**
     * Returns the form data.
     * 
     * @callback    filter      options_{instantiated class name}
     * @return      array       The form data as a multi-dimensional array.
     */
    public function options_AXS_MetaBox_Social_Boards( $aOptions ) {
        // r3.6.0 < compatibility fix
        if ( isset($_GET['post']) ) {
            if ( ! empty($aOptions) ) {
                $networks = array(
                    'facebook',
                    'twitter',
                    'tumblr',
                    'delicious',
                    'pinterest',
                    'flickr',
                    'instagram',
                    'youtube',
                    'vimeo',
                    'stumbleupon',
                    'deviantart',
                    'rss',
                    'soundcloud',
                    'vk',
                    'linkedin',
					'vine',
					'wordpress'
                );
                $feedDefaults = array();
                foreach ($networks as $key) {
                    if ( isset($aOptions['section_'.$key]) && $keyitems = $aOptions['section_'.$key] ) {
                        for ($i = 1; $i <= 5; $i++) {
                            $fitem = $keyitems[$key.'_id_'.$i][0] ?? '';
                            if ( ! empty($fitem) && is_string($fitem) ) {
                                foreach ($keyitems[$key.'_id_'.$i] as $val)
                                $feedDefaults['section_'.$key][$key.'_id_'.$i][] = array(
                                    'feed' => $val
                                );
                            }
                        }
                    }
                }
            }
        }

        if ( ! empty($feedDefaults) ) {
            // Replace this with function that retrieves form data
            $_aOptions = get_transient( get_class( $this ) );
            $_aOptions = is_array( $_aOptions ) ? $_aOptions : array();
            return $_aOptions + $feedDefaults;
        } else {
            return $aOptions;
        }
        // END - r3.6.0 < compatibility fix
    }
}
