<?php
/**
 * The template for displaying search form.
 *
 * @package Rvdx Theme
 */
?>
<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php echo _x( 'Search for:', 'label', 'voelas' ) ?></span>
		<input type="search" class="search-form__field" placeholder="<?php echo esc_attr_x( 'Search', 'placeholder', 'voelas' ) ?>" value="<?php echo get_search_query() ?>" name="s">
	</label>
	<button type="submit" class="search-form__submit btn btn-primary"><?php echo esc_html__( 'Search', 'voelas' ) ?></button>
</form>
